/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.values;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.javaFX.css.values.JavaFxColorTemplateExpression;

public class JavaFxEffectPropertyValue
extends CssUserLookupBase {
    @NonNls
    private static final String[] CONSTANTS = new String[]{"gaussian", "one-pass-box", "three-pass-box", "two-pass-box"};
    private final String myFunctionName;

    public JavaFxEffectPropertyValue(String functionName) {
        super(functionName);
        this.myFunctionName = functionName;
    }

    protected TemplateImpl createTemplate() {
        TemplateImpl template = new TemplateImpl(this.myFunctionName, "");
        ConstantNode blurTypeExpr = new ConstantNode("gaussian").withLookupStrings(CONSTANTS);
        template.addTextSegment(this.myFunctionName + "(");
        template.addVariable("blur-type", (Expression)blurTypeExpr, (Expression)blurTypeExpr, true);
        template.addTextSegment(", ");
        template.addVariable("color", (Expression)new JavaFxColorTemplateExpression(), true);
        template.addTextSegment(", ");
        ConstantNode radiusExpression = new ConstantNode("10");
        template.addVariable("radius", (Expression)radiusExpression, (Expression)radiusExpression, true);
        template.addTextSegment(", ");
        ConstantNode spreadExpression = new ConstantNode("1.0");
        template.addVariable("spread", (Expression)spreadExpression, (Expression)spreadExpression, true);
        template.addTextSegment(", ");
        ConstantNode xyExpression = new ConstantNode("100");
        template.addVariable("x", (Expression)xyExpression, (Expression)xyExpression, true);
        template.addTextSegment(", ");
        template.addVariable("y", (Expression)xyExpression, (Expression)xyExpression, true);
        template.addTextSegment(")");
        return template;
    }
}

