/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.tree;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.filter.KarmaBrowserErrorFilter;
import com.intellij.javascript.karma.filter.KarmaSourceMapStacktraceFilter;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.testFramework.util.BrowserStacktraceFilters;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaTestProxyFilterProvider
implements TestProxyFilterProvider {
    private final Project myProject;
    private final KarmaServer myKarmaServer;

    public KarmaTestProxyFilterProvider(@NotNull Project project, @Nullable KarmaServer karmaServer) {
        if (project == null) {
            KarmaTestProxyFilterProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myKarmaServer = karmaServer;
    }

    @Nullable
    public Filter getFilter(@NotNull String nodeType, @NotNull String nodeName, @Nullable String nodeArguments) {
        String baseDir;
        AbstractFileHyperlinkFilter browserFilter;
        if (nodeType == null) {
            KarmaTestProxyFilterProvider.$$$reportNull$$$0(1);
        }
        if (nodeName == null) {
            KarmaTestProxyFilterProvider.$$$reportNull$$$0(2);
        }
        if ("browser".equals(nodeType) && (browserFilter = BrowserStacktraceFilters.createFilter((String)nodeName, (Project)this.myProject, (String)(baseDir = this.myKarmaServer == null ? null : this.myKarmaServer.getServerSettings().getWorkingDirectorySystemDependent()))) != null) {
            return new KarmaSourceMapStacktraceFilter(this.myProject, baseDir, browserFilter);
        }
        if ("browserError".equals(nodeType)) {
            return this.getBrowserErrorFilter();
        }
        return null;
    }

    @Nullable
    private String getBasePath() {
        if (this.myKarmaServer != null) {
            KarmaConfig karmaConfig = this.myKarmaServer.getKarmaConfig();
            if (karmaConfig != null) {
                return karmaConfig.getBasePath();
            }
            return this.myKarmaServer.getServerSettings().getWorkingDirectorySystemDependent();
        }
        return null;
    }

    @Nullable
    private Filter getBrowserErrorFilter() {
        String basePath = this.getBasePath();
        return basePath != null ? new KarmaBrowserErrorFilter(this.myProject, basePath) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/karma/tree/KarmaTestProxyFilterProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

