/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.connections.AbstractP4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;

public class P4ParametersConnection
extends AbstractP4Connection {
    private final P4ConnectionParameters myParameters;
    private final ConnectionId myConnectionId;
    private final File myCwd;

    public P4ParametersConnection(@NotNull P4ConnectionParameters parameters, @NotNull ConnectionId connectionId) {
        if (parameters == null) {
            P4ParametersConnection.$$$reportNull$$$0(0);
        }
        if (connectionId == null) {
            P4ParametersConnection.$$$reportNull$$$0(1);
        }
        this.myParameters = parameters;
        this.myConnectionId = connectionId;
        this.myCwd = this.myConnectionId.myWorkingDir == null ? new File(".") : new File(this.myConnectionId.myWorkingDir);
    }

    @Override
    public void runP4Command(PerforcePhysicalConnectionParametersI parameters, String[] p4args, ExecResult retVal, @Nullable StringBuffer inputStream) {
        this.runP4CommandImpl(parameters, ArrayUtilRt.EMPTY_STRING_ARRAY, p4args, retVal, inputStream);
    }

    @Override
    @NotNull
    public File getWorkingDirectory() {
        File file = this.myCwd;
        if (file == null) {
            P4ParametersConnection.$$$reportNull$$$0(2);
        }
        return file;
    }

    @Override
    @NotNull
    public ConnectionKey getConnectionKey() {
        return new ConnectionKey(StringUtil.notNullize((String)this.myParameters.getServer()), StringUtil.notNullize((String)this.myParameters.getClient()), StringUtil.notNullize((String)this.myParameters.getUser()));
    }

    @Override
    public ConnectionId getId() {
        return this.myConnectionId;
    }

    @Override
    public boolean handlesFile(File file) {
        return !this.myConnectionId.myUseP4Config || FileUtil.isAncestor((File)this.myCwd, (File)file, (boolean)false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        P4ParametersConnection that = (P4ParametersConnection)o;
        return this.myConnectionId.equals(that.myConnectionId);
    }

    public int hashCode() {
        return this.myConnectionId.hashCode();
    }

    public P4ConnectionParameters getParameters() {
        return this.myParameters;
    }

    public String toString() {
        return "P4ParametersConnection{" + String.valueOf(this.myParameters) + "}" + System.identityHashCode(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/P4ParametersConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/P4ParametersConnection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

