/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.ide.highlighter.PbSyntaxHighlighter;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.annotation.EnumTracker;
import com.intellij.protobuf.lang.annotation.MessageFieldTracker;
import com.intellij.protobuf.lang.annotation.OptionOccurrenceTracker;
import com.intellij.protobuf.lang.annotation.SharedAnnotations;
import com.intellij.protobuf.lang.annotation.SpecialOptionTracker;
import com.intellij.protobuf.lang.intentions.PbAddImportPathIntention;
import com.intellij.protobuf.lang.psi.PbAggregateValue;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbEnumReservedStatement;
import com.intellij.protobuf.lang.psi.PbEnumValue;
import com.intellij.protobuf.lang.psi.PbExtendBody;
import com.intellij.protobuf.lang.psi.PbExtendDefinition;
import com.intellij.protobuf.lang.psi.PbExtensionName;
import com.intellij.protobuf.lang.psi.PbExtensionsStatement;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbIdentifierValue;
import com.intellij.protobuf.lang.psi.PbImportName;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbLiteral;
import com.intellij.protobuf.lang.psi.PbMapField;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbMessageTypeName;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbNumberValue;
import com.intellij.protobuf.lang.psi.PbOneofBody;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.PbPackageName;
import com.intellij.protobuf.lang.psi.PbPackageStatement;
import com.intellij.protobuf.lang.psi.PbReservedStatement;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbStringPart;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolContributor;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.PbSymbolPath;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.PbVisitor;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.protobuf.lang.psi.SpecialOptionType;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.resolve.PbFileResolver;
import com.intellij.protobuf.lang.util.BuiltInType;
import com.intellij.protobuf.lang.util.ValueTester;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PbAnnotator
implements Annotator,
DumbAware {
    private static final ImmutableSet<BuiltInType> ALLOWED_KEY_TYPES = Sets.immutableEnumSet((Enum)BuiltInType.BOOL, (Enum[])new BuiltInType[]{BuiltInType.INT32, BuiltInType.INT64, BuiltInType.SINT32, BuiltInType.SINT64, BuiltInType.STRING, BuiltInType.UINT32, BuiltInType.UINT64, BuiltInType.FIXED32, BuiltInType.FIXED64, BuiltInType.SFIXED32, BuiltInType.SFIXED64});

    public void annotate(@NotNull PsiElement element, final @NotNull AnnotationHolder holder) {
        if (element == null) {
            PbAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PbAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new PbVisitor(this){

            @Override
            public void visitSymbolPath(@NotNull PbSymbolPath path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                SharedAnnotations.annotateSymbolPath(path, holder);
            }

            @Override
            public void visitImportName(@NotNull PbImportName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                PbAnnotator.annotateImportName(name, holder);
            }

            @Override
            public void visitOptionName(@NotNull PbOptionName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                PbAnnotator.annotateOptionName(name, holder);
            }

            @Override
            public void visitTypeName(@NotNull PbTypeName name) {
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                PbAnnotator.annotateTypeName(name, holder);
            }

            @Override
            public void visitMapField(@NotNull PbMapField mapField) {
                if (mapField == null) {
                    1.$$$reportNull$$$0(4);
                }
                PbAnnotator.annotateMapField(mapField, holder);
                this.visitField(mapField);
            }

            @Override
            public void visitGroupDefinition(@NotNull PbGroupDefinition group) {
                if (group == null) {
                    1.$$$reportNull$$$0(5);
                }
                PbAnnotator.annotateGroupDefinition(group, holder);
            }

            @Override
            public void visitEnumDefinition(@NotNull PbEnumDefinition enumDefinition) {
                if (enumDefinition == null) {
                    1.$$$reportNull$$$0(6);
                }
                PbAnnotator.annotateEnumDefinition(enumDefinition, holder);
            }

            @Override
            public void visitEnumValue(@NotNull PbEnumValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(7);
                }
                PbAnnotator.annotateEnumValue(value, holder);
            }

            @Override
            public void visitEnumReservedStatement(@NotNull PbEnumReservedStatement reservedStatement) {
                if (reservedStatement == null) {
                    1.$$$reportNull$$$0(8);
                }
                PbAnnotator.annotateEnumReservedStatement(reservedStatement, holder);
            }

            @Override
            public void visitExtendDefinition(@NotNull PbExtendDefinition extendDefinition) {
                if (extendDefinition == null) {
                    1.$$$reportNull$$$0(9);
                }
                PbAnnotator.annotateExtendDefinition(extendDefinition, holder);
            }

            @Override
            public void visitOneofDefinition(@NotNull PbOneofDefinition oneofDefinition) {
                if (oneofDefinition == null) {
                    1.$$$reportNull$$$0(10);
                }
                PbAnnotator.annotateOneofDefinition(oneofDefinition, holder);
            }

            @Override
            public void visitField(@NotNull PbField field) {
                if (field == null) {
                    1.$$$reportNull$$$0(11);
                }
                PbAnnotator.annotateField(field, holder);
            }

            @Override
            public void visitReservedStatement(@NotNull PbReservedStatement reservedStatement) {
                if (reservedStatement == null) {
                    1.$$$reportNull$$$0(12);
                }
                PbAnnotator.annotateReservedStatement(reservedStatement, holder);
            }

            @Override
            public void visitExtensionsStatement(@NotNull PbExtensionsStatement extensionsStatement) {
                if (extensionsStatement == null) {
                    1.$$$reportNull$$$0(13);
                }
                PbAnnotator.annotateExtensionsStatement(extensionsStatement, holder);
            }

            @Override
            public void visitOptionExpression(@NotNull PbOptionExpression option) {
                if (option == null) {
                    1.$$$reportNull$$$0(14);
                }
                PbAnnotator.annotateOptionExpression(option, holder);
            }

            @Override
            public void visitStringPart(@NotNull PbStringPart part) {
                if (part == null) {
                    1.$$$reportNull$$$0(15);
                }
                SharedAnnotations.annotateStringPart(part, holder, PbSyntaxHighlighter.INVALID_STRING_ESCAPE);
            }

            @Override
            public void visitPackageStatement(@NotNull PbPackageStatement packageStatement) {
                if (packageStatement == null) {
                    1.$$$reportNull$$$0(16);
                }
                PbAnnotator.annotatePackageStatement(packageStatement, holder);
            }

            public void visitElement(@NotNull PsiElement element) {
                PsiElement parent;
                if (element == null) {
                    1.$$$reportNull$$$0(17);
                }
                if (ProtoTokenTypes.IDENTIFIER_LITERAL.equals(element.getNode().getElementType()) && (parent = element.getParent()) instanceof PbSymbol && element.equals((Object)((PbSymbol)parent).getNameIdentifier())) {
                    PbAnnotator.annotateSymbolName((PbSymbol)parent, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mapField";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "enumDefinition";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 8: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reservedStatement";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extendDefinition";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oneofDefinition";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extensionsStatement";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "option";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "part";
                        break;
                    }
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "packageStatement";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/protobuf/lang/annotation/PbAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSymbolPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitImportName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOptionName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMapField";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitGroupDefinition";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEnumDefinition";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEnumValue";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitEnumReservedStatement";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExtendDefinition";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOneofDefinition";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReservedStatement";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExtensionsStatement";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOptionExpression";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitStringPart";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPackageStatement";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    static PsiElement getSymbolNameAnnotationElement(PbSymbol symbol) {
        PsiElement navigationElement = symbol.getNavigationElement();
        PsiElement nameIdentifier = null;
        if (navigationElement instanceof PsiNameIdentifierOwner) {
            nameIdentifier = ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier();
        }
        return nameIdentifier != null ? nameIdentifier : navigationElement;
    }

    private static PsiElement getOptionNameAnnotationElement(PbOptionName name) {
        PbExtensionName extension = name.getExtensionName();
        if (extension != null) {
            return extension.getSymbolPath().getSymbol();
        }
        return name.getSymbol();
    }

    private static void annotateOptionExpression(PbOptionExpression option, AnnotationHolder holder) {
        PbAnnotator.annotateBuiltInValue(option, holder);
        EnumTracker.annotateOptionExpression(option, holder);
        PbOptionName name = option.getOptionName();
        PbNamedTypeElement namedType = name.getNamedType();
        if (namedType instanceof PbMessageType) {
            PbAnnotator.annotateMessageValue(option, name, holder);
        } else if (namedType instanceof PbEnumDefinition) {
            PbAnnotator.annotateEnumOptionValue(option, holder);
        }
    }

    private static void annotateBuiltInValue(PbOptionExpression option, AnnotationHolder holder) {
        String error;
        ValueTester tester = option.getOptionName().getBuiltInValueTester();
        if (tester == null) {
            return;
        }
        PbLiteral literal = (PbLiteral)PsiTreeUtil.getChildOfType((PsiElement)option, PbLiteral.class);
        if (literal != null && (error = tester.testValue(literal)) != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, error).range(literal.getTextRange()).create();
        }
    }

    private static void annotateMessageValue(PbOptionExpression option, PbOptionName name, AnnotationHolder holder) {
        PbLiteral literal = (PbLiteral)PsiTreeUtil.getChildOfType((PsiElement)option, PbLiteral.class);
        if (literal != null) {
            if (name.getSpecialType() == SpecialOptionType.FIELD_DEFAULT) {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.field.cannot.have.default.value", new Object[0])).range(option.getTextRange()).create();
            } else if (!(literal instanceof PbAggregateValue)) {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("aggregate.value.expected", new Object[0])).range(literal.getTextRange()).create();
            }
        }
    }

    private static void annotateEnumOptionValue(PbOptionExpression option, AnnotationHolder holder) {
        PbLiteral literal = (PbLiteral)PsiTreeUtil.getChildOfType((PsiElement)option, PbLiteral.class);
        if (literal instanceof PbIdentifierValue) {
            SharedAnnotations.annotateEnumOptionValue((PbIdentifierValue)literal, holder);
        } else if (literal != null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("enum.value.expected", new Object[0])).range(literal.getTextRange()).create();
        }
    }

    private static void annotateMapField(PbMapField mapField, AnnotationHolder holder) {
        PbAnnotator.annotateMapFieldKeyType(mapField, holder);
        PbAnnotator.annotateMapFieldEnumValueType(mapField, holder);
    }

    private static void annotateMapFieldKeyType(PbMapField mapField, AnnotationHolder holder) {
        PbTypeName keyType = mapField.getKeyType();
        if (keyType == null) {
            return;
        }
        BuiltInType keyBuiltInType = keyType.getBuiltInType();
        if (keyBuiltInType == null || !ALLOWED_KEY_TYPES.contains((Object)keyBuiltInType)) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("map.key.type", new Object[0])).range((PsiElement)keyType).create();
        }
    }

    private static void annotateMapFieldEnumValueType(PbMapField mapField, AnnotationHolder holder) {
        if (DumbService.isDumb((Project)mapField.getProject())) {
            return;
        }
        PbTypeName valueType = mapField.getValueType();
        if (valueType == null) {
            return;
        }
        PbEnumDefinition enumDef = PbPsiUtil.resolveRefToType(valueType.getEffectiveReference(), PbEnumDefinition.class);
        if (enumDef == null) {
            return;
        }
        PbEnumValue firstValue = enumDef.getEnumValues().stream().findFirst().orElse(null);
        if (firstValue == null) {
            return;
        }
        PbNumberValue numberValue = firstValue.getNumberValue();
        if (numberValue == null) {
            return;
        }
        Long enumNumber = numberValue.getLongValue();
        if (enumNumber != null && enumNumber != 0L) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("map.value.first.enum.value.zero", new Object[0])).range(valueType.getSymbolPath().getSymbol()).create();
        }
    }

    private static void annotateGroupDefinition(PbGroupDefinition groupDefinition, AnnotationHolder holder) {
        for (PbSymbol sibling : groupDefinition.getAdditionalSiblings()) {
            if (!(sibling instanceof PbField)) continue;
            PbAnnotator.annotateField((PbField)sibling, holder);
        }
    }

    private static void annotateEnumDefinition(PbEnumDefinition enumDefinition, AnnotationHolder holder) {
        PsiElement name = enumDefinition.getNameIdentifier();
        if (name == null) {
            return;
        }
        if (enumDefinition.getEnumValues().isEmpty()) {
            TextRange range = TextRange.create((int)enumDefinition.getTextRange().getStartOffset(), (int)name.getTextRange().getEndOffset());
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("enum.at.least.one.value", new Object[0])).range(range).create();
        }
    }

    private static void annotateEnumReservedStatement(PbEnumReservedStatement reservedStatement, AnnotationHolder holder) {
        EnumTracker.annotateReservedStatement(reservedStatement, holder);
    }

    private static void annotateEnumValue(PbEnumValue value, AnnotationHolder holder) {
        EnumTracker.annotateEnumValue(value, holder);
    }

    private static void annotateExtendDefinition(PbExtendDefinition extendDefinition, AnnotationHolder holder) {
        PbMessageTypeName type = extendDefinition.getTypeName();
        if (type == null) {
            return;
        }
        PbExtendBody body = extendDefinition.getBody();
        if (body == null) {
            return;
        }
        if (body.getGroupDefinitionList().isEmpty() && body.getSimpleFieldList().isEmpty()) {
            TextRange range = TextRange.create((int)extendDefinition.getTextRange().getStartOffset(), (int)extendDefinition.getTypeName().getTextRange().getEndOffset());
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("extend.at.least.one.field", new Object[0])).range(range).create();
        }
    }

    private static void annotateOneofDefinition(PbOneofDefinition oneofDefinition, AnnotationHolder holder) {
        PsiElement name = oneofDefinition.getNameIdentifier();
        if (name == null) {
            return;
        }
        PbOneofBody body = oneofDefinition.getBody();
        if (body == null) {
            return;
        }
        if (body.getGroupDefinitionList().isEmpty() && body.getSimpleFieldList().isEmpty()) {
            TextRange range = TextRange.create((int)oneofDefinition.getTextRange().getStartOffset(), (int)name.getTextRange().getEndOffset());
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("oneof.at.least.one.field", new Object[0])).range(range).create();
        }
    }

    private static void annotateReservedStatement(PbReservedStatement reservedStatement, AnnotationHolder holder) {
        MessageFieldTracker.annotateReservedStatement(reservedStatement, holder);
    }

    private static void annotateExtensionsStatement(PbExtensionsStatement extensionsStatement, AnnotationHolder holder) {
        MessageFieldTracker.annotateExtensionsStatement(extensionsStatement, holder);
    }

    private static void annotateField(PbField field, AnnotationHolder holder) {
        PbAnnotator.annotateInvalidFieldInMessageSet(field, holder);
        PbAnnotator.annotateMessageSetExtensionField(field, holder);
        PbAnnotator.annotateFieldLabel(field.getDeclaredLabel(), holder);
        MessageFieldTracker.annotateField(field, holder);
    }

    private static void annotateInvalidFieldInMessageSet(PbField field, AnnotationHolder holder) {
        if (field.isExtension()) {
            return;
        }
        PbSymbolOwner owner = field.getSymbolOwner();
        if (!(owner instanceof PbMessageType)) {
            return;
        }
        if (!((PbMessageType)owner).isMessageSet()) {
            return;
        }
        holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.set.fields", new Object[0])).range((PsiElement)field).create();
    }

    private static void annotateMessageSetExtensionField(PbField field, AnnotationHolder holder) {
        PbTypeName type;
        if (DumbService.isDumb((Project)field.getProject())) {
            return;
        }
        PbTypeName extendeeType = field.getExtendee();
        if (extendeeType == null) {
            return;
        }
        PbMessageType extendee = PbPsiUtil.resolveRefToType(extendeeType.getEffectiveReference(), PbMessageType.class);
        if (extendee == null || !extendee.isMessageSet()) {
            return;
        }
        PbFieldLabel label = field.getDeclaredLabel();
        if (label != null && field.getCanonicalLabel() != PbField.CanonicalFieldLabel.OPTIONAL) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.set.extensions.optional.messages", new Object[0])).range((PsiElement)label).create();
        }
        if ((type = field.getTypeName()) != null && PbPsiUtil.resolveRefToType(type.getEffectiveReference(), PbMessageType.class) == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.set.extensions.optional.messages", new Object[0])).range((PsiElement)type).create();
        }
    }

    private static void annotateFieldLabel(PbFieldLabel label, AnnotationHolder holder) {
        if (label == null) {
            return;
        }
        PbStatement statement = (PbStatement)PsiTreeUtil.getParentOfType((PsiElement)label, PbStatement.class);
        if (statement == null) {
            return;
        }
        if (statement instanceof PbMapField) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("map.fields.cannot.have.labels", new Object[0])).range((PsiElement)label).create();
        } else if (statement.getStatementOwner() instanceof PbOneofDefinition) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("oneof.fields.cannot.have.labels", new Object[0])).range((PsiElement)label).create();
        }
    }

    private static void annotateOptionName(PbOptionName name, AnnotationHolder holder) {
        PbExtensionName extensionName = name.getExtensionName();
        if (extensionName != null) {
            PbAnnotator.annotateExtensionName(extensionName, name, holder);
        } else {
            PbAnnotator.annotateOptionNameReference(name, holder);
        }
        PbAnnotator.annotateRepeatedMessageFieldInitialization(name, holder);
        PbAnnotator.annotateOptionOccurrences(name, holder);
        PbAnnotator.annotateSpecialOption(name, holder);
        PbAnnotator.annotateFeatureOptions(name, holder);
    }

    private static void annotateExtensionName(PbExtensionName name, PbOptionName option, AnnotationHolder holder) {
        PbSymbolPath path = name.getSymbolPath();
        SharedAnnotations.annotateExtensionName(path, path.getReference(), name.getReferenceString(), option.getQualifierType(), holder, true);
    }

    private static void annotateOptionNameReference(PbOptionName name, AnnotationHolder holder) {
        if (DumbService.isDumb((Project)name.getProject())) {
            return;
        }
        PsiElement symbol = name.getSymbol();
        switch (SharedAnnotations.getReferenceState(name.getEffectiveReference())) {
            case VALID: 
            case NULL: {
                break;
            }
            default: {
                TextRange range = symbol != null ? symbol.getTextRange() : name.getTextRange();
                String symbolName = symbol != null ? symbol.getText() : name.getText();
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("cannot.resolve.option", symbolName)).range(range).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        }
    }

    private static void annotateTypeName(PbTypeName name, AnnotationHolder holder) {
        if (DumbService.isDumb((Project)name.getProject())) {
            return;
        }
        if (name instanceof PbMessageTypeName) {
            if (PbPsiUtil.resolveRefToType(name.getEffectiveReference(), PbMessageType.class) == null) {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.type.expected", new Object[0])).range(name.getSymbolPath().getSymbol()).create();
            }
        } else if (!name.isBuiltInType() && PbPsiUtil.resolveRefToType(name.getEffectiveReference(), PbNamedTypeElement.class) == null) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("message.enum.or.builtin.type.expected", new Object[0])).range(name.getSymbolPath().getSymbol()).create();
        }
    }

    private static void annotateRepeatedMessageFieldInitialization(PbOptionName name, AnnotationHolder holder) {
        if (DumbService.isDumb((Project)name.getProject())) {
            return;
        }
        if (!(name.getParent() instanceof PbOptionName)) {
            return;
        }
        PbField field = PbPsiUtil.resolveRefToType(name.getEffectiveReference(), PbField.class);
        if (field == null) {
            return;
        }
        PbNamedTypeElement type = PbAnnotator.resolveType(field);
        if (type instanceof PbMessageType && field.isRepeated()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("repeated.message.aggregate.value", field.getName())).range(PbAnnotator.getOptionNameAnnotationElement(name)).create();
        }
    }

    private static void annotateFeatureOptions(PbOptionName name, AnnotationHolder holder) {
        PsiElement qualifier = name.getSymbol();
        if (qualifier != null && qualifier.getText().equals("features") && !(name.getPbFile().getSyntaxLevel() instanceof SyntaxLevel.Edition)) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("editions.features.invalid", name.getText())).range(qualifier).create();
        }
    }

    private static void annotateSpecialOption(PbOptionName name, AnnotationHolder holder) {
        PbField parentField;
        PbField parent;
        SpecialOptionType specialType = name.getSpecialType();
        if (specialType == null) {
            return;
        }
        PbOptionOwner owner = (PbOptionOwner)PsiTreeUtil.getParentOfType((PsiElement)name, PbOptionOwner.class);
        if (owner != null) {
            SpecialOptionTracker.forOptionOwner(owner).annotateOptionName(name, holder);
        }
        if (specialType == SpecialOptionType.FIELD_DEFAULT && (parent = (PbField)PsiTreeUtil.getParentOfType((PsiElement)name, PbField.class)) != null && parent.isRepeated()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("repeated.field.default.value", new Object[0])).range(PbAnnotator.getOptionNameAnnotationElement(name)).create();
        }
        if (specialType == SpecialOptionType.FIELD_JSON_NAME && (parentField = (PbField)PsiTreeUtil.getParentOfType((PsiElement)name, PbField.class)) != null && parentField.isExtension()) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("extension.field.json.name.not.allowed", new Object[0])).range((PsiElement)name).create();
        }
    }

    private static void annotateImportName(PbImportName name, AnnotationHolder holder) {
        String path = name.getStringValue().getAsString();
        TextRange range = name.getStringValue().getTextRangeNoQuotes();
        if (!PbFileResolver.isValidImportPath(path)) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("bad.import.path", new Object[0])).range(range).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            return;
        }
        switch (SharedAnnotations.getReferenceState(name.getReference())) {
            case AMBIGUOUS: {
                if (PbProjectSettings.getInstance(name.getProject()).isIndexBasedResolveEnabled()) {
                    return;
                }
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("ambiguous.import", path)).range(range).create();
                break;
            }
            case VALID: 
            case NULL: {
                break;
            }
            default: {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("cannot.resolve.import", path)).range(range).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).withFix((IntentionAction)new PbAddImportPathIntention()).create();
            }
        }
    }

    private static void annotateOptionOccurrences(PbOptionName name, AnnotationHolder holder) {
        PbOptionOwner owner = PbPsiImplUtil.getOptionOwner(name);
        if (owner == null) {
            return;
        }
        OptionOccurrenceTracker tracker = OptionOccurrenceTracker.forOptionOwner(owner);
        OptionOccurrenceTracker.Occurrence occurrence = tracker.getOccurrence(name);
        if (occurrence != null) {
            occurrence.annotate(holder, PbAnnotator.getOptionNameAnnotationElement(name));
        }
    }

    private static void annotateSymbolName(PbSymbol symbol, AnnotationHolder holder) {
        PbFile file = symbol.getPbFile();
        if (file == null) {
            return;
        }
        QualifiedName qualifiedName = symbol.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        if (!PbAnnotator.createConflictAnnotation(file, symbol, qualifiedName, holder) && symbol instanceof PbSymbolContributor) {
            for (PbSymbol contributed : ((PbSymbolContributor)symbol).getAdditionalSiblings()) {
                PbAnnotator.annotateSymbolName(contributed, holder);
            }
        }
    }

    private static void annotatePackageStatement(PbPackageStatement packageStatement, AnnotationHolder holder) {
        PbFile file = packageStatement.getPbFile();
        if (file == null) {
            return;
        }
        PbPackageStatement firstPackageStatement = file.getPackageStatement();
        if (firstPackageStatement == null) {
            return;
        }
        if (!packageStatement.equals(firstPackageStatement)) {
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("duplicate.package.statement", new Object[0])).range((PsiElement)packageStatement).create();
        }
    }

    private static boolean createConflictAnnotation(PbFile file, PbSymbol symbol, QualifiedName qualifiedName, AnnotationHolder holder) {
        PsiElement annotationElement = PbAnnotator.getSymbolNameAnnotationElement(symbol);
        int symbolOffset = annotationElement.getTextRange().getStartOffset();
        HashSet<PbFile> conflictFiles = new HashSet<PbFile>();
        Collection<PbSymbol> symbols = file.getFullQualifiedSymbolMap().get(qualifiedName);
        if (symbols == null) {
            return false;
        }
        for (PbSymbol otherSymbol : symbols) {
            PbFile otherFile;
            if (symbol.equals(otherSymbol) || symbol instanceof PbPackageName && otherSymbol instanceof PbPackageName || (otherFile = otherSymbol.getPbFile()) == null) continue;
            if (file.equals(otherFile)) {
                PsiElement otherAnnotationElement = PbAnnotator.getSymbolNameAnnotationElement(otherSymbol);
                if (otherAnnotationElement.getTextRange().getStartOffset() >= symbolOffset) continue;
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("symbol.already.defined.in.scope", qualifiedName.getLastComponent(), qualifiedName.removeLastComponent().toString())).range(annotationElement).create();
                return true;
            }
            conflictFiles.add(otherFile);
        }
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        if (!conflictFiles.isEmpty() && !DumbService.isDumb((Project)psiFile.getProject())) {
            String importName = PbAnnotator.getFirstImportName(file, conflictFiles);
            holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("symbol.already.defined.in.other.file", qualifiedName.toString(), importName)).range(annotationElement).create();
            return true;
        }
        return false;
    }

    private static String getFirstImportName(PbFile file, Set<PbFile> conflictFiles) {
        for (PbImportStatement importStatement : file.getImportStatements()) {
            PbFile resolved;
            PbImportName importName = importStatement.getImportName();
            if (importName == null || (resolved = PbPsiUtil.resolveRefToType(importName.getReference(), PbFile.class)) == null || !conflictFiles.contains(resolved)) continue;
            return importName.getStringValue().getAsString();
        }
        return null;
    }

    private static PbNamedTypeElement resolveType(PbField field) {
        PbTypeName typeName = field.getTypeName();
        if (typeName == null) {
            return null;
        }
        return PbPsiUtil.resolveRefToType(typeName.getEffectiveReference(), PbNamedTypeElement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/annotation/PbAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

