/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi;

import com.intellij.protobuf.lang.psi.ProtoCommentTokenType;
import com.intellij.protobuf.lang.psi.ProtoKeywordTokenType;
import com.intellij.protobuf.lang.psi.ProtoTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;

public final class ProtoTokenTypes {
    private static final Map<String, IElementType> TOKEN_TYPES = new HashMap<String, IElementType>();
    public static final IElementType ASSIGN = ProtoTokenTypes.put("=", new ProtoTokenType("="));
    public static final IElementType COLON = ProtoTokenTypes.put(":", new ProtoTokenType(":"));
    public static final IElementType COMMA = ProtoTokenTypes.put(",", new ProtoTokenType(","));
    public static final IElementType DOT = ProtoTokenTypes.put(".", new ProtoTokenType("."));
    public static final IElementType GT = ProtoTokenTypes.put(">", new ProtoTokenType(">"));
    public static final IElementType LBRACE = ProtoTokenTypes.put("{", new ProtoTokenType("{"));
    public static final IElementType LBRACK = ProtoTokenTypes.put("[", new ProtoTokenType("["));
    public static final IElementType LPAREN = ProtoTokenTypes.put("(", new ProtoTokenType("("));
    public static final IElementType LT = ProtoTokenTypes.put("<", new ProtoTokenType("<"));
    public static final IElementType MINUS = ProtoTokenTypes.put("-", new ProtoTokenType("-"));
    public static final IElementType RBRACE = ProtoTokenTypes.put("}", new ProtoTokenType("}"));
    public static final IElementType RBRACK = ProtoTokenTypes.put("]", new ProtoTokenType("]"));
    public static final IElementType RPAREN = ProtoTokenTypes.put(")", new ProtoTokenType(")"));
    public static final IElementType SEMI = ProtoTokenTypes.put(";", new ProtoTokenType(";"));
    public static final IElementType SLASH = ProtoTokenTypes.put("/", new ProtoTokenType("/"));
    public static final IElementType FLOAT_LITERAL = ProtoTokenTypes.put("FLOAT_LITERAL", new ProtoTokenType("float"));
    public static final IElementType IDENTIFIER_LITERAL = ProtoTokenTypes.put("IDENTIFIER_LITERAL", new ProtoTokenType("identifier"));
    public static final IElementType INTEGER_LITERAL = ProtoTokenTypes.put("INTEGER_LITERAL", new ProtoTokenType("integer"));
    public static final IElementType STRING_LITERAL = ProtoTokenTypes.put("STRING_LITERAL", new ProtoTokenType("string"));
    public static final IElementType BLOCK_COMMENT = ProtoTokenTypes.put("BLOCK_COMMENT", new ProtoCommentTokenType("BLOCK_COMMENT"));
    public static final IElementType BUILT_IN_TYPE = ProtoTokenTypes.put("BUILT_IN_TYPE", new ProtoTokenType("#built_in_type#"));
    public static final IElementType IDENTIFIER_AFTER_NUMBER = ProtoTokenTypes.put("IDENTIFIER_AFTER_NUMBER", new ProtoTokenType("IDENTIFIER_AFTER_NUMBER"));
    public static final IElementType LINE_COMMENT = ProtoTokenTypes.put("LINE_COMMENT", new ProtoCommentTokenType("LINE_COMMENT"));
    public static final IElementType SYMBOL = ProtoTokenTypes.put("SYMBOL", new ProtoTokenType("SYMBOL"));
    public static final IElementType DEFAULT = ProtoTokenTypes.put("default", new ProtoKeywordTokenType("default"));
    public static final IElementType EDITION = ProtoTokenTypes.put("edition", new ProtoKeywordTokenType("edition"));
    public static final IElementType ENUM = ProtoTokenTypes.put("enum", new ProtoKeywordTokenType("enum"));
    public static final IElementType EXPORT = ProtoTokenTypes.put("export", new ProtoKeywordTokenType("export"));
    public static final IElementType EXTEND = ProtoTokenTypes.put("extend", new ProtoKeywordTokenType("extend"));
    public static final IElementType EXTENSIONS = ProtoTokenTypes.put("extensions", new ProtoKeywordTokenType("extensions"));
    public static final IElementType FALSE = ProtoTokenTypes.put("false", new ProtoKeywordTokenType("false"));
    public static final IElementType GROUP = ProtoTokenTypes.put("group", new ProtoKeywordTokenType("group"));
    public static final IElementType IMPORT = ProtoTokenTypes.put("import", new ProtoKeywordTokenType("import"));
    public static final IElementType JSON_NAME = ProtoTokenTypes.put("json_name", new ProtoKeywordTokenType("json_name"));
    public static final IElementType LOCAL = ProtoTokenTypes.put("local", new ProtoKeywordTokenType("local"));
    public static final IElementType MAP = ProtoTokenTypes.put("map", new ProtoKeywordTokenType("map"));
    public static final IElementType MAX = ProtoTokenTypes.put("max", new ProtoKeywordTokenType("max"));
    public static final IElementType MESSAGE = ProtoTokenTypes.put("message", new ProtoKeywordTokenType("message"));
    public static final IElementType ONEOF = ProtoTokenTypes.put("oneof", new ProtoKeywordTokenType("oneof"));
    public static final IElementType OPTION = ProtoTokenTypes.put("option", new ProtoKeywordTokenType("option"));
    public static final IElementType OPTIONAL = ProtoTokenTypes.put("optional", new ProtoKeywordTokenType("optional"));
    public static final IElementType PACKAGE = ProtoTokenTypes.put("package", new ProtoKeywordTokenType("package"));
    public static final IElementType PUBLIC = ProtoTokenTypes.put("public", new ProtoKeywordTokenType("public"));
    public static final IElementType REPEATED = ProtoTokenTypes.put("repeated", new ProtoKeywordTokenType("repeated"));
    public static final IElementType REQUIRED = ProtoTokenTypes.put("required", new ProtoKeywordTokenType("required"));
    public static final IElementType RESERVED = ProtoTokenTypes.put("reserved", new ProtoKeywordTokenType("reserved"));
    public static final IElementType RETURNS = ProtoTokenTypes.put("returns", new ProtoKeywordTokenType("returns"));
    public static final IElementType RPC = ProtoTokenTypes.put("rpc", new ProtoKeywordTokenType("rpc"));
    public static final IElementType SERVICE = ProtoTokenTypes.put("service", new ProtoKeywordTokenType("service"));
    public static final IElementType STREAM = ProtoTokenTypes.put("stream", new ProtoKeywordTokenType("stream"));
    public static final IElementType SYNTAX = ProtoTokenTypes.put("syntax", new ProtoKeywordTokenType("syntax"));
    public static final IElementType TO = ProtoTokenTypes.put("to", new ProtoKeywordTokenType("to"));
    public static final IElementType TRUE = ProtoTokenTypes.put("true", new ProtoKeywordTokenType("true"));
    public static final IElementType WEAK = ProtoTokenTypes.put("weak", new ProtoKeywordTokenType("weak"));
    public static final TokenSet WHITE_SPACE = TokenSet.WHITE_SPACE;
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{LINE_COMMENT, BLOCK_COMMENT});
    public static final TokenSet STRINGS = TokenSet.create((IElementType[])new IElementType[]{STRING_LITERAL});

    private static IElementType put(String token, IElementType type) {
        TOKEN_TYPES.put(token, type);
        return type;
    }

    static IElementType get(String token) {
        IElementType type = TOKEN_TYPES.get(token);
        if (type == null) {
            throw new AssertionError((Object)("Unknown token type: " + token));
        }
        return type;
    }
}

