/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.ProtoSymbolPath;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.resolve.PbResolveResult;
import com.intellij.protobuf.lang.resolve.PbSymbolLookupElement;
import com.intellij.protobuf.lang.resolve.PbSymbolResolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtoSymbolPathReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    @NotNull
    private final ProtoSymbolPath symbolPath;
    @NotNull
    private final PbSymbolResolver resolver;
    @Nullable
    private final QualifiedName scope;
    @NotNull
    private final Condition<PbSymbol> resolveFilter;
    @Nullable
    private final Condition<PbSymbol> completionFilter;
    @NotNull
    private final Function<PbSymbol, LookupElement> lookupElementFactory;

    public ProtoSymbolPathReference(@NotNull ProtoSymbolPath element, @NotNull PbSymbolResolver resolver, @Nullable QualifiedName scope, @NotNull Condition<PbSymbol> resolveFilter, @Nullable Condition<PbSymbol> completionFilter) {
        if (element == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(0);
        }
        if (resolver == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(1);
        }
        if (resolveFilter == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(2);
        }
        this(element, resolver, scope, resolveFilter, completionFilter, PbSymbolLookupElement::new);
    }

    public ProtoSymbolPathReference(@NotNull ProtoSymbolPath element, @NotNull PbSymbolResolver resolver, @Nullable QualifiedName scope, @NotNull Condition<PbSymbol> resolveFilter, @Nullable Condition<PbSymbol> completionFilter, @NotNull Function<PbSymbol, LookupElement> lookupElementFactory) {
        if (element == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(3);
        }
        if (resolver == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(4);
        }
        if (resolveFilter == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(5);
        }
        if (lookupElementFactory == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(6);
        }
        this(element, ProtoSymbolPathReference.calculateRangeInPath(element), element, resolver, scope, resolveFilter, completionFilter, lookupElementFactory);
    }

    public ProtoSymbolPathReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @NotNull ProtoSymbolPath symbolPath, @NotNull PbSymbolResolver resolver, @Nullable QualifiedName scope, @NotNull Condition<PbSymbol> resolveFilter, @Nullable Condition<PbSymbol> completionFilter, @NotNull Function<PbSymbol, LookupElement> lookupElementFactory) {
        if (element == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(7);
        }
        if (rangeInElement == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(8);
        }
        if (symbolPath == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(9);
        }
        if (resolver == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(10);
        }
        if (resolveFilter == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(11);
        }
        if (lookupElementFactory == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(12);
        }
        super(element);
        this.symbolPath = symbolPath;
        this.resolver = resolver;
        this.scope = scope;
        this.resolveFilter = resolveFilter;
        this.completionFilter = completionFilter;
        this.lookupElementFactory = lookupElementFactory;
        this.setRangeInElement(rangeInElement);
    }

    private static TextRange calculateRangeInPath(ProtoSymbolPath path) {
        TextRange outerRange = path.getTextRange();
        TextRange identifierRange = path.getSymbol().getTextRange();
        return TextRange.from((int)(identifierRange.getStartOffset() - outerRange.getStartOffset()), (int)identifierRange.getLength());
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveCache cache = ResolveCache.getInstance((Project)this.myElement.getProject());
        ResolveResult[] resolveResultArray = cache.resolveWithCaching((PsiPolyVariantReference)this, (ref, incompleteCode1) -> ref.multiResolveNoCache(), false, incompleteCode);
        if (resolveResultArray == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(13);
        }
        return resolveResultArray;
    }

    private ResolveResult @NotNull [] multiResolveNoCache() {
        QualifiedName name = this.symbolPath.getQualifiedName();
        PsiElement parent = this.symbolPath.getParent();
        ResolveResult[] results = ProtoSymbolPathReference.resolveFromMoreQualifiedParent(parent, name);
        if (results != null) {
            if (results == null) {
                ProtoSymbolPathReference.$$$reportNull$$$0(14);
            }
            return results;
        }
        ResolveResult[] resolveResultArray = this.resolveTopDown(name);
        if (resolveResultArray == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(15);
        }
        return resolveResultArray;
    }

    private static ResolveResult[] resolveFromMoreQualifiedParent(PsiElement parentPath, QualifiedName name) {
        if (!(parentPath instanceof ProtoSymbolPath)) {
            return null;
        }
        PsiReference ref = parentPath.getReference();
        if (!(ref instanceof ProtoSymbolPathReference)) {
            return null;
        }
        ProtoSymbolPathReference pathReference = (ProtoSymbolPathReference)ref;
        ResolveResult[] resolveResults = pathReference.multiResolve(false);
        if (resolveResults.length == 0) {
            return null;
        }
        ArrayList<PbResolveResult> results = new ArrayList<PbResolveResult>(resolveResults.length);
        block0: for (ResolveResult result : pathReference.multiResolve(false)) {
            PbSymbol symbol;
            QualifiedName nextName;
            PbResolveResult pbResult;
            QualifiedName refElementScope;
            if (!(result instanceof PbResolveResult) || (refElementScope = (pbResult = (PbResolveResult)result).getName()) == null || !(nextName = refElementScope.removeLastComponent()).subQualifiedName(nextName.getComponentCount() - name.getComponentCount(), nextName.getComponentCount()).equals((Object)name) || (symbol = pbResult.getElement()) == null) continue;
            PbSymbolOwner nextOwner = symbol.getSymbolOwner();
            while (nextOwner != null) {
                PbResolveResult newResult = ProtoSymbolPathReference.resolveForElement(nextOwner, nextName);
                if (newResult != null) {
                    results.add(newResult);
                    continue block0;
                }
                nextOwner = nextOwner instanceof PbSymbol ? ((PbSymbol)((Object)nextOwner)).getSymbolOwner() : null;
            }
        }
        return results.toArray(ResolveResult.EMPTY_ARRAY);
    }

    private ResolveResult[] resolveTopDown(QualifiedName name) {
        List<PbResolveResult> results = this.scope != null ? this.resolver.resolveRelativeName(name, this.scope, this.resolveFilter) : this.resolver.resolveName(name, this.resolveFilter);
        return results.toArray(ResolveResult.EMPTY_ARRAY);
    }

    public Object @NotNull [] getVariants() {
        Collection results;
        if (this.completionFilter == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                ProtoSymbolPathReference.$$$reportNull$$$0(16);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        ProtoSymbolPath qualifier = this.symbolPath.getQualifier();
        if (qualifier != null) {
            Object[] objectArray = PbPsiUtil.multiResolveRefToType(qualifier.getReference(), PbSymbolOwner.class).stream().map(PbSymbolOwner::getSymbols).flatMap(Collection::stream).filter(arg_0 -> this.completionFilter.value(arg_0)).map(this.lookupElementFactory).distinct().toArray();
            if (objectArray == null) {
                ProtoSymbolPathReference.$$$reportNull$$$0(17);
            }
            return objectArray;
        }
        if (this.scope != null) {
            LinkedListMultimap allSymbols = LinkedListMultimap.create();
            for (int i = 0; i <= this.scope.getComponentCount(); ++i) {
                QualifiedName subScope = this.scope.subQualifiedName(0, i);
                ImmutableMultimap<String, PbSymbol> childSymbols = this.resolver.findChildren(subScope, this.completionFilter);
                for (Map.Entry entry : childSymbols.asMap().entrySet()) {
                    allSymbols.replaceValues((Object)((String)entry.getKey()), (Iterable)entry.getValue());
                }
            }
            results = allSymbols.values();
        } else {
            ImmutableMultimap<String, PbSymbol> topLevelSymbols = this.resolver.findChildren(PbPsiUtil.EMPTY_QUALIFIED_NAME, this.completionFilter);
            results = topLevelSymbols.values();
        }
        Object[] objectArray = results.stream().map(this.lookupElementFactory).distinct().toArray();
        if (objectArray == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(18);
        }
        return objectArray;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode node;
        if (newElementName == null) {
            ProtoSymbolPathReference.$$$reportNull$$$0(19);
        }
        if ((node = this.symbolPath.getNode().findChildByType(ProtoTokenTypes.IDENTIFIER_LITERAL)) instanceof LeafElement) {
            ((LeafElement)node).replaceWithText(newElementName);
            return this.symbolPath;
        }
        return super.handleElementRename(newElementName);
    }

    @Nullable
    private static PbResolveResult resolveForElement(PbElement element, QualifiedName name) {
        PbSymbol symbol;
        if (name == null) {
            return null;
        }
        if (element instanceof PbSymbol && name.equals((Object)(symbol = (PbSymbol)element).getQualifiedName())) {
            return PbResolveResult.create(symbol);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveFilter";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElementFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolPath";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/resolve/ProtoSymbolPathReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/resolve/ProtoSymbolPathReference";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveNoCache";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

