/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.resolve.directive;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.protobuf.lang.psi.PbTextFile;
import com.intellij.protobuf.lang.resolve.directive.SchemaDirective;
import com.intellij.psi.PsiComment;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SchemaDirectiveCompletionContributor
extends CompletionContributor {
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^#\\s*[^\\s]*$");

    public SchemaDirectiveCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(PsiComment.class).withParent(PbTextFile.class), new CommentCompletionProvider());
    }

    private static class CommentCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private CommentCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            TextRange rangeUpToCaret;
            String textUpToCaret;
            if (parameters == null) {
                CommentCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CommentCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                CommentCompletionProvider.$$$reportNull$$$0(2);
            }
            if (!PREFIX_PATTERN.matcher(textUpToCaret = (rangeUpToCaret = TextRange.create((int)parameters.getPosition().getTextOffset(), (int)parameters.getOffset())).substring(parameters.getOriginalFile().getText())).matches()) {
                return;
            }
            SchemaDirective directive = SchemaDirective.find(parameters.getOriginalFile());
            if (directive == null || directive.getFileComment() == null) {
                result.addElement(CommentCompletionProvider.commentLookupElement("proto-file"));
            }
            if (directive == null || directive.getMessageComment() == null) {
                result.addElement(CommentCompletionProvider.commentLookupElement("proto-message"));
            }
            result.addElement(CommentCompletionProvider.commentLookupElement("proto-import"));
        }

        private static LookupElement commentLookupElement(String commentPrefix) {
            return LookupElementBuilder.create((String)(commentPrefix + ": ")).withPresentableText(commentPrefix).withInsertHandler((insertionContext, item) -> AutoPopupController.getInstance((Project)insertionContext.getProject()).scheduleAutoPopup(insertionContext.getEditor()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/protobuf/lang/resolve/directive/SchemaDirectiveCompletionContributor$CommentCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

