/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage.mvstore;

import com.intellij.code.provenance.core.events.storage.mvstore.MetadataEntryData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u0016\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u000b*\u00020\u0019H\u0002J\u001b\u0010\u001a\u001a\u00020\u0015*\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u0004\u0018\u00010\t*\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/code/provenance/core/events/storage/mvstore/ProvenanceMetadataEntrySerializer;", "", "<init>", "()V", "VERSION", "", "serialize", "", "timestamp", "", "type", "", "fileHash", "kind", "oldContentHash", "newContentHash", "(JLjava/lang/String;JLjava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)[B", "deserialize", "Lcom/intellij/code/provenance/core/events/storage/mvstore/MetadataEntryData;", "bytes", "writeNullableString", "", "Ljava/io/DataOutputStream;", "value", "readNullableString", "Ljava/io/DataInputStream;", "writeNullableLong", "(Ljava/io/DataOutputStream;Ljava/lang/Long;)V", "readNullableLong", "(Ljava/io/DataInputStream;)Ljava/lang/Long;", "intellij.code.provenance.core"})
public final class ProvenanceMetadataEntrySerializer {
    @NotNull
    public static final ProvenanceMetadataEntrySerializer INSTANCE = new ProvenanceMetadataEntrySerializer();
    private static final byte VERSION = 1;

    private ProvenanceMetadataEntrySerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(long timestamp, @NotNull String type, long fileHash, @Nullable String kind, @Nullable Long oldContentHash, @Nullable Long newContentHash) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream byteStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(byteStream);
            Throwable throwable2 = null;
            try {
                DataOutputStream out = (DataOutputStream)closeable2;
                boolean bl2 = false;
                out.writeByte(1);
                out.writeLong(timestamp);
                out.writeUTF(type);
                out.writeLong(fileHash);
                INSTANCE.writeNullableString(out, kind);
                INSTANCE.writeNullableLong(out, oldContentHash);
                INSTANCE.writeNullableLong(out, newContentHash);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = byteStream.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MetadataEntryData deserialize(@NotNull byte[] bytes) {
        MetadataEntryData metadataEntryData;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Closeable closeable = new ByteArrayInputStream(bytes);
        Throwable throwable = null;
        try {
            MetadataEntryData metadataEntryData2;
            ByteArrayInputStream byteStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataInputStream(byteStream);
            Throwable throwable2 = null;
            try {
                DataInputStream input = (DataInputStream)closeable2;
                boolean bl2 = false;
                byte version = input.readByte();
                if (version != 1) {
                    throw new IllegalStateException("Unsupported serialization version: " + version);
                }
                long l = input.readLong();
                String string = input.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                metadataEntryData2 = new MetadataEntryData(l, string, input.readLong(), INSTANCE.readNullableString(input), INSTANCE.readNullableLong(input), INSTANCE.readNullableLong(input));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            metadataEntryData = metadataEntryData2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return metadataEntryData;
    }

    private final void writeNullableString(DataOutputStream $this$writeNullableString, String value) {
        if (value == null) {
            $this$writeNullableString.writeBoolean(false);
        } else {
            $this$writeNullableString.writeBoolean(true);
            $this$writeNullableString.writeUTF(value);
        }
    }

    private final String readNullableString(DataInputStream $this$readNullableString) {
        return $this$readNullableString.readBoolean() ? $this$readNullableString.readUTF() : null;
    }

    private final void writeNullableLong(DataOutputStream $this$writeNullableLong, Long value) {
        if (value == null) {
            $this$writeNullableLong.writeBoolean(false);
        } else {
            $this$writeNullableLong.writeBoolean(true);
            $this$writeNullableLong.writeLong(value);
        }
    }

    private final Long readNullableLong(DataInputStream $this$readNullableLong) {
        return $this$readNullableLong.readBoolean() ? Long.valueOf($this$readNullableLong.readLong()) : null;
    }
}

