/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.jupyter.core.executor.task.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.debugger.common.DebugConnectionNotifier;
import com.intellij.jupyter.core.jupyter.debugger.common.NotebookDebugRunner;
import com.intellij.jupyter.py.debugger.JupyterAutoBreakpointHelper;
import com.intellij.jupyter.py.debugger.JupyterConsoleExecuteActionHandler;
import com.intellij.jupyter.py.debugger.JupyterDebugCellTask;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.jupyter.py.debugger.JupyterDebugProcessHandler;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.run.PythonCommandLineState;
import java.net.ServerSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016JI\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\f\b\u0000\u0010\u0016*\u00020\u0017*\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u0002H\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugRunner;", "Lcom/jetbrains/python/debugger/PyDebugRunner;", "Lcom/intellij/jupyter/core/jupyter/debugger/common/NotebookDebugRunner;", "<init>", "()V", "createDebugSession", "Lcom/intellij/xdebugger/XDebugSession;", "project", "Lcom/intellij/openapi/project/Project;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "connectionNotifier", "Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "afterCellExecuted", "Lkotlin/Function0;", "", "getConnectionNotifier", "()Lcom/intellij/jupyter/core/jupyter/debugger/common/DebugConnectionNotifier;", "initDebugConsoleView", "Lcom/jetbrains/python/console/PythonDebugConsoleCommunication;", "T", "Lcom/intellij/xdebugger/XDebugProcess;", "Lcom/jetbrains/python/debugger/PyDebugProcessWithConsole;", "debugProcess", "console", "Lcom/jetbrains/python/console/PythonDebugLanguageConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "session", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XDebugProcess;Lcom/jetbrains/python/console/PythonDebugLanguageConsoleView;Lcom/intellij/execution/process/ProcessHandler;Lcom/intellij/xdebugger/XDebugSession;)Lcom/jetbrains/python/console/PythonDebugConsoleCommunication;", "intellij.jupyter.py"})
public final class JupyterDebugRunner
extends PyDebugRunner
implements NotebookDebugRunner {
    @NotNull
    public static final JupyterDebugRunner INSTANCE = new JupyterDebugRunner();

    private JupyterDebugRunner() {
    }

    @NotNull
    public XDebugSession createDebugSession(@NotNull Project project, @NotNull NotebookIntervalPointer cellPointer, @NotNull VirtualFile virtualFile, @NotNull DebugConnectionNotifier connectionNotifier2, @NotNull Function0<Unit> afterCellExecuted) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)connectionNotifier2, (String)"connectionNotifier");
        Intrinsics.checkNotNullParameter(afterCellExecuted, (String)"afterCellExecuted");
        ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
        JupyterAutoBreakpointHelper.INSTANCE.addBreakpointToCellIfNeeded$intellij_jupyter_py(cellPointer, project, virtualFile);
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(virtualFile.getNameWithoutExtension(), JupyterCoreIcons.JupyterNotebook, null, false, new XDebugProcessStarter(project, serverSocket, cellPointer, connectionNotifier2, afterCellExecuted, virtualFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ ServerSocket $serverSocket;
            final /* synthetic */ NotebookIntervalPointer $cellPointer;
            final /* synthetic */ DebugConnectionNotifier $connectionNotifier;
            final /* synthetic */ Function0<Unit> $afterCellExecuted;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$serverSocket = $serverSocket;
                this.$cellPointer = $cellPointer;
                this.$connectionNotifier = $connectionNotifier;
                this.$afterCellExecuted = $afterCellExecuted;
                this.$virtualFile = $virtualFile;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                ConsoleView consoleView = new PyDebugConsoleBuilder(this.$project, null).getConsole();
                Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
                ConsoleView debugConsoleView = consoleView;
                JupyterDebugProcessHandler jupyterDebugProcessHandler = new JupyterDebugProcessHandler(this.$project, session);
                ServerSocket serverSocket = this.$serverSocket;
                Intrinsics.checkNotNull((Object)serverSocket);
                JupyterDebugProcess jupyterDebugProcess = new JupyterDebugProcess(session, serverSocket, (ExecutionConsole)debugConsoleView, jupyterDebugProcessHandler, this.$cellPointer, this.$connectionNotifier, this.$afterCellExecuted, BackedNotebookVirtualFile.Companion.takeBackend(this.$virtualFile));
                debugConsoleView.attachToProcess((ProcessHandler)jupyterDebugProcessHandler);
                JupyterDebugRunner.access$initDebugConsoleView(JupyterDebugRunner.INSTANCE, this.$project, (XDebugProcess)jupyterDebugProcess, (PythonDebugLanguageConsoleView)debugConsoleView, jupyterDebugProcessHandler, session);
                BackedNotebookVirtualFile notebookVirtualFile = BackedNotebookVirtualFile.Companion.takeBackend(this.$virtualFile);
                jupyterDebugProcess.connect(notebookVirtualFile, this.$cellPointer);
                PyConsoleUtil.markIPython((VirtualFile)((PythonDebugLanguageConsoleView)debugConsoleView).getPydevConsoleView().getVirtualFile());
                return (XDebugProcess)jupyterDebugProcess;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSessionAndShowTab(...)");
        return xDebugSession;
    }

    @NotNull
    public DebugConnectionNotifier getConnectionNotifier() {
        return new DebugConnectionNotifier(){

            public Object executeAfterConnection(Project project, BackedNotebookVirtualFile notebookFile, NotebookIntervalPointer cellPointer, XDebugSession debugSession, Continuation<? super Unit> $completion) {
                JupyterDebugCellTask task = new JupyterDebugCellTask(project, notebookFile, debugSession, cellPointer);
                Object object = JupyterExecutionManager.Companion.getInstance(project, notebookFile).submitTask((JupyterExecutionTask)task, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
    }

    private final <T extends XDebugProcess> PythonDebugConsoleCommunication<T> initDebugConsoleView(Project project, T debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, XDebugSession session) {
        PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
        Intrinsics.checkNotNullExpressionValue((Object)pythonConsoleView, (String)"getPydevConsoleView(...)");
        PythonConsoleView pythonConsoleView2 = pythonConsoleView;
        PythonDebugConsoleCommunication debugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess, pythonConsoleView2);
        pythonConsoleView2.setConsoleCommunication((ConsoleCommunication)debugConsoleCommunication);
        JupyterConsoleExecuteActionHandler<T> consoleExecuteActionHandler = new JupyterConsoleExecuteActionHandler<T>(console, processHandler, (ConsoleCommunication)debugConsoleCommunication, debugProcess);
        PythonDebugConsoleCommunication pythonDebugConsoleCommunication = PyDebugRunner.initDebugConsole((PythonConsoleView)pythonConsoleView2, (PydevDebugConsoleExecuteActionHandler)consoleExecuteActionHandler, debugProcess, (ProcessHandler)processHandler, (PythonDebugConsoleCommunication)debugConsoleCommunication, (XDebugSession)session);
        Intrinsics.checkNotNullExpressionValue((Object)pythonDebugConsoleCommunication, (String)"initDebugConsole(...)");
        return pythonDebugConsoleCommunication;
    }

    public static final /* synthetic */ PythonDebugConsoleCommunication access$initDebugConsoleView(JupyterDebugRunner $this, Project project, XDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, XDebugSession session) {
        return $this.initDebugConsoleView(project, debugProcess, console, processHandler, session);
    }
}

