/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.generic.dynamic;

import com.google.gson.JsonObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.util.generic.dynamic.Dynamics;
import java.util.Objects;

public class DynamicKubernetesObject
implements KubernetesObject {
    private final JsonObject raw;

    public DynamicKubernetesObject() {
        this(new JsonObject());
    }

    public DynamicKubernetesObject(JsonObject obj) {
        this.raw = obj;
    }

    @Override
    public V1ObjectMeta getMetadata() {
        return (V1ObjectMeta)Dynamics.internalJSONCodec.getGson().fromJson(this.raw.get("metadata"), V1ObjectMeta.class);
    }

    @Override
    public String getApiVersion() {
        return this.raw.get("apiVersion").getAsString();
    }

    @Override
    public String getKind() {
        return this.raw.get("kind").getAsString();
    }

    public JsonObject getRaw() {
        return this.raw;
    }

    public void setApiVersion(String apiVersion) {
        this.raw.addProperty("apiVersion", apiVersion);
    }

    public void setKind(String kind) {
        this.raw.addProperty("kind", kind);
    }

    public void setMetadata(V1ObjectMeta objectMeta) {
        this.raw.add("metadata", Dynamics.internalJSONCodec.getGson().toJsonTree((Object)objectMeta));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicKubernetesObject that = (DynamicKubernetesObject)o;
        return Objects.equals(this.raw, that.raw);
    }

    public int hashCode() {
        return Objects.hash(this.raw);
    }
}

