/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.callsites;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.microservices.jvm.callsites.ArgumentCallSite;
import com.intellij.microservices.jvm.callsites.ArgumentPlace;
import com.intellij.microservices.jvm.callsites.ConstructorArgument;
import com.intellij.microservices.jvm.callsites.MethodArgInfo;
import com.intellij.microservices.jvm.callsites.MethodArgument;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aF\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00010\u000b0\nH\u0002\u001a>\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00010\u000b0\nH\u0002\u00a8\u0006\u000f"}, d2={"findCallSites", "", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSite;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "places", "Lcom/intellij/microservices/jvm/callsites/ArgumentPlace;", "methodsCacheKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/microservices/jvm/callsites/MethodArgInfo;", "getMethods", "cacheKey", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nArgumentCallSiteCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentCallSiteCollector.kt\ncom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollectorKt\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,138:1\n207#2:139\n*S KotlinDebug\n*F\n+ 1 ArgumentCallSiteCollector.kt\ncom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollectorKt\n*L\n81#1:139\n*E\n"})
public final class ArgumentCallSiteCollectorKt {
    private static final List<ArgumentCallSite> findCallSites(Project project, GlobalSearchScope scope, List<? extends ArgumentPlace> places, Key<CachedValue<List<MethodArgInfo>>> methodsCacheKey) {
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)ArgumentCallSiteCollectorKt.getMethods(project, places, methodsCacheKey)), arg_0 -> ArgumentCallSiteCollectorKt.findCallSites$lambda$0(scope, arg_0)));
    }

    private static final List<MethodArgInfo> getMethods(Project project, List<? extends ArgumentPlace> places, Key<CachedValue<List<MethodArgInfo>>> cacheKey) {
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, cacheKey, () -> ArgumentCallSiteCollectorKt.getMethods$lambda$0(project, places), false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    private static final Sequence findCallSites$lambda$0(GlobalSearchScope $scope, MethodArgInfo methodInfo) {
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        ProgressManager.checkCanceled();
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)MethodReferencesSearch.search((PsiMethod)methodInfo.getMethod(), (SearchScope)((SearchScope)$scope), (boolean)true).asIterable()), arg_0 -> ArgumentCallSiteCollectorKt.findCallSites$lambda$0$0(methodInfo, arg_0));
    }

    private static final ArgumentCallSite findCallSites$lambda$0$0(MethodArgInfo $methodInfo, PsiReference usage) {
        String value;
        UCallExpression expr;
        PsiElement $this$getUastParentOfType_u24default$iv = usage.getElement();
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UCallExpression uCallExpression = expr = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
        UExpression arg = uCallExpression != null ? uCallExpression.getArgumentForParameter($methodInfo.getArgIndex()) : null;
        UExpression uExpression = arg;
        if (uExpression == null || (uExpression = uExpression.getSourcePsi()) == null) {
            return null;
        }
        UExpression sourcePsi = uExpression;
        String string = UastUtils.evaluateString((UExpression)arg);
        if (string == null) {
            string = "";
        }
        return ((CharSequence)(value = string)).length() > 0 ? new ArgumentCallSite(value, (PsiElement)sourcePsi) : null;
    }

    private static final CachedValueProvider.Result getMethods$lambda$0(Project $project, List $places) {
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)$project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        List methods = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)$places), arg_0 -> ArgumentCallSiteCollectorKt.getMethods$lambda$0$0(javaPsi, scope, arg_0))));
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)$project)};
        return CachedValueProvider.Result.create((Object)methods, (Object[])objectArray);
    }

    private static final Sequence getMethods$lambda$0$0(JavaPsiFacade $javaPsi, GlobalSearchScope $scope, ArgumentPlace descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiClass[] psiClassArray = $javaPsi.findClasses(descriptor.getClassName(), $scope);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"findClasses(...)");
        return SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])psiClassArray), arg_0 -> ArgumentCallSiteCollectorKt.getMethods$lambda$0$0$0(descriptor, arg_0));
    }

    private static final Sequence getMethods$lambda$0$0$0(ArgumentPlace $descriptor, PsiClass psiClass) {
        Sequence sequence2;
        ArgumentPlace argumentPlace = $descriptor;
        if (argumentPlace instanceof MethodArgument) {
            sequence2 = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((MethodArgument)$descriptor).getMethodNames()), arg_0 -> ArgumentCallSiteCollectorKt.getMethods$lambda$0$0$0$0(psiClass, arg_0));
        } else if (argumentPlace instanceof ConstructorArgument) {
            PsiMethod[] psiMethodArray = psiClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
            sequence2 = ArraysKt.asSequence((Object[])psiMethodArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Sequence methods = sequence2;
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)methods, arg_0 -> ArgumentCallSiteCollectorKt.getMethods$lambda$0$0$0$1($descriptor, arg_0)), arg_0 -> ArgumentCallSiteCollectorKt.getMethods$lambda$0$0$0$2($descriptor, arg_0));
    }

    private static final Sequence getMethods$lambda$0$0$0$0(PsiClass $psiClass, String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        PsiMethod[] psiMethodArray = $psiClass.findMethodsByName(methodName, true);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        return ArraysKt.asSequence((Object[])psiMethodArray);
    }

    private static final boolean getMethods$lambda$0$0$0$1(ArgumentPlace $descriptor, PsiMethod it) {
        if ($descriptor.getArgumentCount() > 0 && it.getParameterList().getParametersCount() != $descriptor.getArgumentCount()) {
            return false;
        }
        PsiMethodPattern psiPattern = $descriptor.getPsiPattern();
        if (psiPattern != null && !psiPattern.accepts((Object)it)) {
            return false;
        }
        int argIndex = $descriptor.getArgumentIndex();
        PsiParameter param = it.getParameterList().getParameter(argIndex);
        return param != null && param.getType().equalsToText("java.lang.String");
    }

    private static final MethodArgInfo getMethods$lambda$0$0$0$2(ArgumentPlace $descriptor, PsiMethod it) {
        Intrinsics.checkNotNull((Object)it);
        return new MethodArgInfo(it, $descriptor.getArgumentIndex());
    }

    public static final /* synthetic */ List access$findCallSites(Project project, GlobalSearchScope scope, List places, Key methodsCacheKey) {
        return ArgumentCallSiteCollectorKt.findCallSites(project, scope, places, (Key<CachedValue<List<MethodArgInfo>>>)methodsCacheKey);
    }
}

