/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.microservices.jvm.config.ConfigKeyPathContext;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathReferenceBase;
import com.intellij.microservices.jvm.config.ConfigKeyPathUtils;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigKeyPathBeanPropertyReference
extends ConfigKeyPathReferenceBase {
    ConfigKeyPathBeanPropertyReference(@NotNull PsiElement element, @NotNull ConfigKeyPathContext context) {
        if (element == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(1);
        }
        super(element, context);
    }

    @Override
    @NotNull
    public ConfigKeyPathReference.PathType getPathType() {
        ConfigKeyPathReference.PathType pathType = ConfigKeyPathReference.PathType.BEAN_PROPERTY;
        if (pathType == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(2);
        }
        return pathType;
    }

    @Nullable
    public PsiElement resolve() {
        PsiType psiType = this.getPreviousValueType();
        if (psiType == null) {
            return null;
        }
        return this.resolveProperty(psiType, this.getValue());
    }

    public Object @NotNull [] getVariants() {
        MetaConfigKey configKey = this.getContext().getKey();
        PsiType psiType = ConfigKeyPathUtils.unwrapIndexed(this.getPreviousValueType());
        if (psiType == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        List<BeanProperty> properties = configKey.getPropertyResolver().getAllBeanProperties(configKey, psiType);
        Object[] objectArray = ContainerUtil.map2Array(properties, LookupElement.class, property -> {
            PsiNamedElement element = property.getPsiElement();
            LookupElementBuilder builder = LookupElementBuilder.createWithSmartPointer((String)RelaxedNames.camelCaseToHyphen(property.getName()), (PsiElement)element).withIcon(element.getIcon(0)).withStrikeoutness(property.getMethod().isDeprecated()).withTypeText(property.getPropertyType().getPresentableText());
            TailType tailType = this.getVariantTailType(property.getPropertyType());
            builder.putUserData(ConfigKeyPathUtils.TAIL_TYPE_KEY, (Object)tailType);
            return TailTypeDecorator.withTail((LookupElement)builder, (TailType)tailType);
        });
        if (objectArray == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        PsiClass valueClass = ConfigKeyPathUtils.getPsiClass(ConfigKeyPathUtils.unwrapIndexed(this.getPreviousValueType()));
        String location = valueClass == null ? "" : MicroservicesConfigBundle.message("config.unresolved.key.in.class", valueClass.getQualifiedName());
        String string = MicroservicesConfigBundle.message("config.unresolved.bean.property.key", this.getValue(), location);
        if (string == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        String name;
        if (newElementName == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(6);
        }
        return super.handleElementRename((name = PropertyUtilBase.getPropertyName((String)newElementName)) == null ? newElementName : name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String propertyName;
        if (element == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiMethod && (propertyName = PropertyUtilBase.getPropertyName((PsiMethod)((PsiMethod)element), (boolean)true)) != null) {
            return super.handleElementRename(propertyName);
        }
        return this.getElement();
    }

    @Nullable
    private PsiElement resolveProperty(@NotNull PsiType psiType, @NotNull String propertyName) {
        if (psiType == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            ConfigKeyPathBeanPropertyReference.$$$reportNull$$$0(9);
        }
        MetaConfigKey configKey = this.getContext().getKey();
        return configKey.getPropertyResolver().resolveProperty(configKey, ConfigKeyPathUtils.unwrapIndexed(psiType), propertyName);
    }

    @Nullable
    private PsiType getPreviousValueType() {
        ConfigKeyPathReference previous = this.getContext().getPrevious();
        return previous != null ? previous.getValueType() : this.getContext().getInitialValueType();
    }

    @Override
    @Nullable
    public PsiType getValueType() {
        PsiType previousValueType = ConfigKeyPathUtils.unwrapIndexed(this.getPreviousValueType());
        if (previousValueType == null) {
            return null;
        }
        PsiElement property = this.resolveProperty(previousValueType, this.getValue());
        return ConfigKeyPathBeanPropertyReference.getResolvedValueType(property, previousValueType);
    }

    @Override
    @Nullable
    public PsiClass getKeyClass() {
        PsiType resolvedType = ConfigKeyPathUtils.unwrapIndexed(this.getValueType());
        return ConfigKeyPathUtils.getPsiClass(ConfigKeyPathUtils.getMapKeyType(resolvedType));
    }

    @Nullable
    private static PsiType getResolvedValueType(PsiElement resolvedElement, PsiType previousType) {
        PsiType psiType = ConfigKeyPathBeanPropertyReference.getResolvedValueType(resolvedElement);
        if (psiType == null) {
            return null;
        }
        PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType((PsiType)previousType);
        return result.getSubstitutor().substitute(psiType);
    }

    @Nullable
    private static PsiType getResolvedValueType(PsiElement resolvedElement) {
        if (resolvedElement instanceof BeanPropertyElement) {
            PsiMethod method = ((BeanPropertyElement)resolvedElement).getMethod();
            return method.getReturnType();
        }
        if (resolvedElement instanceof PsiParameter) {
            return ((PsiParameter)resolvedElement).getType();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getValueElementType() {
        PsiElement resolve = this.resolve();
        if (!(resolve instanceof BeanPropertyElement)) {
            return null;
        }
        PsiType type = ((BeanPropertyElement)resolve).getPropertyType();
        if (type instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)type).getBoxedType(this.getElement());
        }
        return type == null ? null : MetaConfigKey.AccessType.forPsiType(type).getEffectiveValueType(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/ConfigKeyPathBeanPropertyReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/ConfigKeyPathBeanPropertyReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

