/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DeploymentTroubleInfoCollector
implements TroubleInfoCollector {
    DeploymentTroubleInfoCollector() {
    }

    @NotNull
    public String collectInfo(@NotNull Project project) {
        if (project == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(0);
        }
        StringBuilder output = new StringBuilder(2000);
        DeploymentTroubleInfoCollector.collectDeployment(project, output, true);
        String string = output.toString();
        if (string == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String toString() {
        return WDBundle.message("trouble.info.deployment", new Object[0]);
    }

    public static void collectDeployment(@NotNull Project project, @NotNull StringBuilder output, boolean additionalSettings) {
        if (project == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(2);
        }
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(3);
        }
        output.append("=====").append(WDBundle.message("trouble.info.deployment.deployment.settings", new Object[0])).append("=====\n");
        PluginId id = PluginId.getId((String)"com.jetbrains.plugins.webDeployment");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)id);
        if (PluginManagerCore.isPluginInstalled((PluginId)id) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled()) {
            PublishConfig publishConfig2 = PublishConfig.getInstance(project);
            List<WebServerGroupingWrap> wraps = GroupedServersConfigManager.getInstance(project).getGroupedServers();
            DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.default.server", new Object[0]), publishConfig2.getDefaultServerOrGroupName(), output);
            for (WebServerGroupingWrap wrap : wraps) {
                if (wrap.isSingleServer()) {
                    DeploymentTroubleInfoCollector.writeServerStatus(output, additionalSettings, publishConfig2, wrap.getAsSingleServer());
                    continue;
                }
                output.append("** ").append(WDBundle.message("trouble.info.group", new Object[0])).append(wrap.getName()).append(" **\n");
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.project.level", new Object[0]), wrap.isProjectLevel(), output);
                for (WebServerConfig server : wrap.getServers()) {
                    DeploymentTroubleInfoCollector.writeServerStatus(output, additionalSettings, publishConfig2, server);
                }
                output.append("*********\n");
            }
            if (additionalSettings) {
                output.append("=====").append(WDBundle.message("trouble.info.additional.settings", new Object[0])).append("=====\n");
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.exclude.items.by.name", new Object[0]), publishConfig2.getExcludeMask(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.operations.logging", new Object[0]), publishConfig2.getTraceLevel().name(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.overwrite.up.to.date.files", new Object[0]), publishConfig2.isOverwriteAll(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.preserve.file.timestamps", new Object[0]), publishConfig2.isPreserveTimestamps(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.delete.target.items.when.source.do.not.exist", new Object[0]), publishConfig2.isDeleteMissingItems(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.create.empty.directories", new Object[0]), publishConfig2.isCreateEmptyDirectories(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.prompt.when.overwriting.or.deleting.local.items", new Object[0]), publishConfig2.isPromptOnLocalOverwrite(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.upload.changed.files.automatically", new Object[0]), publishConfig2.getAutoUploadState().getPresentableName(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.upload.external.changes", new Object[0]), publishConfig2.isAutoUploadExternalChanges(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.upload.delete", new Object[0]), publishConfig2.isRemoteFilesAllowedToDisappearOnAutoupload(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.override.default.permissions.on.files", new Object[0]), publishConfig2.getFilePermissions(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.override.default.permissions.on.folders", new Object[0]), publishConfig2.getFolderPermissions(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.warn.when.uploading.over.newer.file", new Object[0]), publishConfig2.getPromptOnRemoteOverwrite().name(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.notify.of.remote.changes", new Object[0]), publishConfig2.isNotifyRemoteChanges(), output);
            }
        }
    }

    private static void writeServerStatus(@NotNull StringBuilder output, boolean additionalSettings, PublishConfig publishConfig2, WebServerConfig server) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(4);
        }
        output.append("------------------------\n");
        FileTransferConfig transferConfig = server.getFileTransferConfig();
        DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.server.name", new Object[0]), server.getName(), output);
        DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.server.type", new Object[0]), transferConfig.getAccessType().getTitle(), output);
        DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.project.level", new Object[0]), server.isProjectLevel(), output);
        DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.host", new Object[0]), transferConfig.getHost(), output);
        DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.port", new Object[0]), transferConfig.getPort(), output);
        DeploymentTroubleInfoCollector.appendEscapedEntry(WDBundle.message("trouble.info.root.path", new Object[0]), transferConfig.getRootFolder(), output);
        DeploymentTroubleInfoCollector.appendEscapedEntry(WDBundle.message("trouble.info.web.url", new Object[0]), server.getUrl(), output);
        List<DeploymentPathMapping> mappings = publishConfig2.getPathMappings(server.getId());
        DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.mappings", new Object[0]), "", output);
        for (DeploymentPathMapping deploymentPathMapping : mappings) {
            DeploymentTroubleInfoCollector.appendEscapedMappingEntry(deploymentPathMapping.getLocalPath(), deploymentPathMapping.getDeployPath(), output);
        }
        DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.excluded.paths", new Object[0]), "", output);
        List<ExcludedPath> excludedMappings = publishConfig2.getExcludedPaths(server.getId());
        for (ExcludedPath mapping : excludedMappings) {
            DeploymentTroubleInfoCollector.appendEscapedMappingEntry(mapping.getPath(), "", output);
        }
        AccessType accessType = server.getFileTransferConfig().getAccessType();
        if (additionalSettings && accessType != AccessType.LOCAL && accessType != AccessType.MOUNT) {
            if (accessType == AccessType.SFTP) {
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.auth.type", new Object[0]), server.getFileTransferConfig().getAuthType().toString(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.use.rsync", new Object[0]), transferConfig.getAdvancedOptions().isUseRsync(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.use.sudo", new Object[0]), transferConfig.getAdvancedOptions().isUseSudo(), output);
            }
            if (accessType == AccessType.FTP) {
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.compatibility.mode", new Object[0]), transferConfig.getAdvancedOptions().isCompatibilityMode(), output);
            }
            if (accessType == AccessType.FTPS) {
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.protect.data.chanel", new Object[0]), transferConfig.getAdvancedOptions().getDataChannelProtectionLevel().getPresentableValue(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.ftps.enabled.protocols", new Object[0]), transferConfig.getAdvancedOptions().getEnabledFtpsProtocols(), output);
            }
            if (accessType == AccessType.FTP || accessType == AccessType.FTPS) {
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.passive.mode", new Object[0]), transferConfig.getAdvancedOptions().isPassiveMode(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.show.and.process.hidden.files", new Object[0]), transferConfig.getAdvancedOptions().isShowHiddenFiles(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.use.keep.alive.command", new Object[0]), transferConfig.getAdvancedOptions().getKeepAliveFtpCommand().getCommand(), output);
                DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.always.use.list.command", new Object[0]), transferConfig.getAdvancedOptions().isForceListCommand(), output);
            }
            DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.control.encoding", new Object[0]), transferConfig.getAdvancedOptions().getControlEncoding(), output);
            DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.connections", new Object[0]), transferConfig.getAdvancedOptions().getNumberOfConnections(), output);
            DeploymentTroubleInfoCollector.appendEntry(WDBundle.message("trouble.info.send.keep.alive.messages.each.s", new Object[0]), transferConfig.getAdvancedOptions().getKeepAliveTimeout() / 1000, output);
        }
    }

    public static void appendEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(5);
        }
        output.append(key).append(" : ").append(value).append("\n");
    }

    private static void appendEntry(@Nullable String key, int value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(6);
        }
        DeploymentTroubleInfoCollector.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEntry(@Nullable String key, boolean value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(7);
        }
        DeploymentTroubleInfoCollector.appendEntry(key, String.valueOf(value), output);
    }

    private static void appendEscapedEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(8);
        }
        output.append(key).append(" : \"").append(value).append("\"\n");
    }

    private static void appendEscapedMappingEntry(@Nullable String key, @Nullable String value, @NotNull StringBuilder output) {
        if (output == null) {
            DeploymentTroubleInfoCollector.$$$reportNull$$$0(9);
        }
        output.append("\"").append(key).append("\" : \"").append(value).append("\"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/DeploymentTroubleInfoCollector";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentTroubleInfoCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectDeployment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeServerStatus";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendEntry";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedEntry";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendEscapedMappingEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

