/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.ui.PermissionsEditor;
import com.jetbrains.plugins.webDeployment.ui.PermissionsEditorForm;
import com.jetbrains.plugins.webDeployment.ui.PermissionsEditorTabForm;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public abstract class PermissionsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(PermissionsDialog.class);
    protected PermissionsEditor myForm;

    protected PermissionsDialog(Component parent, @NlsContexts.DialogTitle String title) {
        super(parent, false);
        this.setTitle(title);
        this.init();
    }

    protected abstract PermissionsEditor createEditor();

    @NlsContexts.Label
    @Nullable
    protected abstract String getErrorMessage();

    protected JComponent createCenterPanel() {
        this.myForm = this.createEditor();
        this.myForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String errorMessage = PermissionsDialog.this.getErrorMessage();
                if (errorMessage != null) {
                    PermissionsDialog.this.myForm.showMessage(errorMessage);
                    PermissionsDialog.this.setOKActionEnabled(false);
                } else {
                    PermissionsDialog.this.myForm.showMessage(null);
                    PermissionsDialog.this.setOKActionEnabled(true);
                }
            }
        });
        return this.myForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "webDeployment.PermissionsDialog";
    }

    public static class Tabs
    extends PermissionsDialog {
        public Tabs(Component parent, @NlsContexts.DialogTitle String title, int initialFilesPermissions, int initialFoldersPermissions) {
            super(parent, title);
            this.setSize(265, 455);
            ((PermissionsEditorTabForm)this.myForm).setFilesPermissions(initialFilesPermissions);
            ((PermissionsEditorTabForm)this.myForm).setFoldersPermissions(initialFoldersPermissions);
            ((PermissionsEditorTabForm)this.myForm).removeMnemonics();
        }

        @Override
        protected PermissionsEditor createEditor() {
            return new PermissionsEditorTabForm();
        }

        @Override
        @NlsContexts.Label
        @Nullable
        protected String getErrorMessage() {
            if (((PermissionsEditorTabForm)this.myForm).getFilesPermissions() == -2) {
                return WDBundle.message("invalid.file.permissions", new Object[0]);
            }
            if (((PermissionsEditorTabForm)this.myForm).getFoldersPermissions() == -2) {
                return WDBundle.message("invalid.folder.permissions", new Object[0]);
            }
            return null;
        }

        public int getFilesPermissions() {
            LOG.assertTrue(((PermissionsEditorTabForm)this.myForm).isValid());
            return ((PermissionsEditorTabForm)this.myForm).getFilesPermissions();
        }

        public int getFoldersPermissions() {
            LOG.assertTrue(((PermissionsEditorTabForm)this.myForm).isValid());
            return ((PermissionsEditorTabForm)this.myForm).getFoldersPermissions();
        }

        @Override
        protected String getDimensionServiceKey() {
            return "webDeployment.PermissionsDialog.Tabs";
        }
    }

    public static class Single
    extends PermissionsDialog {
        public Single(Component parent, @NlsContexts.DialogTitle String title, int initialPermissions) {
            super(parent, title);
            this.setSize(265, 235);
            ((PermissionsEditorForm)this.myForm).setPermissions(initialPermissions);
        }

        @Override
        protected PermissionsEditor createEditor() {
            return new PermissionsEditorForm();
        }

        @Override
        @NlsContexts.Label
        @Nullable
        protected String getErrorMessage() {
            return ((PermissionsEditorForm)this.myForm).isValid() ? null : WDBundle.message("invalid.permissions", new Object[0]);
        }

        public int getPermissions() {
            LOG.assertTrue(((PermissionsEditorForm)this.myForm).isValid());
            return ((PermissionsEditorForm)this.myForm).getPermissions();
        }
    }
}

