/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jakarta.data.repository.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.jakarta.data.repository.JakartaDataParserContext;
import com.intellij.javaee.jakarta.data.repository.JakartaDataRepositoryUtil;
import com.intellij.javaee.jakarta.data.repository.inspections.JakartaDataRepositoryInspection;
import com.intellij.javaee.jakarta.data.repository.jam.JakartaDataOrderBy;
import com.intellij.javaee.utils.persistence.data.inspections.PartTreeInconsistencyUtils;
import com.intellij.javaee.utils.persistence.data.parser.PartTree;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public final class JakartaDataRepositoryMethodInconsistencyInspection
extends JakartaDataRepositoryInspection {
    private static final List<String> ANNOTATIONS = Arrays.asList("jakarta.data.repository.Query", "jakarta.data.repository.Find", "jakarta.data.repository.Save", "jakarta.data.repository.Insert", "jakarta.data.repository.Delete", "jakarta.data.repository.Update");

    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @Nullable Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            JakartaDataRepositoryMethodInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if (psiMethod == null) {
            JakartaDataRepositoryMethodInconsistencyInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            JakartaDataRepositoryMethodInconsistencyInspection.$$$reportNull$$$0(2);
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod.getJavaPsi(), ANNOTATIONS, (int)0)) {
            JakartaDataRepositoryMethodInconsistencyInspection.checkMethodName(holder, psiMethod, typePair);
            JakartaDataRepositoryMethodInconsistencyInspection.checkOrderByAnnotation(holder, psiMethod);
        }
    }

    private static void checkOrderByAnnotation(@NotNull ProblemsHolder holder, @NotNull UMethod psiMethod) {
        JakartaDataOrderBy orderBy;
        if (holder == null) {
            JakartaDataRepositoryMethodInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if (psiMethod == null) {
            JakartaDataRepositoryMethodInconsistencyInspection.$$$reportNull$$$0(4);
        }
        if ((orderBy = (JakartaDataOrderBy)JakartaDataOrderBy.META.getJamElement((PsiModifierListOwner)psiMethod.getJavaPsi())) != null) {
            JakartaDataRepositoryMethodInconsistencyInspection.checkQlAttributeResolve(holder, orderBy.getValueAttr());
        }
    }

    private static void checkMethodName(@NotNull ProblemsHolder holder, @NotNull UMethod uMethod, @Nullable Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            JakartaDataRepositoryMethodInconsistencyInspection.$$$reportNull$$$0(5);
        }
        if (uMethod == null) {
            JakartaDataRepositoryMethodInconsistencyInspection.$$$reportNull$$$0(6);
        }
        if (JakartaDataRepositoryUtil.isQueryMethod(uMethod.getJavaPsi())) {
            PsiClass domainClass;
            String methodName = uMethod.getName();
            PsiClass psiClass = domainClass = typePair != null ? (PsiClass)typePair.getFirst() : JakartaDataRepositoryUtil.getEntityClassByMethodReturnType(uMethod.getReturnType());
            if (domainClass == null) {
                return;
            }
            PartTree partTree = new PartTree(methodName, domainClass, (PartTreeParserContext)JakartaDataParserContext.create());
            PartTreeInconsistencyUtils.checkParts((ProblemsHolder)holder, (UMethod)uMethod, (PartTree)partTree);
            PartTreeInconsistencyUtils.checkOrderBy((ProblemsHolder)holder, (UMethod)uMethod, (PartTree)partTree);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/jakarta/data/repository/inspections/JakartaDataRepositoryMethodInconsistencyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepositoryMethod";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrderByAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

