/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringAutodetectedModelsSearcher;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.StandaloneLocalXmlModel;
import com.intellij.spring.contexts.model.graph.LazyModelDependenciesGraph;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.profiles.SpringProfilesService;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.Chunk;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringAutoConfiguredModels {
    public static final List<String> bootAnnotations = List.of("org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.autoconfigure.EnableAutoConfiguration");

    @NotNull
    public static Set<SpringModel> discoverAutoConfiguredModels(@NotNull Module module) {
        Set<SpringModel> models;
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(0);
        }
        if (!(models = SpringAutoConfiguredModels.getModelsFromProviders(module)).isEmpty()) {
            Set<SpringModel> set = models;
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(1);
            }
            return set;
        }
        return SpringAutoConfiguredModels.getModels(module);
    }

    @NotNull
    private static Set<SpringModel> getModels(@NotNull Module module) {
        Set<LocalModel<?>> autoConfiguredModels;
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(2);
        }
        if ((autoConfiguredModels = SpringAutoConfiguredModels.getAutoConfiguredLocalModels(module)).isEmpty()) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringAutoConfiguredModels.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<SpringModel> set = Collections.singleton(new CombinedSpringModelImpl(autoConfiguredModels, module));
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public static Set<SpringModel> getModelsFromProviders(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(5);
        }
        return SpringAutoConfiguredModels.getModelsFromProviders(module, module);
    }

    @NotNull
    public static Set<SpringModel> getModelsFromProviders(@NotNull Module module, @NotNull Module contextModule) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(6);
        }
        if (contextModule == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(7);
        }
        HashSet<SpringModel> models = new HashSet<SpringModel>();
        for (SpringAutodetectedModelsSearcher modelsSearcher : SpringAutodetectedModelsSearcher.EP_NAME.getExtensionList()) {
            models.addAll(modelsSearcher.getAutodetectedModels(module, contextModule));
        }
        HashSet<SpringModel> hashSet = models;
        if (hashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Set<LocalModel<?>> getAutoConfiguredLocalModels(@NotNull Module module) {
        Set<LocalModel<?>> localModels;
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(9);
        }
        if (!(localModels = SpringAutoConfiguredModels.getLocalModelCandidates(module)).isEmpty()) {
            return SpringAutoConfiguredModels.filterAutoConfiguredModelsSet(localModels, module);
        }
        Set<LocalModel<?>> set = Collections.emptySet();
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public static Set<LocalModel<?>> getLocalModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(11);
        }
        LinkedHashSet localModels = new LinkedHashSet();
        localModels.addAll(SpringAutoConfiguredModels.getLocalAnnotationModelCandidates(module));
        localModels.addAll(SpringAutoConfiguredModels.getLocalXmlModelCandidates(module));
        LinkedHashSet linkedHashSet = localModels;
        if (linkedHashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<LocalModel<?>> filterAutoConfiguredModelsSet(@NotNull Set<LocalModel<?>> models, @NotNull Module module) {
        if (models == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(13);
        }
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(14);
        }
        LazyModelDependenciesGraph graph = SpringAutoConfiguredModels.getModelsGraph(models, module);
        HashSet configuredModels = new HashSet();
        Graph sccGraph = GraphAlgorithms.getInstance().computeSCCGraph((Graph)graph);
        for (Chunk chunk : sccGraph.getNodes()) {
            Set chunkNodes;
            if (sccGraph.getIn((Object)chunk).hasNext() || !(chunkNodes = chunk.getNodes()).iterator().hasNext()) continue;
            configuredModels.add((LocalModel)chunkNodes.iterator().next());
        }
        HashSet hashSet = configuredModels;
        if (hashSet == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    @NotNull
    private static LazyModelDependenciesGraph getModelsGraph(final @NotNull Set<LocalModel<?>> models, @NotNull Module module) {
        if (models == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(16);
        }
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(17);
        }
        return new LazyModelDependenciesGraph(module, Collections.emptySet()){

            @NotNull
            public Collection<LocalModel<?>> getNodes() {
                Set set = models;
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/impl/SpringAutoConfiguredModels$1", "getNodes"));
            }
        };
    }

    @NotNull
    private static Set<LocalAnnotationModel> getLocalAnnotationModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(18);
        }
        List configurations = SpringJamModel.getModel((Project)module.getProject()).getConfigurations(SpringGlobalSearchScopes.moduleWithDependencies((Module)module), module);
        Set<LocalAnnotationModel> set = configurations.stream().filter(configuration -> {
            PsiFile file = configuration.getContainingFile();
            return file != null && !SpringAutoConfiguredModels.isInTestSourceContent(file.getProject(), file.getVirtualFile());
        }).filter(configuration -> SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)configuration.getPsiElement())).map(configuration -> SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(configuration.getPsiElement(), module, SpringProfilesService.getInstance((Project)module.getProject()).getActiveProfiles(module))).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(19);
        }
        return set;
    }

    @NotNull
    public static Set<LocalXmlModel> getLocalXmlModelCandidates(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(20);
        }
        return SpringAutoConfiguredModels.getLocalXmlModelCandidates(module, SpringGlobalSearchScopes.moduleWithDependencies((Module)module));
    }

    @NotNull
    public static Set<LocalXmlModel> getLocalXmlModelCandidates(@NotNull Module module, GlobalSearchScope searchScope) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(21);
        }
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, searchScope);
        Set<LocalXmlModel> set = springXmlCandidates.stream().filter(vf -> ApplicationManager.getApplication().isUnitTestMode() || !SpringAutoConfiguredModels.isInTestSourceContent(project, vf)).map(file -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile instanceof XmlFile) {
                return StandaloneLocalXmlModel.getOrCreate((XmlFile)psiFile, module, SpringProfilesService.getInstance((Project)module.getProject()).getActiveProfiles(module));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(22);
        }
        return set;
    }

    private static boolean isInTestSourceContent(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(23);
        }
        return vf != null && ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(vf);
    }

    public static boolean hasAutoConfiguredModels(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredModels.$$$reportNull$$$0(24);
        }
        return !module.isDisposed() && !SpringAutoConfiguredModels.getAutoConfiguredLocalModels(module).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 8, 10, 12, 15, 19, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/impl/SpringAutoConfiguredModels";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/impl/SpringAutoConfiguredModels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverAutoConfiguredModels";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsFromProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfiguredLocalModels";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalModelCandidates";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAutoConfiguredModelsSet";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAnnotationModelCandidates";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalXmlModelCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "discoverAutoConfiguredModels";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModels";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModelsFromProviders";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfiguredLocalModels";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocalModelCandidates";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterAutoConfiguredModelsSet";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getModelsGraph";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModelCandidates";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLocalXmlModelCandidates";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasAutoConfiguredModels";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 8, 10, 12, 15, 19, 22 -> new IllegalStateException(string);
        };
    }
}

