/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinitionBase;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CNamespaceValueBaseImpl
extends SpringValueHolderDefinitionBase
implements CNamespaceDomElement {
    @NotNull
    public List<PsiType> getRequiredTypes() {
        SpringBean bean = (SpringBean)this.getParent();
        assert (bean != null);
        LinkedHashSet<PsiType> psiTypes = new LinkedHashSet<PsiType>();
        List psiMethods = bean.getInstantiationMethods();
        for (PsiMethod psiMethod : psiMethods) {
            int idx = 0;
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (this.matchesByName(psiParameter) || this.matchesByIndex(idx)) {
                    psiTypes.add(psiParameter.getType());
                }
                ++idx;
            }
        }
        return new ArrayList<PsiType>(psiTypes);
    }

    public boolean isIndexAttribute() {
        String attributeName = this.getAttributeName();
        return StringUtil.startsWithChar((CharSequence)attributeName, (char)'_') && attributeName.length() >= 2;
    }

    @Nullable
    public Integer getIndex() {
        String number = this.getAttributeName().substring(1);
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private boolean matchesByIndex(int matchIndex) {
        if (!this.isIndexAttribute()) {
            return false;
        }
        Integer myIndex = this.getIndex();
        return myIndex != null && myIndex == matchIndex;
    }

    private boolean matchesByName(PsiParameter psiParameter) {
        return this.getAttributeName().equals(psiParameter.getName());
    }
}

