/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.run;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.impl.RawNavigationRequest;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.run.SpringMultipleOccurrencesFilter;
import com.intellij.util.OpenSourceUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AutowireMethodFieldLinkFilter
extends SpringMultipleOccurrencesFilter {
    private static final String AUTOWIRE_FIELD = "autowire field: ";
    private static final String[] DETECTION_MESSAGES = new String[]{"autowire method: ", "autowire field: "};

    @Override
    @Nullable
    protected Filter.Result findNextOccurrence(int startOffset, String line, int entireLength) {
        int index = -1;
        int messageLength = -1;
        boolean localIsField = false;
        for (String message : DETECTION_MESSAGES) {
            index = StringUtil.indexOf((CharSequence)line, (CharSequence)message, (int)startOffset);
            if (index == -1) continue;
            messageLength = message.length();
            localIsField = message.equals(AUTOWIRE_FIELD);
            break;
        }
        if (index == -1) {
            return null;
        }
        int methodSignatureStart = index + messageLength;
        int methodSignatureEnd = StringUtil.indexOf((CharSequence)line, (char)';', (int)methodSignatureStart);
        if (methodSignatureEnd == -1) {
            return null;
        }
        String methodSignature = line.substring(methodSignatureStart, methodSignatureEnd);
        int textStartOffset = entireLength - line.length() + methodSignatureStart;
        boolean isFieldMode = localIsField;
        return new Filter.Result(textStartOffset, textStartOffset + methodSignature.length(), project -> {
            Couple<String> parseResult = AutowireMethodFieldLinkFilter.parseSignature(methodSignature, isFieldMode);
            if (parseResult == null) {
                AutowireMethodFieldLinkFilter.showResult((context, editor) -> HintManager.getInstance().showErrorHint(editor, SpringBundle.message("model.method.signature.parse.error.message", methodSignature)));
                return;
            }
            final String classname = (String)parseResult.getFirst();
            String methodName = (String)parseResult.getSecond();
            AutowireMethodFieldLinkFilter.showResult((context, editor) -> {
                final ConsoleView consoleView = (ConsoleView)LangDataKeys.CONSOLE_VIEW.getData(context);
                if (consoleView == null) {
                    return;
                }
                Navigatable navigatable = new Navigatable(){
                    final /* synthetic */ Editor val$editor;
                    final /* synthetic */ boolean val$isFieldMode;
                    final /* synthetic */ String val$methodName;
                    {
                        this.val$editor = editor;
                        this.val$isFieldMode = bl;
                        this.val$methodName = string2;
                    }

                    @Nullable
                    public NavigationRequest navigationRequest() {
                        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(classname.replace('$', '.'), GlobalSearchScope.allScope((Project)project));
                        if (psiClass == null) {
                            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)consoleView)).submit(() -> HintManager.getInstance().showErrorHint(this.val$editor, SpringBundle.message("model.method.resolve.class.error.message", classname)));
                            return null;
                        }
                        if (this.val$isFieldMode) {
                            PsiField field = psiClass.findFieldByName(this.val$methodName, true);
                            if (field != null) {
                                return new RawNavigationRequest((Navigatable)field, true);
                            }
                            return null;
                        }
                        PsiMethod[] methods = psiClass.findMethodsByName(this.val$methodName, true);
                        if (methods.length == 1) {
                            return new RawNavigationRequest((Navigatable)methods[0], true);
                        }
                        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)consoleView)).submit(() -> new PsiTargetNavigator((PsiElement[])methods).tabTitle(SpringBundle.message("spring.bean.show.beans.candidates.title", new Object[0])).navigate(this.val$editor, SpringBundle.message("model.method.choose.method", new Object[0])));
                        return null;
                    }
                };
                DataContext wrapper = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.NAVIGATABLE, (Object)navigatable, (DataContext)context);
                OpenSourceUtil.openSourcesFrom((DataContext)wrapper, (boolean)true);
            });
        });
    }

    @Nullable
    public static Couple<String> parseSignature(String methodSignature, boolean isFieldMode) {
        int openParenthIdx = isFieldMode ? methodSignature.length() : methodSignature.lastIndexOf(40);
        int lastSpace = methodSignature.lastIndexOf(32);
        if (openParenthIdx == -1 || lastSpace == -1) {
            return null;
        }
        if (lastSpace + 1 >= openParenthIdx) {
            return null;
        }
        String qualifiedMethodName = methodSignature.substring(lastSpace + 1, openParenthIdx);
        int methodNameLastDot = qualifiedMethodName.lastIndexOf(46);
        if (methodNameLastDot == -1) {
            return null;
        }
        String classname = qualifiedMethodName.substring(0, methodNameLastDot);
        String methodName = isFieldMode ? methodSignature.substring(methodSignature.lastIndexOf(46) + 1) : methodSignature.substring(methodSignature.indexOf(classname) + classname.length() + 1, openParenthIdx);
        return Couple.of((Object)classname, (Object)methodName);
    }
}

