/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.uast.testFramework.common;

import com.intellij.platform.uast.testFramework.common.RenderLogTestBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.testFramework.EqualsToFile;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;
import org.junit.Assert;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u000e\u001a\u00020\t*\u00020\u000bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/uast/testFramework/common/RenderLogTestBase;", "", "getTestDataPath", "", "getTestFile", "Ljava/io/File;", "testName", "ext", "check", "", "file", "Lorg/jetbrains/uast/UFile;", "checkParentConsistency", "", "checkContainingFileForAllElements", "intellij.platform.uast.testFramework"})
public interface RenderLogTestBase {
    @NotNull
    public String getTestDataPath();

    private File getTestFile(String testName, String ext) {
        return new File(this.getTestDataPath(), StringsKt.substringBeforeLast$default((String)testName, (char)'.', null, (int)2, null) + "." + ext);
    }

    default public void check(@NotNull String testName, @NotNull UFile file) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.check(testName, file, true);
    }

    default public void check(@NotNull String testName, @NotNull UFile file, boolean checkParentConsistency2) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File renderFile = this.getTestFile(testName, "render.txt");
        File logFile = this.getTestFile(testName, "log.txt");
        EqualsToFile.assertEqualsToFile("Render string", renderFile, file.asRenderString());
        EqualsToFile.assertEqualsToFile("Log string", logFile, UastUtils.asRecursiveLogString$default((UElement)((UElement)file), null, (int)1, null));
        if (checkParentConsistency2) {
            this.checkParentConsistency(file);
        }
        this.checkContainingFileForAllElements(file);
    }

    default public void checkParentConsistency(@NotNull UFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map parentMap = new LinkedHashMap();
        file.accept(new UastVisitor(parentMap){
            private final Stack<UElement> parentStack;
            final /* synthetic */ Map<PsiElement, String> $parentMap;
            {
                this.$parentMap = $parentMap;
                this.parentStack = new Stack<E>();
            }

            public boolean visitElement(UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement parent = node.getUastParent();
                if (parent == null) {
                    Object object;
                    Assert.assertTrue((String)("Wrong null-parent of " + node.getClass() + " '" + ((object = node.getSourcePsi()) != null && (object = object.getText()) != null && (object = StringsKt.lineSequence((CharSequence)((CharSequence)object))) != null ? (String)SequencesKt.firstOrNull((Sequence)object) : null) + "'"), (boolean)this.parentStack.empty());
                } else {
                    Object object;
                    Assert.assertEquals((String)("Wrong parent of " + node.getClass() + " '" + ((object = node.getSourcePsi()) != null && (object = object.getText()) != null && (object = StringsKt.lineSequence((CharSequence)((CharSequence)object))) != null ? (String)SequencesKt.firstOrNull((Sequence)object) : null) + "'"), (Object)this.parentStack.peek(), (Object)parent);
                }
                PsiElement psiElement = node.getSourcePsi();
                if (psiElement != null) {
                    PsiElement psiElement2 = psiElement;
                    Map<PsiElement, String> map = this.$parentMap;
                    PsiElement it = psiElement2;
                    boolean bl = false;
                    if (!map.containsKey(it)) {
                        map.put(it, CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)this.parentStack), null, null, null, (int)0, null, checkParentConsistency.1::visitElement$lambda$0$0, (int)31, null));
                    }
                }
                this.parentStack.push(node);
                return false;
            }

            public void afterVisitElement(UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super.afterVisitElement(node);
                this.parentStack.pop();
            }

            private static final CharSequence visitElement$lambda$0$0(UElement it) {
                return it.asLogString();
            }
        });
        file.getSourcePsi().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(parentMap){
            final /* synthetic */ Map<PsiElement, String> $parentMap;
            {
                this.$parentMap = $parentMap;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                UElement uElement = UastContextKt.toUElement((PsiElement)element);
                String expectedParents = this.$parentMap.get(element);
                if (expectedParents != null) {
                    Assert.assertNotNull((String)("Expected to be able to convert PSI element " + element), (Object)uElement);
                    UElement uElement2 = uElement;
                    Intrinsics.checkNotNull((Object)uElement2);
                    String parents = SequencesKt.joinToString$default((Sequence)SequencesKt.generateSequence((Object)uElement2.getUastParent(), checkParentConsistency.2::visitElement$lambda$0), null, null, null, (int)0, null, checkParentConsistency.2::visitElement$lambda$1, (int)31, null);
                    Assert.assertEquals((String)("Inconsistent parents for " + uElement + " (converted from " + element + ") parent: -> " + uElement.getUastParent()), (Object)expectedParents, (Object)parents);
                }
                super.visitElement(element);
            }

            private static final UElement visitElement$lambda$0(UElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getUastParent();
            }

            private static final CharSequence visitElement$lambda$1(UElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.asLogString();
            }
        });
    }

    default public void checkContainingFileForAllElements(@NotNull UFile $this$checkContainingFileForAllElements) {
        Intrinsics.checkNotNullParameter((Object)$this$checkContainingFileForAllElements, (String)"<this>");
        $this$checkContainingFileForAllElements.accept(new UastVisitor($this$checkContainingFileForAllElements){
            final /* synthetic */ UFile $this_checkContainingFileForAllElements;
            {
                this.$this_checkContainingFileForAllElements = $receiver;
            }

            public boolean visitElement(UElement node) {
                PsiElement anchorPsi;
                UElement uastAnchor;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                if (psiElement != null) {
                    PsiElement psiElement2 = psiElement;
                    UFile uFile = this.$this_checkContainingFileForAllElements;
                    PsiElement sourcePsi = psiElement2;
                    boolean bl = false;
                    UElement uElement = UastContextKt.toUElement((PsiElement)sourcePsi);
                    Intrinsics.checkNotNull((Object)uElement);
                    UElement uElement2 = uElement;
                    Assert.assertEquals((String)("getContainingUFile should be equal to source for " + uElement2.getClass() + " for " + sourcePsi.getText()), (Object)uFile, (Object)UastUtils.getContainingUFile((UElement)uElement2));
                }
                Lazy nodeContainingFile$delegate = LazyKt.lazy(() -> checkContainingFileForAllElements.1.visitElement$lambda$1(node));
                UDeclaration uDeclaration = node instanceof UDeclaration ? (UDeclaration)node : null;
                Object object = uastAnchor = uDeclaration != null ? uDeclaration.getUastAnchor() : null;
                if (uastAnchor != null) {
                    PsiElement psiElement3 = node.getSourcePsi();
                    PsiElement psiElement4 = uastAnchor.getSourcePsi();
                    Assert.assertEquals((String)("should be appropriate sourcePsi for uastAnchor for " + node.getClass() + " [" + (psiElement3 != null ? psiElement3.getText() : null) + "] "), (Object)checkContainingFileForAllElements.1.visitElement$lambda$2((Lazy<? extends PsiFile>)nodeContainingFile$delegate), (Object)(psiElement4 != null ? psiElement4.getContainingFile() : null));
                }
                UElement uElement = uastAnchor;
                Object object2 = anchorPsi = uElement != null ? uElement.getSourcePsi() : null;
                if (anchorPsi != null) {
                    Assert.assertEquals((Object)anchorPsi.getContainingFile(), (Object)checkContainingFileForAllElements.1.visitElement$lambda$2((Lazy<? extends PsiFile>)nodeContainingFile$delegate));
                }
                return false;
            }

            private static final PsiFile visitElement$lambda$1(UElement $node) {
                PsiElement psiElement;
                block3: {
                    for (UElement it : UElementKt.getWithContainingElements((UElement)$node)) {
                        boolean bl = false;
                        psiElement = it.getSourcePsi();
                        if (psiElement == null) {
                            continue;
                        }
                        break block3;
                    }
                    psiElement = null;
                }
                if (psiElement == null) {
                    throw new NoSuchElementException("No element of the sequence was transformed to a non-null value.");
                }
                PsiFile psiFile = psiElement.getContainingFile();
                Intrinsics.checkNotNull((Object)psiFile);
                return psiFile;
            }

            private static final PsiFile visitElement$lambda$2(Lazy<? extends PsiFile> $nodeContainingFile$delegate) {
                Lazy<? extends PsiFile> lazy = $nodeContainingFile$delegate;
                return (PsiFile)lazy.getValue();
            }
        });
    }
}

