/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.actions.DatabaseToggleNotebookModeAction;
import com.intellij.database.actions.ProcessDbmsOutputAction;
import com.intellij.database.actions.ShowSqlParametersPanelAction;
import com.intellij.database.console.ConsoleErrorProviderWrapper;
import com.intellij.database.console.ExecutionConcession;
import com.intellij.database.console.InlineProgressHelper;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.console.SearchPathReceiver;
import com.intellij.database.console.SearchPathSender;
import com.intellij.database.console.client.DatabaseScriptingSessionClient;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.migration.ConsolesMigrationUtilsKt;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseClientLogViewBase;
import com.intellij.database.console.session.DatabaseConsoleHistoryController;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.SqlAffectAnalyzer;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.introspection.CombinedIntrospectionTask;
import com.intellij.database.introspection.Impactees;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.run.audit.JdbcConsoleAuditor;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.StateWatcher;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DataSourceUtilKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.content.Content;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.impl.evaluate.ValueLookupManagerController;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class JdbcConsole
extends AbstractQueryLanguageConsole<DatabaseConnectionPoint, DatabaseSessionClientWithFile>
implements JdbcConsoleBase,
SearchPathReceiver.Listener {
    private static final Key<List<IntrospectionTask>> INTROSPECTION_TASKS = Key.create((String)"INTROSPECTION_TASKS");
    private static final Key<IntrospectionScopeUpdater> SCOPE_UPDATER = Key.create((String)"SCOPE_UPDATER");
    private static final String TOGGLE_CONSOLE_TOOLBAR_PROP = "Database.Console";
    private final AtomicReference<SearchPath> mySearchPath;
    private final AtomicReference<Boolean> myScheduleRefresh;
    private final AtomicReference<ScriptModel<?>> myScriptModel;
    private final DatabaseSession mySession;
    private final VirtualFile myVirtualFile;
    private final EventDispatcher<SearchPathReceiver> myPathDispatcher;
    private final DGDepartment.Console myDepartment;
    private final InlineProgressHelper myProgressHelper;
    private ScriptingClientDataConsumer myConsumer;
    private volatile boolean myNotebookMode;

    public LanguageConsoleView getConsoleView() {
        return JdbcConsole.getLangConsoleView(this.getView());
    }

    @NotNull
    public static Builder newConsole(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(0);
        }
        return new Builder(project);
    }

    @NotNull
    public static ToggleToolbarAction createToggleConsoleToolbarAction(@NotNull Project project) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(1);
        }
        ToggleToolbarAction action = ToggleToolbarAction.createAction((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)project), () -> DatabaseEditorHelper.getAllOpenedEditors(project).filter(editorEx -> {
            VirtualFile vFile = editorEx.getVirtualFile();
            return editorEx.getPermanentHeaderComponent() != null && (JdbcConsoleProviderCore.getValidConsole((Project)project, (VirtualFile)vFile) != null || DbImplUtil.isSqlScriptFile((Project)project, (VirtualFile)vFile) && !DbImplUtil.isDatabaseVirtualFile((VirtualFile)vFile));
        }).map(o -> o.getComponent()));
        action.getTemplatePresentation().setText(ConsolesMigrationUtilsKt.resolveConsolesMigrationDependentString(DatabaseBundle.message((String)"JdbcConsole.toolbar.text.legacy", (Object[])new Object[0]), DatabaseBundle.message((String)"JdbcConsole.toolbar.text", (Object[])new Object[0])));
        ToggleToolbarAction toggleToolbarAction = action;
        if (toggleToolbarAction == null) {
            JdbcConsole.$$$reportNull$$$0(2);
        }
        return toggleToolbarAction;
    }

    public static boolean beforeExecuteRange(@NotNull JdbcConsole console, TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(3);
        }
        if (range.isEmpty()) {
            return false;
        }
        ScriptModel subModel = console.getScriptModel().subModel(range);
        return console.beforeExecuteQueries(subModel);
    }

    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console, @NotNull Editor editor2) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            JdbcConsole.$$$reportNull$$$0(5);
        }
        TextRange range = ScriptModelUtil.getSelectedStatementsRange((DatabaseScriptingSessionClient)console, editor2, DatabaseSettings.getDefaultExecOption());
        return JdbcConsole.getQueryText(console, range);
    }

    @Nullable
    public static String getQueryText(@NotNull JdbcConsole console, @NotNull TextRange range) {
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(6);
        }
        if (range == null) {
            JdbcConsole.$$$reportNull$$$0(7);
        }
        if (range.isEmpty()) {
            return null;
        }
        ScriptModel consoleSubModel = console.getScriptModel().subModel(range);
        JBIterable parameters = consoleSubModel.parameters();
        JBIterable externals = consoleSubModel.externals();
        String selected = range.subSequence((CharSequence)console.getDocument().getText()).toString();
        return ScriptModelUtilCore.statementText((ScriptModel.PStorage)console.getPStorage(), (JBIterable)parameters, (JBIterable)externals, (String)selected, (int)0);
    }

    public static DataAuditor createAdvancedErrorsObtainer(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(8);
        }
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(9);
        }
        return new ConsoleErrorProviderWrapper(project, dataSource);
    }

    private JdbcConsole(@NotNull Project project, @NotNull VirtualFile file, @NotNull DatabaseSession session, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseSession old) {
        if (project == null) {
            JdbcConsole.$$$reportNull$$$0(10);
        }
        if (file == null) {
            JdbcConsole.$$$reportNull$$$0(11);
        }
        if (session == null) {
            JdbcConsole.$$$reportNull$$$0(12);
        }
        if (connectionPoint == null) {
            JdbcConsole.$$$reportNull$$$0(13);
        }
        super(project, connectionPoint, session.getMessageBus());
        this.mySearchPath = new AtomicReference();
        this.myScheduleRefresh = new AtomicReference<Boolean>(false);
        this.myScriptModel = new AtomicReference();
        this.myPathDispatcher = EventDispatcher.create(SearchPathReceiver.class);
        this.myVirtualFile = file;
        this.mySession = session;
        this.myDepartment = new DGDepartment.Console(SessionsUtil.getQualifiedClientTitle((Project)project, (DasDataSource)connectionPoint.getDataSource(), (VirtualFile)file));
        JdbcDriverManager.getDriverManager((Project)this.getProject()).addModificationTrackerListener((ModificationTrackerListener)new FilePresentationUpdater(), (Disposable)this);
        this.getMessageBus().addAuditor((DataAuditor)new JdbcConsoleAuditor(this));
        if (old == null) {
            session.attach((DatabaseSessionClient)this);
        } else {
            old.exchange((DatabaseSessionClient)this, session);
        }
        this.myProgressHelper = new InlineProgressHelper(this);
        this.myNotebookMode = DatabaseToggleNotebookModeAction.isNotebookMode(project, file);
        ProcessDbmsOutputAction.applySavedValue(this);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.getView();
        }
    }

    @NotNull
    private ScriptModel<?> updateScriptModel(@Nullable ScriptModel<?> prevModel) {
        if (prevModel != null) {
            Disposer.dispose(prevModel);
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)this.getProject()).createScriptModel(this.getFile());
        Disposer.register((Disposable)this, (Disposable)model);
        ScriptModel scriptModel = model;
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(14);
        }
        return scriptModel;
    }

    public void setNotebookMode(boolean enabled, boolean persist) {
        if (!DatabaseToggleNotebookModeAction.isAvailable(this.getProject(), this.getVirtualFile())) {
            return;
        }
        this.myNotebookMode = enabled;
        if (persist) {
            DatabaseToggleNotebookModeAction.setNotebookMode(this.getProject(), this, enabled);
        }
    }

    public boolean isNotebookMode() {
        return DatabaseToggleNotebookModeAction.isAvailable(this.getProject(), this.getVirtualFile()) && this.myNotebookMode;
    }

    @Nullable
    public Icon getIcon() {
        return DbVFSUtils.isConsoleFile((VirtualFile)this.myVirtualFile) || QueryFilesUtilsKt.isQueryFilesFlagEnabled() ? this.getDataSource().getIcon() : this.myVirtualFile.getFileType().getIcon();
    }

    @NotNull
    public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor2) {
        if (editor2 == null) {
            JdbcConsole.$$$reportNull$$$0(15);
        }
        Collection<Object> collection = this.myConsumer == null ? Collections.emptyList() : this.myConsumer.getEmbeddedResults(editor2);
        if (collection == null) {
            JdbcConsole.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public InlineProgressHelper getProgressHelper() {
        InlineProgressHelper inlineProgressHelper = this.myProgressHelper;
        if (inlineProgressHelper == null) {
            JdbcConsole.$$$reportNull$$$0(17);
        }
        return inlineProgressHelper;
    }

    public int getTxIsolation() {
        return this.mySession.getTxIsolation();
    }

    public void setTxIsolation(int isolation) {
        this.mySession.setTxIsolation(isolation);
    }

    @NotNull
    public Document getDocument() {
        Document document = Objects.requireNonNull(FileDocumentManager.getInstance().getDocument(this.myVirtualFile));
        if (document == null) {
            JdbcConsole.$$$reportNull$$$0(18);
        }
        return document;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiUtilCore.getPsiFile((Project)this.getProject(), (VirtualFile)this.myVirtualFile));
        if (psiFile == null) {
            JdbcConsole.$$$reportNull$$$0(19);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = SessionsUtil.getClientTitle((VirtualFile)this.getVirtualFile());
        if (string == null) {
            JdbcConsole.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isTargetValid();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getDisplayName() {
        String string = SessionsUtil.getQualifiedClientTitle((DatabaseSessionClientWithFile)this);
        if (string == null) {
            JdbcConsole.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getFile().getLanguage();
        if (language == null) {
            JdbcConsole.$$$reportNull$$$0(22);
        }
        return language;
    }

    public boolean isActive() {
        return true;
    }

    public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger) {
        if (trigger == null) {
            JdbcConsole.$$$reportNull$$$0(23);
        }
        LogView view = DatabaseSessionViewService.getInstance().getClientViewIfAny((DatabaseSessionClientWithFile)this);
        DatabaseSession.State state = this.getSession().getState();
        DatabaseSession.State.Work work = state.getWorkFor((DataRequest.Owner)this);
        if (trigger != DatabaseSessionClient.DetachTrigger.FILE_CLOSED || (view == null || view.isEmpty()) && (work == null || work.getState() == DatabaseSession.State.WorkState.FINISHED)) {
            VirtualFile file = this.getVirtualFile();
            JdbcConsoleProvider.detachConsole(this.getProject(), file);
            if (trigger != DatabaseSessionClient.DetachTrigger.SESSION_SWITCH) {
                DatabaseSessionViewService.getInstance().destroyView((DatabaseSessionClientWithFile)this);
                if (DbVFSUtils.isConsoleFile((VirtualFile)file)) {
                    FileEditorManager.getInstance((Project)this.getProject()).closeFile(file);
                }
            }
        }
    }

    public boolean showOnAttention(@NotNull DataRequest.Context context) {
        ConsoleDataRequest request;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(24);
        }
        return (request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class)) != null && (request.queryIndex == 0 || !request.hasNext);
    }

    public boolean focusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(25);
        }
        return !(context.request instanceof ConsoleDataRequest) && !(context.request.owner instanceof ConsoleGridDataHookUp);
    }

    public boolean getShowOnActivity() {
        return true;
    }

    @NotNull
    public DatabaseDepartment getDepartment() {
        DGDepartment.Console console = this.myDepartment;
        if (console == null) {
            JdbcConsole.$$$reportNull$$$0(26);
        }
        return console;
    }

    @NotNull
    public DatabaseSession getSession() {
        DatabaseSession databaseSession = this.mySession;
        if (databaseSession == null) {
            JdbcConsole.$$$reportNull$$$0(27);
        }
        return databaseSession;
    }

    @NotNull
    public PlaceInGrid getResultsPlaceInView() {
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            JdbcConsole.$$$reportNull$$$0(28);
        }
        return placeInGrid;
    }

    public GridDataHookUp<GridRow, GridColumn> createGridDataHookUp(@NotNull Disposable parent2) {
        if (parent2 == null) {
            JdbcConsole.$$$reportNull$$$0(29);
        }
        ConsoleGridDataHookUp hookUp = DbGridDataHookUpUtil.createDatabaseHookUp(this.getProject(), parent2, this.getSession(), new Sender(this), this.getDepartment(), (DataRequest.OwnerEx)this);
        DatabaseClientLogViewBase<DatabaseSessionClientWithFile> view = this.getView();
        view.registerHookUp(parent2, hookUp);
        return hookUp;
    }

    @Override
    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> model = this.myScriptModel.get();
        if (model != null && model.isActual()) {
            ScriptModel<?> scriptModel = model;
            if (scriptModel == null) {
                JdbcConsole.$$$reportNull$$$0(30);
            }
            return scriptModel;
        }
        ScriptModel<?> scriptModel = this.myScriptModel.updateAndGet(prevModel -> prevModel != null && prevModel.isActual() ? prevModel : this.updateScriptModel((ScriptModel<?>)prevModel));
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(31);
        }
        return scriptModel;
    }

    public void addSearchPathReceiver(@NotNull Disposable parent2, @NotNull SearchPathReceiver receiver) {
        if (parent2 == null) {
            JdbcConsole.$$$reportNull$$$0(32);
        }
        if (receiver == null) {
            JdbcConsole.$$$reportNull$$$0(33);
        }
        this.myPathDispatcher.addListener((EventListener)receiver, parent2);
    }

    public void updateConsoleOnRequestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(34);
        }
        if (this.mySearchPath.get() == null) {
            this.updateSearchPath(context.getSearchPath());
        }
    }

    public boolean getAutoClose() {
        return false;
    }

    public void updateConsoleOnRequestFinished(@NotNull DataRequest.Context context) {
        IntrospectionScopeUpdater scopeUpdater;
        ConsoleDataRequest consoleRequest;
        if (context == null) {
            JdbcConsole.$$$reportNull$$$0(35);
        }
        List introspectionTasks = (consoleRequest = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class)) != null ? (List)consoleRequest.getSharedDataHolder().getUserData(INTROSPECTION_TASKS) : null;
        boolean requestAutoSync = introspectionTasks != null && consoleRequest.isExecutionStopper() && (!((DatabaseConnectionPoint)this.getTarget()).isReadOnly() || consoleRequest.concessions.contains(ExecutionConcession.SIDE_EFFECTS_IN_RO_MODE));
        boolean inTransaction2 = context.txMarker.isTransactionInProgress();
        IntrospectionScopeUpdater introspectionScopeUpdater = scopeUpdater = consoleRequest == null ? null : (IntrospectionScopeUpdater)consoleRequest.getSharedDataHolder().getUserData(SCOPE_UPDATER);
        if (this.isValid()) {
            this.updateSearchPath(context.getSearchPath());
        }
        if (this.isTargetValid() && requestAutoSync) {
            LocalDataSource ds = ((DatabaseConnectionPoint)this.getTarget()).getDataSource();
            LoaderContext loaderContext = LoaderContext.selectTasks((Project)this.getProject(), (LocalDataSource)ds, (Collection)introspectionTasks);
            if (scopeUpdater != null) {
                loaderContext.getScopeUpdater().merge(scopeUpdater);
            }
            DataSourceUtilKt.performAutoSyncTask((LoaderContext)loaderContext, (boolean)false);
            if (inTransaction2) {
                this.myScheduleRefresh.set(true);
            }
        }
    }

    public void updateConsoleOnTxCompleted(boolean commit) {
        if (this.isTargetValid() && commit && this.myScheduleRefresh.getAndSet(false).booleanValue()) {
            DataSourceUtilKt.performAutoSyncTask((LoaderContext)this.preparePathBasedLoaderContext(), (boolean)false);
        }
    }

    @TestOnly
    public void setSearchPath(@Nullable SearchPath schemaPaths) {
        this.updateSearchPath(schemaPaths);
    }

    @NotNull
    public ScriptModel.PStorage getPStorage() {
        ScriptModel.PStorage pStorage = ShowSqlParametersPanelAction.getStorage(this);
        if (pStorage == null) {
            JdbcConsole.$$$reportNull$$$0(36);
        }
        return pStorage;
    }

    @NotNull
    private LoaderContext preparePathBasedLoaderContext() {
        LoaderContext loaderContext = DataSourceUiUtil.preparePathBasedLoaderContext(this.getProject(), (DatabaseConnectionPoint)this.getTarget(), SearchPath.getCurrent((SearchPath)this.mySearchPath.get()));
        if (loaderContext == null) {
            JdbcConsole.$$$reportNull$$$0(37);
        }
        return loaderContext;
    }

    private void updateSearchPath(@Nullable SearchPath schemaPaths) {
        if (Comparing.equal((Object)schemaPaths, (Object)this.mySearchPath.get()) || !this.isValid()) {
            return;
        }
        this.mySearchPath.set(schemaPaths);
        TransactionGuard.submitTransaction((Disposable)this, () -> {
            VirtualFile virtualFile = this.getVirtualFile();
            DatabaseEditorHelperCore.RESET_SEARCH_PATH.set((UserDataHolder)virtualFile, (Object)true);
            ChooseSchemaAction.setSelectedSearchPath(this.getProject(), virtualFile, this.mySearchPath.get());
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
            AssignColorAction.updateFileEditors(FileEditorManagerEx.getInstanceEx((Project)this.getProject()), virtualFile);
        });
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        SearchPath path = this.getSearchPath();
        return path == null ? null : path.getCurrent();
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath.get();
    }

    @NotNull
    public static List<JdbcConsole> getActiveConsoles(Project project) {
        List<JdbcConsole> list = ScriptingDatabaseSessionClientHolder.INSTANCE.getActiveClients(project);
        if (list == null) {
            JdbcConsole.$$$reportNull$$$0(38);
        }
        return list;
    }

    @Nullable
    public static JdbcConsole findConsole(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(39);
        }
        JdbcConsole console = (file = JdbcConsole.findVirtualFile(e)) == null ? null : JdbcConsoleProvider.getValidConsole(e.getProject(), file);
        JdbcConsole result2 = console != null ? console : (JdbcConsole)((Object)ObjectUtils.tryCast((Object)e.getData(SessionClientHolder.CLIENT_KEY), JdbcConsole.class));
        return result2 == null || !result2.isValid() ? null : result2;
    }

    @Nullable
    private static VirtualFile findVirtualFile(@NotNull AnActionEvent e) {
        FileEditor editor2;
        VirtualFile file;
        if (e == null) {
            JdbcConsole.$$$reportNull$$$0(40);
        }
        VirtualFile virtualFile = file = (editor2 = (FileEditor)e.getData(PlatformCoreDataKeys.FILE_EDITOR)) == null ? (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE) : editor2.getFile();
        if (file != null) {
            return file;
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        return psiFile == null ? null : psiFile.getVirtualFile();
    }

    @Override
    protected String getHelpID() {
        return "reference.runToolWindow.jdbcTab";
    }

    @Override
    protected boolean isViewValid() {
        LogView maybeView = DatabaseSessionViewService.getInstance().getClientViewIfAny((DatabaseSessionClientWithFile)this);
        return maybeView == null || maybeView.isValid();
    }

    public static void buildHeaderComponent(@NotNull Editor editor2, @Nullable JdbcConsole console) {
        JComponent header;
        if (editor2 == null) {
            JdbcConsole.$$$reportNull$$$0(41);
        }
        if (editor2 instanceof EditorEx) {
            EditorEx e = (EditorEx)editor2;
            v0 = e.getPermanentHeaderComponent();
        } else {
            v0 = header = null;
        }
        if (header == null) {
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup leftGroup = (ActionGroup)actionManager.getAction("Console.Jdbc.Left");
            ActionGroup rightGroup = (ActionGroup)actionManager.getAction("Console.Jdbc.Right");
            EditorHeaderComponent headerComponent = new EditorHeaderComponent();
            ActionToolbar leftToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", leftGroup, true);
            ActionToolbar rightToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", rightGroup, true);
            rightToolbar.setReservePlaceAutoPopupIcon(false);
            leftToolbar.setTargetComponent(editor2.getContentComponent());
            rightToolbar.setTargetComponent(editor2.getContentComponent());
            headerComponent.add((Component)leftToolbar.getComponent(), "Center");
            headerComponent.add((Component)rightToolbar.getComponent(), "East");
            if (editor2 instanceof EditorEx) {
                EditorEx e = (EditorEx)editor2;
                e.setPermanentHeaderComponent((JComponent)headerComponent);
            }
            editor2.setHeaderComponent((JComponent)headerComponent);
            ToggleToolbarAction.setToolbarVisible((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)Objects.requireNonNull(editor2.getProject())), (Iterable)JBIterable.of((Object)headerComponent), null);
            header = headerComponent;
        }
        DatabaseEditorHelper.configureEditorHeader(console == null ? editor2.getProject() : console.getProject(), console == null ? null : console.getVirtualFile(), header);
    }

    @Override
    public boolean beforeExecuteQueries(@NotNull ScriptModel<?> scriptModel) {
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(42);
        }
        if (!this.isValid()) {
            return false;
        }
        ScriptModel.PStorage storage = ShowSqlParametersPanelAction.getStorage(this);
        boolean result2 = ParametersHolder.beforeExecuteQueries(this.myVirtualFile, storage, this.getProject(), scriptModel);
        if (result2) {
            this.getView().beforeExecution();
        }
        return result2;
    }

    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> scriptModel, @NotNull DatabaseSettings.ExecOption execOption) {
        ConsoleDataRequest request;
        if (sourceEditor == null) {
            JdbcConsole.$$$reportNull$$$0(43);
        }
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(44);
        }
        if (execOption == null) {
            JdbcConsole.$$$reportNull$$$0(45);
        }
        List<IntrospectionTask> introspectionTasks = null;
        IntrospectionScopeUpdater scopeUpdater = null;
        LocalDataSource target = ((DatabaseConnectionPoint)this.getTarget()).getDataSource();
        if (target.isAutoSynchronize()) {
            List psiElements = scriptModel.statements().transform(ScriptModelUtilCore.TO_OBJECT).filter(PsiElement.class).toList();
            SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)psiElements);
            introspectionTasks = JdbcConsole.determineIntrospectionTasksAfterExecution(target.getDataSource(), scriptModel, this.getSearchPath());
            if (introspectionTasks != null && target.shouldTrackNamespaces()) {
                scopeUpdater = DbSqlUtil.getScopeUpdater((SyntaxTraverser)s, (ObjectPath)this.getCurrentNamespace(), (DasModel)target.getModel());
            }
        }
        if ((request = ConsoleDataRequest.newConsoleRequest((JdbcConsoleBase)this, (Editor)sourceEditor, scriptModel, (boolean)execOption.newTab)) == null) {
            return;
        }
        request.getSharedDataHolder().putUserData(INTROSPECTION_TASKS, introspectionTasks);
        request.getSharedDataHolder().putUserData(SCOPE_UPDATER, scopeUpdater);
        this.getMessageBus().getDataProducer().processRequest((GridDataRequest)request);
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = ((DatabaseConnectionPoint)this.getTarget()).getDataSource();
        if (localDataSource == null) {
            JdbcConsole.$$$reportNull$$$0(46);
        }
        return localDataSource;
    }

    public void switchSchema(@NotNull SearchPath to, boolean force) {
        if (to == null) {
            JdbcConsole.$$$reportNull$$$0(47);
        }
        if (force && this.getCurrentTx().isTransactionInProgress() && JdbcUrlParserUtil.outOfBounds((DatabaseConnectionPoint)this.getDataSource(), (ObjectPath)SearchPath.getCurrent((SearchPath)this.getSearchPath()), (ObjectPath)to.getCurrent())) {
            int res2 = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)DatabaseBundle.message((String)"JdbcConsole.transaction.message", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"JdbcConsole.transaction.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            if (res2 == 0) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxCommit((DataRequest.OwnerEx)this));
            } else if (res2 == 1) {
                this.getMessageBus().getDataProducer().processRequest(DataRequest.newTxRollback((DataRequest.OwnerEx)this));
            } else {
                return;
            }
        }
        this.fireSearchPathChanged(to);
        this.updateSearchPath(to);
        this.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest((DataRequest.OwnerEx)this, (SearchPath)to, (boolean)force));
    }

    private void fireSearchPathChanged(@NotNull SearchPath to) {
        FileEditorManager manager;
        if (to == null) {
            JdbcConsole.$$$reportNull$$$0(48);
        }
        if (!(manager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen(this.myVirtualFile) || !this.myVirtualFile.isValid()) {
            return;
        }
        FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{this.myVirtualFile});
        ((SearchPathReceiver)this.myPathDispatcher.getMulticaster()).receive(to);
    }

    @NotNull
    public DataRequest.TxMarker getCurrentTx() {
        DataRequest.TxMarker txMarker = this.mySession.getCurrentTx();
        if (txMarker == null) {
            JdbcConsole.$$$reportNull$$$0(49);
        }
        return txMarker;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.mySession.setAutoCommit(autoCommit);
    }

    @Nullable
    public RunnerLayoutUi getUi() {
        LogView view = DatabaseSessionViewService.getInstance().getClientViewIfAny((DatabaseSessionClientWithFile)this);
        return view == null ? null : view.getUi();
    }

    @NotNull
    public List<Content> getContents() {
        if (this.myConsumer == null) {
            List<Content> list = Collections.emptyList();
            if (list == null) {
                JdbcConsole.$$$reportNull$$$0(50);
            }
            return list;
        }
        Collection<RunnerLayoutUi> uis = this.myConsumer.getUis();
        List list = ContainerUtil.flatMap(uis, ui -> Arrays.asList(ui.getContents()));
        if (list == null) {
            JdbcConsole.$$$reportNull$$$0(51);
        }
        return list;
    }

    public void showPlan(@Nullable PlanModel plan) {
        this.getView().showPlan(plan);
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            JdbcConsole.$$$reportNull$$$0(52);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public DatabaseClientLogViewBase<DatabaseSessionClientWithFile> getView() {
        DatabaseClientLogViewBase databaseClientLogViewBase = DatabaseSessionViewService.getInstance().getClientView((DatabaseSessionClientWithFile)this, v -> {
            this.myConsumer = ScriptingClientDataConsumer.install(this.getProject(), this, ((DatabaseClientLogView)v).getResultsPlaceChooser());
            DatabaseConsoleHistoryController controller = new DatabaseConsoleHistoryController(this.getDataSource(), JdbcConsole.getLangConsoleView((DatabaseClientLogViewBase<DatabaseSessionClientWithFile>)v), (DatabaseScriptingSessionClient)this);
            controller.install();
            Disposer.register((Disposable)this, (Disposable)controller);
            Disposer.register((Disposable)this, () -> {
                this.myConsumer = null;
            });
            DataAuditor obtainer = JdbcConsole.createAdvancedErrorsObtainer(this.getProject(), this.getDataSource());
            if (obtainer instanceof Disposable) {
                Disposer.register((Disposable)this, (Disposable)((Disposable)obtainer));
            }
            this.getMessageBus().addAuditor(obtainer);
            new StateWatcher.ClientWatcher((DatabaseSessionClientWithFile)this);
            return Unit.INSTANCE;
        });
        if (databaseClientLogViewBase == null) {
            JdbcConsole.$$$reportNull$$$0(53);
        }
        return databaseClientLogViewBase;
    }

    @Nullable
    private static LanguageConsoleView getLangConsoleView(DatabaseClientLogViewBase<DatabaseSessionClientWithFile> logView) {
        if (logView instanceof DatabaseClientLogView) {
            return ((DatabaseClientLogView)logView).getConsoleView();
        }
        return null;
    }

    @Override
    public boolean isIdle() {
        return this.mySession.isIdle();
    }

    public boolean cleanup() {
        return false;
    }

    private boolean isTargetValid() {
        return DataSourceUtil.isDataSourceValid((DbPsiFacade)DbPsiFacade.getInstance((Project)this.getProject()), (DasDataSource)this.getDataSource());
    }

    @Nullable
    private static List<IntrospectionTask> determineIntrospectionTasksAfterExecution(@NotNull LocalDataSource dataSource, @NotNull ScriptModel<?> scriptModel, @Nullable SearchPath searchPath) {
        boolean needsRefresh;
        List script2;
        if (dataSource == null) {
            JdbcConsole.$$$reportNull$$$0(54);
        }
        if (scriptModel == null) {
            JdbcConsole.$$$reportNull$$$0(55);
        }
        if ((script2 = scriptModel.statements().transform(ScriptModelUtilCore.TO_OBJECT).filter(PsiElement.class).toList()).isEmpty()) {
            return null;
        }
        Dbms dbms = dataSource.getDbms();
        SqlAffectAnalyzer analyzer = (SqlAffectAnalyzer)SqlAffectAnalyzer.getEP().forDbms(dbms);
        DatabaseDialect dialect = (DatabaseDialect)DatabaseDialect.EP.forDbms(dbms);
        CombinedIntrospectionTask task = null;
        if (analyzer != null) {
            Impactees impactees = analyzer.determineAffectedObjects((DasDataSource)dataSource, script2, searchPath);
            if (impactees.hasObjects()) {
                task = IntrospectionTasks.prepareRefreshAffectedObjectsTask((String)dataSource.getUniqueId(), (Impactees)impactees);
            }
        } else if (dialect != null && (needsRefresh = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)script2)).filter(e -> dialect.triggersIntrospection(e))).traverse().isNotEmpty())) {
            task = DataSourceFun.preparePathBasedIntrospectionTask((DatabaseConnectionPoint)dataSource, (ObjectPath)SearchPath.getCurrent((SearchPath)searchPath));
        }
        return task != null ? Collections.singletonList(task) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 14, 16, 17, 18, 19, 20, 21, 22, 26, 27, 28, 30, 31, 36, 37, 38, 46, 49, 50, 51, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 5: 
            case 15: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 24: 
            case 25: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 42: 
            case 44: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsole";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleConsoleToolbarAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "updateScriptModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedResults";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressHelper";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsPlaceInView";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptModel";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPStorage";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePathBasedLoaderContext";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveConsoles";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTx";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsole";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToggleConsoleToolbarAction";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteRange";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAdvancedErrorsObtainer";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEmbeddedResults";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "detached";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showOnAttention";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "focusOnError";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createGridDataHookUp";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addSearchPathReceiver";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestStarted";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateConsoleOnRequestFinished";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findConsole";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "buildHeaderComponent";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "beforeExecuteQueries";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "executeQueries";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "switchSchema";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "fireSearchPathChanged";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "determineIntrospectionTasksAfterExecution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 14, 16, 17, 18, 19, 20, 21, 22, 26, 27, 28, 30, 31, 36, 37, 38, 46, 49, 50, 51, 52, 53 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private final Project myProject;
        private VirtualFile myVirtualFile;
        private DatabaseConnectionPoint myConnectionPoint;
        private DatabaseSession mySession;
        private DatabaseSession myOldSession;

        public Builder(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public Builder forFile(VirtualFile file) {
            this.myVirtualFile = file;
            return this;
        }

        public Builder useSession(DatabaseSession session) {
            this.mySession = session;
            return this;
        }

        public Builder insteadOf(DatabaseSession old) {
            this.myOldSession = old;
            return this;
        }

        public Builder fromDataSource(LocalDataSource info2) {
            this.myConnectionPoint = info2;
            return this;
        }

        public Builder fromDataSource(DasDataSource info2) {
            this.myConnectionPoint = DbImplUtil.getLocalDataSource((DasDataSource)info2);
            return this;
        }

        public Builder fromDataSource(DatabaseConnectionPoint info2) {
            this.myConnectionPoint = info2;
            return this;
        }

        @NotNull
        public JdbcConsole build() {
            ValueLookupManagerController.getInstance((Project)this.myProject).startListening();
            VirtualFile file = this.myVirtualFile != null || this.myConnectionPoint == null ? this.myVirtualFile : DatabaseEditorHelper.getQueryFile(this.myProject, this.myConnectionPoint.getDataSource());
            LOG.assertTrue(file != null, (Object)"Console file is not available");
            JdbcConsole existing = (JdbcConsole)((Object)JBIterable.from(JdbcConsole.getActiveConsoles(this.myProject)).find(s -> s.getVirtualFile().equals(file)));
            LOG.assertTrue(existing == null, (Object)("Console already created for " + file.getName()));
            DatabaseSession session = this.mySession == null ? DatabaseSessionManager.getSession((Project)this.myProject, (DatabaseConnectionPoint)this.myConnectionPoint, (String)SessionsUtil.getSessionTitle((VirtualFile)this.myVirtualFile)) : this.mySession;
            JdbcConsole jdbcConsole = (JdbcConsole)((Object)ScriptingDatabaseSessionClientHolder.INSTANCE.createClient(new ScriptingDatabaseSessionClientHolder.Parameters(this.myProject, file, session, this.myConnectionPoint, this.myOldSession)));
            if (jdbcConsole == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return jdbcConsole;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsole$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsole$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class FilePresentationUpdater
    implements ModificationTrackerListener<JdbcDriverManager> {
        private FilePresentationUpdater() {
        }

        public void modificationCountChanged(@NotNull JdbcDriverManager source) {
            if (source == null) {
                FilePresentationUpdater.$$$reportNull$$$0(0);
            }
            FileEditorManagerEx.getInstanceEx((Project)JdbcConsole.this.getProject()).updateFilePresentation(JdbcConsole.this.myVirtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/JdbcConsole$FilePresentationUpdater", "modificationCountChanged"));
        }
    }

    private static class Sender
    implements SearchPathSender {
        private final JdbcConsole myConsole;

        Sender(@NotNull JdbcConsole console) {
            if (console == null) {
                Sender.$$$reportNull$$$0(0);
            }
            this.myConsole = console;
        }

        public void subscribe(@NotNull SearchPathReceiver receiver) {
            if (receiver == null) {
                Sender.$$$reportNull$$$0(1);
            }
            this.myConsole.addSearchPathReceiver((Disposable)receiver, receiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcConsole$Sender";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "subscribe";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ScriptingDatabaseSessionClientHolder
    extends SessionClientHolder<JdbcConsole, Parameters> {
        public static final ScriptingDatabaseSessionClientHolder INSTANCE = new ScriptingDatabaseSessionClientHolder();
        private static final Key<List<JdbcConsole>> DATABASE_CONSOLE_LIST = Key.create((String)"DATABASE_CONSOLE_LIST");

        protected ScriptingDatabaseSessionClientHolder() {
            super(JdbcConsole.class);
        }

        @NotNull
        protected JdbcConsole createClientInner(@NotNull Parameters parameters) {
            if (parameters == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(0);
            }
            return new JdbcConsole(parameters.project, parameters.virtualFile, parameters.session, parameters.connectionPoint, parameters.old);
        }

        @NotNull
        protected List<JdbcConsole> getActiveClients(@NotNull Project project) {
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(1);
            }
            List<JdbcConsole> data = ScriptingDatabaseSessionClientHolder.getMutableConsolesList(project);
            List invalid = ContainerUtil.filter(data, c2 -> !c2.isValid());
            for (JdbcConsole console : invalid) {
                Disposer.dispose((Disposable)console);
            }
            List<JdbcConsole> list = data;
            if (list == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(2);
            }
            return list;
        }

        protected void register(@NotNull Project project, @NotNull JdbcConsole console) {
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(3);
            }
            if (console == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(4);
            }
            ScriptingDatabaseSessionClientHolder.getMutableConsolesList(project).add(console);
            Disposer.register((Disposable)console, () -> ScriptingDatabaseSessionClientHolder.getMutableConsolesList(project).remove((Object)console));
        }

        @NotNull
        private static List<JdbcConsole> getMutableConsolesList(@NotNull Project project) {
            List data;
            if (project == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(5);
            }
            if ((data = (List)project.getUserData(DATABASE_CONSOLE_LIST)) == null) {
                data = ContainerUtil.createLockFreeCopyOnWriteList();
                project.putUserData(DATABASE_CONSOLE_LIST, (Object)data);
            }
            List list = data;
            if (list == null) {
                ScriptingDatabaseSessionClientHolder.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveClients";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMutableConsolesList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createClientInner";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getActiveClients";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "register";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getMutableConsolesList";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 6 -> new IllegalStateException(string);
            };
        }

        static class Parameters
        extends SessionClientHolder.Parameters {
            final DatabaseConnectionPoint connectionPoint;
            final VirtualFile virtualFile;
            final DatabaseSession old;

            Parameters(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull DatabaseSession session, @NotNull DatabaseConnectionPoint connectionPoint, @Nullable DatabaseSession old) {
                if (project == null) {
                    Parameters.$$$reportNull$$$0(0);
                }
                if (virtualFile == null) {
                    Parameters.$$$reportNull$$$0(1);
                }
                if (session == null) {
                    Parameters.$$$reportNull$$$0(2);
                }
                if (connectionPoint == null) {
                    Parameters.$$$reportNull$$$0(3);
                }
                super(project, session);
                this.virtualFile = virtualFile;
                this.connectionPoint = connectionPoint;
                this.old = old;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "virtualFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "session";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "connectionPoint";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/JdbcConsole$ScriptingDatabaseSessionClientHolder$Parameters";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface RawErrorsObtainer
    extends DataAuditor,
    Disposable {
        public void obtainErrors(@NotNull String var1, @NotNull DatabaseConnection var2, @Nullable SearchPath var3, @NotNull Consumer<Throwable> var4);
    }
}

