/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.queryFiles;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.console.queryFiles.QueryFilesIgnoreUpdaterState;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionGroup;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="QueryFilesIgnoreUpdaterStorage", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\nJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/console/queryFiles/QueryFilesIgnoreUpdater;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/console/queryFiles/QueryFilesIgnoreUpdaterState;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "_state", "getState", "loadState", "", "state", "shouldUpdateIgnoreFile", "", "suggestUpdatingGitignoreIfNeeded", "getIgnoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "createIgnoreAction", "Lcom/intellij/openapi/vcs/changes/ignore/actions/IgnoreFileActionGroup;", "file", "updateGitignore", "action", "getPathInProject", "", "prepareContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.database.impl"})
public final class QueryFilesIgnoreUpdater
implements PersistentStateComponent<QueryFilesIgnoreUpdaterState> {
    @NotNull
    private final Project project;
    @NotNull
    private final QueryFilesIgnoreUpdaterState _state;

    public QueryFilesIgnoreUpdater(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this._state = new QueryFilesIgnoreUpdaterState(false, 1, null);
    }

    @NotNull
    public QueryFilesIgnoreUpdaterState getState() {
        return this._state;
    }

    public void loadState(@NotNull QueryFilesIgnoreUpdaterState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._state.setIgnoreFileUpdated(state.getIgnoreFileUpdated());
    }

    private final boolean shouldUpdateIgnoreFile() {
        if (PlatformUtils.isDataGrip() || this._state.getIgnoreFileUpdated()) {
            return false;
        }
        Path queriesDirectory = QueryFileSettings.Companion.getInstance(this.project).getQueriesDirectory();
        Path defaultQueriesDirectory = QueryFileSettings.Companion.getDefaultQueriesPath(this.project);
        return defaultQueriesDirectory != null && Intrinsics.areEqual((Object)queriesDirectory, (Object)defaultQueriesDirectory) && !VcsIgnoreManagerImpl.Companion.getInstanceImpl(this.project).isDirectoryVcsIgnored(((Object)queriesDirectory).toString());
    }

    public final void suggestUpdatingGitignoreIfNeeded() {
        if (!QueryFilesUtilsKt.isQueryFilesFlagEnabled()) {
            return;
        }
        this._state.setIgnoreFileUpdated(true);
        if (!this.shouldUpdateIgnoreFile()) {
            return;
        }
        Path path = QueryFileSettings.Companion.getInstance(this.project).getQueriesDirectory();
        if (path == null) {
            return;
        }
        Path path2 = path;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(path2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile vFile = virtualFile;
        IgnoreFileActionGroup ignoreFileActionGroup = this.createIgnoreAction(vFile);
        if (ignoreFileActionGroup == null) {
            return;
        }
        IgnoreFileActionGroup action = ignoreFileActionGroup;
        Object[] objectArray = new Object[]{this.getPathInProject(vFile)};
        int dialog = Messages.showYesNoDialog((Project)this.project, (String)DatabaseBundle.message((String)"query.files.add.directory.to.ignore.message", (Object[])objectArray), (String)DatabaseBundle.message((String)"query.files.add.directory.to.ignore.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (dialog == 0) {
            this.updateGitignore(action, vFile);
        }
    }

    private final IgnoreFileType getIgnoreFileType(VirtualFile directory) {
        AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)this.project, (VirtualFile)directory);
        if (abstractVcs == null) {
            return null;
        }
        AbstractVcs vcs = abstractVcs;
        return VcsIgnoreManagerImpl.Companion.getInstanceImpl(this.project).findIgnoreFileType(vcs);
    }

    private final IgnoreFileActionGroup createIgnoreAction(VirtualFile file) {
        IgnoreFileType ignoreFileType = this.getIgnoreFileType(file);
        if (ignoreFileType == null) {
            return null;
        }
        IgnoreFileType ignoreFileType2 = ignoreFileType;
        return new IgnoreFileActionGroup(ignoreFileType2);
    }

    private final void updateGitignore(IgnoreFileActionGroup action, VirtualFile directory) {
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)this.prepareContext(directory), null, (String)"", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        AnAction[] children = action.getChildren(event);
        if (!(children.length == 0)) {
            if (children.length == 1) {
                ApplicationManager.getApplication().invokeLater(() -> QueryFilesIgnoreUpdater.updateGitignore$lambda$0(children, event));
            } else {
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)action, event.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).showCenteredInCurrentWindow(this.project);
            }
        }
    }

    private final String getPathInProject(VirtualFile directory) {
        String string = this.project.getBasePath();
        if (string == null) {
            String string2 = directory.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            return string2;
        }
        String basePath = string;
        String string3 = directory.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String relativePath = StringsKt.removePrefix((String)StringsKt.removePrefix((String)string3, (CharSequence)basePath), (CharSequence)"/");
        return relativePath;
    }

    private final DataContext prepareContext(VirtualFile directory) {
        VirtualFile[] virtualFileArray = new VirtualFile[]{directory};
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)this.project).add(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)virtualFileArray).add(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY, (Object)CollectionsKt.listOf((Object)VcsUtil.getFilePath((VirtualFile)directory))).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        return dataContext;
    }

    private static final void updateGitignore$lambda$0(AnAction[] $children, AnActionEvent $event) {
        ((AnAction)ArraysKt.first((Object[])$children)).actionPerformed($event);
    }
}

