/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.console.OffsetSavingBuilder;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ParameterizedSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbeTierUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenDataFileDescriptor
extends OpenFileDescriptor {
    private static final Key<Boolean> DATA_WILL_BE_LOADED_BY_DESCRIPTOR = Key.create((String)"DATA_GRID_LOADING_ORDER_KEY");
    private final String[] myColumnNames;
    private final @NlsActions.ActionDescription String myDescription;
    private final List<Object[]> myValues;
    private final TriConsumer<DdlBuilder, List<DasColumn>, Dbms> myFilterCondition;

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, String @Nullable [] columnNames, @NlsActions.ActionDescription @Nullable String description, List<Object @Nullable []> values, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> filterCondition) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(1);
        }
        super(project, file);
        DATA_WILL_BE_LOADED_BY_DESCRIPTOR.set((UserDataHolder)file, (Object)true);
        this.myColumnNames = columnNames;
        this.myDescription = description;
        this.myValues = values;
        this.myFilterCondition = filterCondition;
    }

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, String @Nullable [] columnNames, @NlsActions.ActionDescription @Nullable String description) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(3);
        }
        this(project, file, columnNames, description, null, null);
    }

    public void setFilterAndLoadData(DatabaseTableFileEditor.LoadingManager manager, EditorTableResultPanel resultPanel) {
        DATA_WILL_BE_LOADED_BY_DESCRIPTOR.set((UserDataHolder)this.getFile(), (Object)false);
        if (this.myValues != null) {
            this.setFilterAndSortingForNavigatingToFirstRow(resultPanel);
        } else {
            this.setFilterAndSorting(resultPanel);
        }
        GridPagingModel pageModel = resultPanel.getDataHookup().getPageModel();
        if (!pageModel.pageSizeSet()) {
            pageModel.setPageSize(DbImplUtil.getPageSize((Dbms)DataGridUtil.getDbms((DataGrid)resultPanel)));
        }
        if (!DbeTierUtilCore.isFreeTier()) {
            manager.reload();
        }
    }

    private void setFilterAndSorting(EditorTableResultPanel resultPanel) {
        Document document;
        if (this.myFilterCondition != null) {
            OpenDataFileDescriptor.setFilterText(resultPanel, this.myFilterCondition);
        } else if (StringUtil.isEmptyOrSpaces((String)resultPanel.getFilterText())) {
            OpenDataFileDescriptor.setFilterText(resultPanel, resultPanel.getDataHookup().getFilterEmptyText());
        }
        GridSortingModel sortingModel = resultPanel.getDataHookup().getSortingModel();
        Document document2 = document = sortingModel == null ? null : sortingModel.getDocument();
        if (document != null && (StringUtil.isEmptyOrSpaces((String)document.getText()) || resultPanel.getDataHookup().getSortingEmptyText().equals(document.getText()))) {
            DatabaseTableFileEditor.setSortingText((DataGrid)resultPanel, DatabaseSettings.getSettings().getDefaultTableOrdering());
        }
    }

    private void setFilterAndSortingForNavigatingToFirstRow(@NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(4);
        }
        OpenDataFileDescriptor.setFilterText(resultPanel, "");
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid)resultPanel);
        DasTableKey primaryKey = DasUtil.getPrimaryKey((DasObject)table);
        LinkedHashSet orderBy = new LinkedHashSet();
        Collections.addAll(orderBy, this.myColumnNames);
        if (primaryKey != null) {
            Iterables.addAll(orderBy, (Iterable)primaryKey.getColumnsRef().names());
        }
        DatabaseTableFileEditor.setSortingText((DataGrid)resultPanel, DatabaseTableFileEditor.generateSortingText((DataGrid)resultPanel, RowSortOrder.Type.ASC, (JBIterable<String>)JBIterable.from(orderBy)));
    }

    public static boolean isDataLoadedByDescriptor(@NotNull VirtualFile file) {
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(5);
        }
        return Boolean.TRUE.equals(DATA_WILL_BE_LOADED_BY_DESCRIPTOR.get((UserDataHolder)file));
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        List editors2;
        FileEditor editor2;
        JComponent component;
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(6);
        }
        JComponent jComponent = component = (editor2 = (FileEditor)ContainerUtil.getFirstItem((List)(editors2 = FileEditorManager.getInstance((Project)project).openEditor((OpenFileDescriptor)this, requestFocus)))) != null ? editor2.getPreferredFocusedComponent() : null;
        if (component != null) {
            IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)component, true);
            return true;
        }
        return false;
    }

    @NlsActions.ActionDescription
    public String getDescription() {
        return this.myDescription;
    }

    public void navigateTo(@NotNull DataGrid resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(7);
        }
        if (this.myColumnNames != null && this.myColumnNames.length != 0) {
            if (this.myFilterCondition == null && this.myValues == null) {
                DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid)resultPanel);
                int[] indices = new int[this.myColumnNames.length];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class).indexOf(DasUtil.byName((String)this.myColumnNames[i]));
                }
                resultPanel.getSelectionModel().setColumnSelection(ModelIndexSet.forColumns((CoreGrid)resultPanel, (int[])indices), true);
            } else if (this.myValues != null) {
                this.navigateToFirstMatched(resultPanel);
            }
        }
    }

    private static void setFilterText(@NotNull EditorTableResultPanel resultPanel, @NotNull TriConsumer<DdlBuilder, List<DasColumn>, Dbms> whereCondition) {
        List<DasColumn> columns;
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(8);
        }
        if (whereCondition == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(9);
        }
        if ((columns = OpenDataFileDescriptor.getDasColumns((DataGrid)resultPanel)) == null) {
            return;
        }
        Dbms dbms = DataGridUtil.getDbms((DataGrid)resultPanel);
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((Dbms)dbms);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)dialect, (DasObject)DataGridUtilCore.getDatabaseTable((CoreGrid)resultPanel));
        whereCondition.accept((Object)builder, columns, (Object)dbms);
        OpenDataFileDescriptor.setFilterText(resultPanel, builder.getStatement());
    }

    private static void setFilterText(@NotNull EditorTableResultPanel resultPanel, @NotNull String text) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(10);
        }
        if (text == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(11);
        }
        resultPanel.setFilterText(text, -1);
        resultPanel.setIgnoreCurrentFilterText(false);
    }

    private void navigateToFirstMatched(final @NotNull DataGrid resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(12);
        }
        final QueryWithParameters existsQuery = this.buildSelectQuery(resultPanel);
        final QueryWithParameters countQuery = this.buildCountQuery(resultPanel);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)resultPanel);
        if (existsQuery == null || countQuery == null || hookup == null) {
            return;
        }
        hookup.getMessageBus().getDataProducer().processRequest((GridDataRequest)new DataRequest.RawRequest((DataRequest.OwnerEx)hookup){

            public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection) {
                int position = -1;
                SmartStatements statements = SmartStatements.poweredBy((DatabaseConnection)((DatabaseConnection)connection));
                ParameterizedSmartStatement statement2 = statements.parameterized();
                String sql = existsQuery.sql;
                boolean exists = (Boolean)statement2.execute((Object)new StatementParameters().placeholdersOffsets(existsQuery.offsets).parameters(existsQuery.data).asData(sql), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> rs.next(), (Object)false)).rightOr((Object)false);
                if (exists) {
                    position = 0;
                    ParameterizedStatementData data = new StatementParameters().parameters(countQuery.data).placeholdersOffsets(countQuery.offsets).asData(countQuery.sql);
                    Either producerEither = statement2.execute((Object)data, (ExecutionMode)StandardExecutionMode.QUERY);
                    if (producerEither.isRight()) {
                        try (ClosableResultsProducer producer = Objects.requireNonNull((ClosableResultsProducer)producerEither.getRight());){
                            while (producer.advanceSafe()) {
                                position += ((Integer)producer.processCurrent((ResultsProducer.Processor)StandardResultsProcessors.SUM)).intValue();
                            }
                        }
                    }
                }
                resultPanel.getResultView().showFirstCell(position + 1);
            }
        });
    }

    private QueryWithParameters buildSelectQuery(@NotNull DataGrid grid) {
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(13);
        }
        DasObject dasTable = DataGridUtilCore.getDatabaseTable((CoreGrid)grid);
        List<GridColumn> columns = this.getColumns(grid);
        if (dasTable == null || columns == null) {
            return null;
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)DbImplUtil.getDatabaseDialect((Dbms)dbms), (DasObject)dasTable));
        List<ColumnQueryData> data = IntStream.range(0, Math.min(this.myValues.get(0).length, columns.size())).mapToObj(idx -> new ColumnQueryData((GridColumn)columns.get(idx), this.myValues.get(0)[idx])).collect(Collectors.toList());
        DbDataSource system = DataGridUtilCore.getDatabaseSystem((CoreGrid)grid);
        List<ColumnQueryData> parameters = OpenDataFileDescriptor.createSelectAllQueryWithParameters((DdlBuilder)builder, dasTable, dbms, DbImplUtil.getDatabaseVersion((DasDataSource)system), data, 1);
        return new QueryWithParameters(builder.getStatement(), parameters, builder.getOffsets());
    }

    @NotNull
    private static List<ColumnQueryData> createSelectAllQueryWithParameters(@NotNull DdlBuilder builder, @NotNull DasObject table, @NotNull Dbms dbms, @Nullable Version version, @NotNull List<ColumnQueryData> datas, int limit) {
        if (builder == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(14);
        }
        if (table == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(15);
        }
        if (dbms == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(16);
        }
        if (datas == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(17);
        }
        ArrayList<ColumnQueryData> newData = new ArrayList<ColumnQueryData>();
        SelectTask task = DmlTaskKt.allColumns((DasObject)table).version(version).limit(limit).whereClause((WhereClause)DmlUtilKt.whereClause(datas, newData, (Dbms)dbms, (Ref)new Ref(), (Ref)new Ref(), (int)0, (DasObject)table)).build(builder);
        DmlUtilKt.dmlGenerator((Dbms)dbms).generate((DmlTask)task);
        ArrayList<ColumnQueryData> arrayList = newData;
        if (arrayList == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private QueryWithParameters buildCountQuery(@NotNull DataGrid grid) {
        DasObject dasTable;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(19);
        }
        if ((dasTable = DataGridUtilCore.getDatabaseTable((CoreGrid)grid)) == null) {
            return null;
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        DbDataSource dataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)grid);
        Version version = DbImplUtil.getDatabaseVersion((DasDataSource)dataSource);
        SelectTask task = DmlTaskKt.allColumns((DasObject)dasTable).version(version).build(DbImplUtil.createBuilderForUIExec((Dbms)dbms, (DasObject)dasTable));
        OffsetSavingBuilder builder = new OffsetSavingBuilder(((SelectGenerationResult)DmlUtilKt.dmlGenerator((Dbms)dbms).generate((DmlTask)task)).getBuilder());
        builder.space().keyword("WHERE").space();
        ArrayList<Pair<GridColumn, Object>> parameters = new ArrayList<Pair<GridColumn, Object>>();
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        for (int i2 = 0; i2 < this.myColumnNames.length; ++i2) {
            String columnName = this.myColumnNames[i2];
            Object parameterValue = this.myValues.get(0)[i2];
            GridColumn column = (GridColumn)model.getColumn(GridUtil.findColumn((DataGrid)grid, (String)columnName));
            if (column == null) {
                return null;
            }
            if (i2 > 0) {
                builder.space().keyword("OR").space();
            }
            Pair columnValuePair = Pair.create((Object)column, (Object)parameterValue);
            builder.columnRef(columnName).space().symbol("<").space().placeholder();
            parameters.add((Pair<GridColumn, Object>)columnValuePair);
            DasColumn dasColumn = DataGridUtilCore.getDatabaseColumn((CoreGrid)grid, (GridColumn)column);
            if (dasColumn != null && !dasColumn.isNotNull()) {
                builder.space().keyword("OR").space().columnRef(columnName).space().keywords(new String[]{"IS", "NULL"});
            }
            for (int j = 0; j < i2; ++j) {
                builder.space().keyword("AND").space();
                int placeholdersCount = DbImplUtil.composeWhereItemWithParameters((DdlBuilder)builder, (GridColumn)column, (parameterValue == null ? 1 : 0) != 0, null, (Dbms)dbms, (boolean)false);
                for (int k = 0; k < placeholdersCount; ++k) {
                    parameters.add((Pair<GridColumn, Object>)columnValuePair);
                }
            }
        }
        int[] offsets = builder.getOffsets();
        DdlBuilder b = DbImplUtil.createBuilderForUIExec((DatabaseDialectEx)DbImplUtil.getDatabaseDialect((Dbms)dbms), (DasObject)dataSource);
        WrapInSelectTask wrapTask = DmlTaskKt.wrapInSelect((String)builder.getStatement(), (Project)this.getProject()).countAll().version(version).build(b);
        WrapInSelectResult result2 = (WrapInSelectResult)DmlUtilKt.dmlGenerator((Dbms)dbms).generate((DmlTask)wrapTask);
        return result2 == null || result2.getOffset() == null ? null : new QueryWithParameters(result2.getStatement(), QueryWithParameters.convert(parameters), IntStream.of(offsets).map(i -> i + result2.getOffset()).toArray());
    }

    @Nullable
    private static List<DasColumn> getDasColumns(@NotNull DataGrid grid) {
        DbTableImpl dbTable;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(20);
        }
        if ((dbTable = (DbTableImpl)ObjectUtils.tryCast((Object)DataGridUtilCore.getDatabaseTable((CoreGrid)grid), DbTableImpl.class)) == null) {
            return null;
        }
        BasicTableOrView table = (BasicTableOrView)ObjectUtils.tryCast((Object)DbImplUtil.getMaybeBasicElement((DasObject)dbTable), BasicTableOrView.class);
        if (table == null) {
            return null;
        }
        return JBIterable.from((Iterable)table.getColumns()).filter(DasColumn.class).toList();
    }

    @Nullable
    private List<GridColumn> getColumns(@NotNull DataGrid grid) {
        GridModel model;
        List columns;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(21);
        }
        return (columns = ContainerUtil.mapNotNull((Object[])this.myColumnNames, arg_0 -> OpenDataFileDescriptor.lambda$getColumns$2(model = grid.getDataModel(DataAccessType.DATABASE_DATA), grid, arg_0))).size() == this.myColumnNames.length ? columns : null;
    }

    private static /* synthetic */ GridColumn lambda$getColumns$2(GridModel model, DataGrid grid, String columnName) {
        return (GridColumn)model.getColumn(GridUtil.findColumn((DataGrid)grid, (String)columnName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whereCondition";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datas";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllQueryWithParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFilterAndSortingForNavigatingToFirstRow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDataLoadedByDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateToFirstMatched";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildSelectQuery";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createSelectAllQueryWithParameters";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildCountQuery";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDasColumns";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }

    private static final class QueryWithParameters {
        public final String sql;
        public final List<ColumnQueryData> data;
        public final int[] offsets;

        private QueryWithParameters(@NotNull String sql, @NotNull List<ColumnQueryData> data, int[] offsets) {
            if (sql == null) {
                QueryWithParameters.$$$reportNull$$$0(0);
            }
            if (data == null) {
                QueryWithParameters.$$$reportNull$$$0(1);
            }
            this.sql = sql;
            this.data = Collections.unmodifiableList(data);
            this.offsets = offsets;
        }

        @NotNull
        private static List<ColumnQueryData> convert(@NotNull List<Pair<GridColumn, Object>> pairs) {
            if (pairs == null) {
                QueryWithParameters.$$$reportNull$$$0(2);
            }
            List list = ContainerUtil.map(pairs, pair -> {
                GridColumn first = (GridColumn)pair.getFirst();
                Object second = pair.getSecond();
                return new ColumnQueryData(first, second);
            });
            if (list == null) {
                QueryWithParameters.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

