/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.diff.DiffAlgo;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureNodeTreeModel
implements TreeModel {
    private final List<Object> myRoots;
    private final EventDispatcher<TreeModelListener> myDispatcher;
    private final DbEditorController myController;

    public DbStructureNodeTreeModel(@NotNull DbEditorController controller, @NotNull Disposable parentDisposable) {
        if (controller == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(1);
        }
        this.myRoots = new ArrayList<Object>();
        this.myDispatcher = EventDispatcher.create(TreeModelListener.class);
        this.myController = controller;
        this.registerStructureUpdater(parentDisposable);
        this.registerPresentationUpdater(parentDisposable);
    }

    private void registerStructureUpdater(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(2);
        }
        this.myController.getEventDispatcher().addListener((EventListener)new DbEditorListener(){
            List<?> prev = null;

            @Nullable
            private Object getChangeRoot(@NotNull DbStructureNodeEditor<?, ?> editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DbStructureNodeTreeModel.shouldHide(editor2) ? DbStructureNodeTreeModel.this.getParentNode(editor2) : editor2;
            }

            @Override
            public void beforeStructureChanged(@NotNull DbStructureNodeEditor<?, ?> editor2) {
                Object p;
                if (editor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.prev = (p = this.getChangeRoot(editor2)) == null ? null : DbStructureNodeTreeModel.this.getChildren(p);
            }

            @Override
            public void structureChanged(@NotNull DbStructureNodeEditor<?, ?> editor2) {
                Object p;
                TreePath path;
                if (editor2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((path = DbStructureNodeTreeModel.this.pathOfNode(p = this.getChangeRoot(editor2))) == null) {
                    return;
                }
                List<?> cur = DbStructureNodeTreeModel.this.getChildren(p);
                DbStructureNodeTreeModel.this.fireChildrenChanged(path, this.prev, cur);
                this.prev = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "editor";
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureNodeTreeModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChangeRoot";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeStructureChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "structureChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
    }

    private void registerPresentationUpdater(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(3);
        }
        this.myController.getModelController().getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){
            private final Set<ElementIdentity<?>> myModified = new LinkedHashSet();

            @Override
            public void modified(@NotNull DbEditorModel<?, ?> model) {
                if (model == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.modified(model.getIdentity());
            }

            private void modified(ElementIdentity<?> identity) {
                if (identity instanceof MultiElementIdentity) {
                    for (ElementIdentity sub : ((MultiElementIdentity)identity).getIdentities()) {
                        this.modified(sub);
                    }
                } else {
                    this.scheduleUpdate(identity);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void scheduleUpdate(@NotNull ElementIdentity<?> identity) {
                boolean run;
                if (identity == null) {
                    2.$$$reportNull$$$0(1);
                }
                Set<ElementIdentity<?>> set = this.myModified;
                synchronized (set) {
                    run = this.myModified.isEmpty();
                    this.myModified.add(identity);
                }
                if (run) {
                    DbUIUtil.invokeLater(this::performUpdate);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void performUpdate() {
                ArrayList modified;
                Set<ElementIdentity<?>> set = this.myModified;
                synchronized (set) {
                    modified = new ArrayList(this.myModified);
                    this.myModified.clear();
                }
                for (ElementIdentity elementIdentity : modified) {
                    TreePath path = DbStructureNodeTreeModel.this.pathOf(elementIdentity);
                    if (path == null) continue;
                    ((TreeModelListener)DbStructureNodeTreeModel.this.myDispatcher.getMulticaster()).treeNodesChanged(new TreeModelEvent((Object)DbStructureNodeTreeModel.this, path));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "identity";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureNodeTreeModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "scheduleUpdate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
    }

    @Nullable
    public DbStructureModelState.Group<? extends DbStructureNodeEditor<?, ?>> findGroup(@NotNull String name) {
        if (name == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(4);
        }
        return (DbStructureModelState.Group)JBIterable.from(this.getRoots()).filter(DbStructureModelState.Group.class).find(g -> g.name.equals(name));
    }

    public void addRoot(@NotNull Object editor2, int idx) {
        if (editor2 == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(5);
        }
        if (idx == -1) {
            idx = this.myRoots.size();
        }
        this.myRoots.add(idx, editor2);
        ((TreeModelListener)this.myDispatcher.getMulticaster()).treeNodesInserted(new TreeModelEvent((Object)this, this.getRootPath(), new int[]{idx}, new Object[]{editor2}));
    }

    public int removeRoot(@NotNull Object editor2) {
        int idx;
        if (editor2 == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(6);
        }
        if ((idx = this.myRoots.indexOf(editor2)) != -1) {
            this.myRoots.remove(idx);
            ((TreeModelListener)this.myDispatcher.getMulticaster()).treeNodesRemoved(new TreeModelEvent((Object)this, this.getRootPath(), new int[]{idx}, new Object[]{editor2}));
        }
        return idx;
    }

    public List<Object> getRoots() {
        return this.myRoots;
    }

    public void setRoots(@NotNull List<Object> roots) {
        if (roots == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(7);
        }
        if (this.myRoots.equals(roots)) {
            return;
        }
        List<?> prev2 = this.getChildren(this.getRoot());
        this.myRoots.clear();
        this.myRoots.addAll(roots);
        this.fireChildrenChanged(this.getRootPath(), prev2, this.getChildren(this.getRoot()));
    }

    @Override
    public Object getRoot() {
        return this;
    }

    public List<?> getChildren(Object o) {
        assert (!(o instanceof TreePath));
        return ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(this::getChildrenImpl).withRoot(o)).expandAndSkip(n -> n == o || DbStructureNodeTreeModel.shouldHide(n))).toList();
    }

    private static boolean shouldHide(@NotNull Object n) {
        if (n == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(8);
        }
        if (n instanceof DbStructureNodeEditor) {
            DbStructureNodeEditor sne = (DbStructureNodeEditor)n;
            return sne.getController().getBuilder().isHideFromStructure(sne.getModelRef());
        }
        return false;
    }

    private List<?> getChildrenImpl(Object o) {
        if (o == this.getRoot()) {
            return this.myRoots;
        }
        if (o instanceof DbStructureNodeEditor) {
            DbStructureNodeEditor sne = (DbStructureNodeEditor)o;
            return sne.getChildren();
        }
        if (o instanceof DbStructureModelState.Group) {
            DbStructureModelState.Group g = (DbStructureModelState.Group)o;
            return g.children;
        }
        return Collections.emptyList();
    }

    @Override
    public Object getChild(Object o, int i) {
        List<?> children = this.getChildren(o);
        return i < children.size() ? children.get(i) : null;
    }

    @Override
    public int getChildCount(Object o) {
        return this.getChildren(o).size();
    }

    @Override
    public boolean isLeaf(Object o) {
        return o != this.getRoot() && this.getChildCount(o) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexOfChild(Object o, Object o1) {
        assert (!(o1 instanceof TreePath));
        return this.getChildren(o).indexOf(o1);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @Nullable
    public Object getParentNode(@NotNull Object node) {
        if (node == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(9);
        }
        if (node == this.getRoot()) {
            return null;
        }
        for (Object root : this.myRoots) {
            if (node == root) {
                return this.getRoot();
            }
            if (!(root instanceof DbStructureModelState.Group) || !((DbStructureModelState.Group)root).children.contains(node)) continue;
            return root;
        }
        DbStructureNodeEditor se = (DbStructureNodeEditor)ObjectUtils.tryCast((Object)node, DbStructureNodeEditor.class);
        if (se == null) {
            return null;
        }
        DbStructureNodeEditor<?, ?> parent2 = DbStructureNodeTreeModel.getParentEditorImpl(se);
        return parent2 != null && DbStructureNodeTreeModel.shouldHide(parent2) ? this.getParentNode(parent2) : parent2;
    }

    @Nullable
    public DbStructureNodeEditor<?, ?> getParent(@Nullable DbStructureNodeEditor<?, ?> editor2) {
        return editor2 == null ? null : DbStructureNodeTreeModel.getParentEditor(editor2);
    }

    public boolean isUnderRoot(@NotNull DbStructureNodeEditor<?, ?> node) {
        if (node == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(10);
        }
        return this.myRoots.contains(node);
    }

    @Nullable
    public static DbStructureNodeEditor<?, ?> getParentEditor(@Nullable DbStructureNodeEditor<?, ?> se) {
        if (se == null) {
            return null;
        }
        DbEditorController controller = se.getController();
        return DbStructureNodeTreeModel.getEditor(controller, DbStructureModelState.getParentModel(controller.getModelController(), se.getModelRef()));
    }

    @Nullable
    public static DbStructureNodeEditor<?, ?> getParentEditorImpl(@Nullable DbStructureNodeEditor<?, ?> se) {
        if (se == null) {
            return null;
        }
        DbEditorController controller = se.getController();
        return DbStructureNodeTreeModel.getEditor(controller, DbStructureFamilyModelState.getParentStructureNode(controller.getModelController(), se.getModelRef()));
    }

    public boolean isInTree(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        if (!this.isInParent(path)) {
            return false;
        }
        return path.getParentPath() == null || this.isInTree(path.getParentPath());
    }

    public boolean isInParent(@NotNull TreePath path) {
        TreePath parent2;
        if (path == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(11);
        }
        if ((parent2 = path.getParentPath()) == null) {
            return path.getLastPathComponent() == this.getRoot();
        }
        return this.getIndexOfChild(parent2.getLastPathComponent(), path.getLastPathComponent()) != -1;
    }

    @Nullable
    public TreePath pathOf(@Nullable ElementIdentity<?> id) {
        return this.pathOf(DbStructureNodeTreeModel.getEditor(this.myController, id));
    }

    @Nullable
    public <E extends BasicElement, S extends DbStructureNodeState<?, ?>> TreePath pathOf(@Nullable DbModelRef<E, S> mm) {
        return this.pathOf(DbStructureNodeTreeModel.getEditor(this.myController, mm));
    }

    @Nullable
    public TreePath pathOf(@Nullable DbStructureNodeEditor<?, ?> se) {
        return this.pathOfNode(se);
    }

    @Nullable
    public TreePath pathOfNode(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o == this.getRoot()) {
            return this.getRootPath();
        }
        TreePath parentPath = this.pathOfNode(this.getParentNode(o));
        return parentPath == null ? null : DbStructureNodeTreeModel.createPath(parentPath, o);
    }

    @NotNull
    public TreePath getRootPath() {
        return new TreePath(this);
    }

    @NotNull
    public static TreePath createPath(@Nullable TreePath parent2, @NotNull Object lastPathComponent) {
        if (lastPathComponent == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(12);
        }
        return new OpenPath(parent2, lastPathComponent);
    }

    @Nullable
    public static DbStructureNodeEditor<?, ?> getEditor(@NotNull DbEditorController controller, @Nullable ElementIdentity<?> identity) {
        if (controller == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(13);
        }
        return DbStructureNodeTreeModel.getEditor(controller, DbStructureNodeTreeModel.getNodeModel(controller, identity));
    }

    @Nullable
    public static <E extends BasicElement> DbModelRef<E, DbStructureObjectModelState<E>> getNodeModel(@NotNull DbEditorController controller, @Nullable ElementIdentity<E> identity) {
        if (controller == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(14);
        }
        return identity == null ? null : DbModelRef.create(controller.getModelController().getStructureNodeModel(identity));
    }

    @Nullable
    public static <E extends BasicElement, S extends DbStructureNodeState<?, ?>> DbStructureNodeEditor<E, S> getEditor(@NotNull DbEditorController controller, @Nullable DbModelRef<E, S> model) {
        if (controller == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(15);
        }
        return model == null ? null : controller.getStructureNodeEditor(model);
    }

    @Nullable
    public static DbStructureNodeEditor<?, ?> getEditor(@Nullable TreePath path) {
        return path == null ? null : (DbStructureNodeEditor)ObjectUtils.tryCast((Object)path.getLastPathComponent(), DbStructureNodeEditor.class);
    }

    @Nullable
    public static DbStructureNodeEditor<?, ?> getEditorFromEventChild(@NotNull Object child) {
        if (child == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(16);
        }
        return (DbStructureNodeEditor)ObjectUtils.tryCast((Object)child, DbStructureNodeEditor.class);
    }

    private void fireChildrenChanged(TreePath path, @NotNull List<?> prev2, @NotNull List<?> cur) {
        TreeModelEvent insertion;
        if (prev2 == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(17);
        }
        if (cur == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(18);
        }
        DiffIterable diff = DiffAlgo.diff(prev2, cur, (o1, o2) -> o1 == o2 ? 0 : 1);
        IntArrayList removed = new IntArrayList();
        IntArrayList inserted = new IntArrayList();
        for (Range change : diff.iterateChanges()) {
            int i;
            for (i = change.start1; i < change.end1; ++i) {
                removed.add(i);
            }
            for (i = change.start2; i < change.end2; ++i) {
                inserted.add(i);
            }
        }
        TreeModelEvent removal = this.createTreeEvent(path, prev2, (IntList)removed);
        if (removal != null) {
            ((TreeModelListener)this.myDispatcher.getMulticaster()).treeNodesRemoved(removal);
        }
        if ((insertion = this.createTreeEvent(path, cur, (IntList)inserted)) != null) {
            ((TreeModelListener)this.myDispatcher.getMulticaster()).treeNodesInserted(insertion);
        }
    }

    @Nullable
    private TreeModelEvent createTreeEvent(@NotNull TreePath path, @NotNull List<?> children, IntList indicesList) {
        if (path == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(19);
        }
        if (children == null) {
            DbStructureNodeTreeModel.$$$reportNull$$$0(20);
        }
        if (indicesList.isEmpty()) {
            return null;
        }
        int[] indices = indicesList.toIntArray();
        Object[] objects = new Object[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            objects[i] = children.get(indices[i]);
        }
        return new TreeModelEvent((Object)this, path, indices, objects);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastPathComponent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cur";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbStructureNodeTreeModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerStructureUpdater";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerPresentationUpdater";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHide";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnderRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isInParent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createPath";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorFromEventChild";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "fireChildrenChanged";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createTreeEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OpenPath
    extends TreePath {
        OpenPath(TreePath parent2, @NotNull Object lastPathComponent) {
            if (lastPathComponent == null) {
                OpenPath.$$$reportNull$$$0(0);
            }
            super(parent2, lastPathComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastPathComponent", "com/intellij/database/schemaEditor/ui/DbStructureNodeTreeModel$OpenPath", "<init>"));
        }
    }
}

