/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DatabaseIntrospectionSession;
import com.intellij.database.introspection.DatabaseModelLoader;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.statistic.DbFusIntrospectionCollector;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.util.containers.JBTreeTraverser;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/statistic/DbFusIntrospectionLogger;", "Lcom/intellij/database/introspection/DatabaseModelLoader$Listener;", "<init>", "()V", "started", "", "session", "Lcom/intellij/database/introspection/DatabaseIntrospectionSession;", "finished", "result", "Lcom/intellij/database/introspection/DatabaseModelLoader$FinishedState;", "ObjectCounts", "intellij.database.impl"})
public final class DbFusIntrospectionLogger
implements DatabaseModelLoader.Listener {
    public void started(@NotNull DatabaseIntrospectionSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        DbFusIntrospectionCollector.INSTANCE.logStarted(session);
    }

    public void finished(@NotNull DatabaseIntrospectionSession session, @NotNull DatabaseModelLoader.FinishedState result2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        DbFusIntrospectionCollector.INSTANCE.logFinished$intellij_database_impl(session, result2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/statistic/DbFusIntrospectionLogger$ObjectCounts;", "", "schemas", "", "visibleSchemas", "total", "<init>", "(III)V", "getSchemas", "()I", "getVisibleSchemas", "getTotal", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.database.impl"})
    public static final class ObjectCounts {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int schemas;
        private final int visibleSchemas;
        private final int total;

        public ObjectCounts(int schemas, int visibleSchemas, int total) {
            this.schemas = schemas;
            this.visibleSchemas = visibleSchemas;
            this.total = total;
        }

        public final int getSchemas() {
            return this.schemas;
        }

        public final int getVisibleSchemas() {
            return this.visibleSchemas;
        }

        public final int getTotal() {
            return this.total;
        }

        public final int component1() {
            return this.schemas;
        }

        public final int component2() {
            return this.visibleSchemas;
        }

        public final int component3() {
            return this.total;
        }

        @NotNull
        public final ObjectCounts copy(int schemas, int visibleSchemas, int total) {
            return new ObjectCounts(schemas, visibleSchemas, total);
        }

        public static /* synthetic */ ObjectCounts copy$default(ObjectCounts objectCounts, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = objectCounts.schemas;
            }
            if ((n4 & 2) != 0) {
                n2 = objectCounts.visibleSchemas;
            }
            if ((n4 & 4) != 0) {
                n3 = objectCounts.total;
            }
            return objectCounts.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ObjectCounts(schemas=" + this.schemas + ", visibleSchemas=" + this.visibleSchemas + ", total=" + this.total + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.schemas);
            result2 = result2 * 31 + Integer.hashCode(this.visibleSchemas);
            result2 = result2 * 31 + Integer.hashCode(this.total);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectCounts)) {
                return false;
            }
            ObjectCounts objectCounts = (ObjectCounts)other;
            if (this.schemas != objectCounts.schemas) {
                return false;
            }
            if (this.visibleSchemas != objectCounts.visibleSchemas) {
                return false;
            }
            return this.total == objectCounts.total;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/statistic/DbFusIntrospectionLogger$ObjectCounts$Companion;", "", "<init>", "()V", "countObjects", "Lcom/intellij/database/statistic/DbFusIntrospectionLogger$ObjectCounts;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "model", "Lcom/intellij/database/model/DasModel;", "intellij.database.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ObjectCounts countObjects(@NotNull LocalDataSource ds, @NotNull DasModel model) {
                Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                int schemas = 0;
                int visibleSchemas = 0;
                for (BasicSchema schema : ((JBTreeTraverser)model.traverser().expand(arg_0 -> Companion.countObjects$lambda$1(Companion::countObjects$lambda$0, arg_0))).filter(BasicSchema.class)) {
                    ++schemas;
                    if (!ds.getSchemaMapping().isIntrospected((BasicElement)schema)) continue;
                    ++visibleSchemas;
                }
                JBTreeTraverser jBTreeTraverser = DbImplUtil.traverseVisibleObjects((JBTreeTraverser)model.traverser(), (TreePattern)ds.getIntrospectionScope());
                Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"traverseVisibleObjects(...)");
                int total = CollectionsKt.count((Iterable)((Iterable)jBTreeTraverser));
                return new ObjectCounts(schemas, visibleSchemas, total);
            }

            public static /* synthetic */ ObjectCounts countObjects$default(Companion companion, LocalDataSource localDataSource, DasModel dasModel, int n, Object object) {
                if ((n & 2) != 0) {
                    DasModel dasModel2 = localDataSource.getModel();
                    Intrinsics.checkNotNullExpressionValue((Object)dasModel2, (String)"getModel(...)");
                    dasModel = dasModel2;
                }
                return companion.countObjects(localDataSource, dasModel);
            }

            private static final boolean countObjects$lambda$0(DasObject it) {
                return it instanceof BasicNamespaceOwner;
            }

            private static final boolean countObjects$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

