/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.transport;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.transport.CompatibleStagingTargetModelImpl;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModel;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModelData;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModelFields;
import com.intellij.javaee.oss.transport.RemoteServerModelDelegateBase;
import com.intellij.javaee.oss.transport.RemoteStagingTargetDefinition;
import com.intellij.javaee.oss.transport.StagingTargetModel;
import com.intellij.javaee.oss.transport.StagingTargetModelImpl;
import com.intellij.javaee.oss.transport.TransportTargetKind;
import com.intellij.javaee.oss.transport.TransportTargetModelBase;
import com.intellij.javaee.oss.transport.WatchedTargetModelImpl;
import com.intellij.javaee.transport.TransportTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiTargetRemoteServerModelDelegate
extends RemoteServerModelDelegateBase<MultiTargetRemoteServerModelData, MultiTargetRemoteServerModel>
implements MultiTargetRemoteServerModelFields {
    private static final Logger LOG = Logger.getInstance(MultiTargetRemoteServerModelDelegate.class);
    private Map<String, TransportTargetModelBase> myTargets = new HashMap<String, TransportTargetModelBase>();
    private Map<String, RemoteStagingTargetDefinition> myTargetDefs;

    public MultiTargetRemoteServerModelDelegate init(MultiTargetRemoteServerModel parent, List<RemoteStagingTargetDefinition> targetDefs) {
        this.myTargetDefs = new HashMap<String, RemoteStagingTargetDefinition>();
        for (RemoteStagingTargetDefinition targetDef : targetDefs) {
            this.myTargetDefs.put(targetDef.getName(), targetDef);
        }
        return (MultiTargetRemoteServerModelDelegate)super.init(parent);
    }

    private TransportTargetKind getTargetKind(String targetName) {
        RemoteStagingTargetDefinition targetDef = this.myTargetDefs.get(targetName);
        return targetDef == null ? null : targetDef.getKind();
    }

    @Override
    public TransportTargetModelBase getTarget(String targetName) {
        TransportTargetModelBase result = this.myTargets.get(targetName);
        if (result == null) {
            result = this.getTargetKind(targetName).createModel();
            result.setName(targetName);
            this.myTargets.put(targetName, result);
        }
        return result;
    }

    @Override
    public void readFromData(MultiTargetRemoteServerModelData data) {
        super.readFromData(data);
        this.myTargets.clear();
        for (TransportTargetModelBase target : data.getTargets()) {
            if (target instanceof CompatibleStagingTargetModelImpl) {
                if (this.getTargetKind(target.getName()) != TransportTargetKind.STAGING) continue;
                StagingTargetModelImpl convertedTarget = new StagingTargetModelImpl();
                convertedTarget.setTransportStagingTarget(target.getTransportStagingTarget());
                convertedTarget.setName(target.getName());
                convertedTarget.setStagingRemotePath(((CompatibleStagingTargetModelImpl)target).getStagingRemotePath());
                this.myTargets.put(target.getName(), convertedTarget);
                continue;
            }
            this.myTargets.put(target.getName(), target);
        }
    }

    @Override
    public void writeToData(MultiTargetRemoteServerModelData data) {
        super.writeToData(data);
        data.setTargets(new ArrayList<TransportTargetModelBase>(this.myTargets.values()));
    }

    public boolean transferFile(String targetName, File webAppFile) {
        return new WatchedTargetOperation(){

            @Override
            protected boolean doOnLocalHost(File webAppFile, File targetFile) {
                try {
                    FileUtil.copy((File)webAppFile, (File)targetFile);
                    return true;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                    return false;
                }
            }

            @Override
            protected void doOnRemoteHost(TransportTarget transportTarget, VirtualFile webAppFile) throws RuntimeConfigurationException {
                MultiTargetRemoteServerModelDelegate.this.transferFileToTarget(transportTarget, webAppFile);
            }
        }.perform(targetName, webAppFile);
    }

    public boolean deleteFile(String targetName, File webAppFile) {
        return new WatchedTargetOperation(){

            @Override
            protected boolean doOnLocalHost(File webAppFile, File targetFile) {
                return FileUtil.delete((File)targetFile);
            }

            @Override
            protected void doOnRemoteHost(TransportTarget transportTarget, VirtualFile webAppFile) throws RuntimeConfigurationException {
                MultiTargetRemoteServerModelDelegate.this.deleteFileFromTarget(transportTarget, webAppFile);
            }
        }.perform(targetName, webAppFile);
    }

    public String prepareDeployment(String targetName, String sourcePath, boolean prepareNameOnly) throws RuntimeConfigurationException {
        StagingTargetModel target = (StagingTargetModel)((Object)this.getTarget(targetName));
        return this.prepareDeployment(target.getTransportStagingTarget(), target.getStagingRemotePath(), sourcePath, prepareNameOnly);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiTargetRemoteServerModelDelegate result = (MultiTargetRemoteServerModelDelegate)super.clone();
        result.myTargets = new HashMap<String, TransportTargetModelBase>();
        for (TransportTargetModelBase target : this.myTargets.values()) {
            result.myTargets.put(target.getName(), (TransportTargetModelBase)target.clone());
        }
        return result;
    }

    public void checkConfiguration(Collection<String> targetNames) throws RuntimeConfigurationException {
        if (this.getCommonModel().getDeploymentModels().isEmpty()) {
            return;
        }
        this.doCheckConfiguration(targetNames);
    }

    private void doCheckConfiguration(Collection<String> targetNames) throws RuntimeConfigurationException {
        this.checkBaseConfiguration();
        for (String targetName : targetNames) {
            this.getTargetKind(targetName).checkConfiguration(this.getTransportHostId(), this.getTarget(targetName), this.myTargetDefs.get(targetName).getCaption());
        }
    }

    public boolean isDeployAllowed() {
        try {
            this.doCheckConfiguration(this.myTargetDefs.keySet());
            return true;
        }
        catch (RuntimeConfigurationException e) {
            return false;
        }
    }

    private abstract class WatchedTargetOperation {
        private WatchedTargetOperation() {
        }

        public boolean perform(String targetName, File webAppFile) {
            WatchedTargetModelImpl watchedTarget = (WatchedTargetModelImpl)MultiTargetRemoteServerModelDelegate.this.getTarget(targetName);
            if (MultiTargetRemoteServerModelDelegate.this.isHostLocal()) {
                return this.doOnLocalHost(webAppFile, new File(watchedTarget.getWatchedLocalPath(), webAppFile.getName()));
            }
            try {
                this.doOnRemoteHost(watchedTarget.getTransportStagingTarget(), LocalFileSystem.getInstance().refreshAndFindFileByIoFile(webAppFile));
                return true;
            }
            catch (RuntimeConfigurationException e) {
                LOG.debug((Throwable)e);
                return false;
            }
        }

        protected abstract boolean doOnLocalHost(File var1, File var2);

        protected abstract void doOnRemoteHost(TransportTarget var1, VirtualFile var2) throws RuntimeConfigurationException;
    }
}

