/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.core;

import com.intellij.database.remote.jdba.util.NameAndClass;
import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class RowLayout<R>
implements Serializable {
    @NotNull
    public final Kind kind;
    @NotNull
    public final Class<R> rowClass;
    @NotNull
    public final Class commonComponentClass;
    @NotNull
    public final NameAndClass[] components;
    public final boolean expandMaps;
    private final boolean portable;

    RowLayout(@NotNull Kind kind, @NotNull Class<R> rowClass, boolean expandMaps, @NotNull Class commonComponentClass, @NotNull NameAndClass[] components) {
        if (kind == null) {
            RowLayout.$$$reportNull$$$0(0);
        }
        if (rowClass == null) {
            RowLayout.$$$reportNull$$$0(1);
        }
        if (commonComponentClass == null) {
            RowLayout.$$$reportNull$$$0(2);
        }
        if (components == null) {
            RowLayout.$$$reportNull$$$0(3);
        }
        this.kind = kind;
        this.rowClass = rowClass;
        this.commonComponentClass = commonComponentClass;
        this.components = components;
        this.expandMaps = expandMaps && (kind == Kind.STRUCT || kind == Kind.TUPLE);
        switch (kind.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.portable = true;
                break;
            }
            case 4: 
            case 5: {
                String className = rowClass.getName();
                this.portable = className.startsWith("java.") || className.startsWith("javax.");
                break;
            }
            default: {
                this.portable = false;
            }
        }
    }

    RowLayout(@NotNull Kind kind, @NotNull Class<R> rowClass, boolean expandMaps, @NotNull Class commonComponentClass, Class ... componentClasses) {
        if (kind == null) {
            RowLayout.$$$reportNull$$$0(4);
        }
        if (rowClass == null) {
            RowLayout.$$$reportNull$$$0(5);
        }
        if (commonComponentClass == null) {
            RowLayout.$$$reportNull$$$0(6);
        }
        if (componentClasses == null) {
            RowLayout.$$$reportNull$$$0(7);
        }
        this(kind, rowClass, expandMaps, commonComponentClass, RowLayout.unnamedComponentsOf(componentClasses));
    }

    @NotNull
    private static NameAndClass[] unnamedComponentsOf(@NotNull Class[] componentClasses) {
        if (componentClasses == null) {
            RowLayout.$$$reportNull$$$0(8);
        }
        int n = componentClasses.length;
        NameAndClass[] components = new NameAndClass[n];
        for (int i = 0; i < n; ++i) {
            components[i] = new NameAndClass('#' + Integer.toString(i + 1), componentClasses[i]);
        }
        if (components == null) {
            RowLayout.$$$reportNull$$$0(9);
        }
        return components;
    }

    public boolean isPortable() {
        return this.portable;
    }

    public RowLayout<Object[]> makeIntermediateLayout() {
        return new RowLayout<Object[]>(Kind.TUPLE, Object[].class, this.expandMaps, this.commonComponentClass, this.components);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowLayout rowLayout = (RowLayout)o;
        if (this.kind != rowLayout.kind) {
            return false;
        }
        if (!this.rowClass.equals(rowLayout.rowClass)) {
            return false;
        }
        if (!this.commonComponentClass.equals(rowLayout.commonComponentClass)) {
            return false;
        }
        return Arrays.equals(this.components, rowLayout.components);
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + this.rowClass.hashCode();
        result = 31 * result + this.commonComponentClass.hashCode();
        result = 31 * result + Arrays.hashCode(this.components);
        return result;
    }

    public String toString() {
        switch (this.kind.ordinal()) {
            case 0: {
                return "existence";
            }
            case 1: {
                return this.commonComponentClass.getSimpleName();
            }
            case 2: {
                return this.commonComponentClass.getSimpleName() + "[]";
            }
            case 3: {
                return "TUPLE" + this.representComponents();
            }
            case 4: {
                return this.rowClass + this.representComponents();
            }
            case 5: {
                return this.rowClass + "(positions)";
            }
        }
        return "???";
    }

    @NotNull
    private String representComponents() {
        int n = this.components.length;
        if (n == 0) {
            return "(no components)";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            b.append(i == 0 ? " (" : ", ");
            NameAndClass component = this.components[i];
            b.append(component.name).append(':').append(component.clazz.getSimpleName());
        }
        b.append(')');
        String string = b.toString();
        if (string == null) {
            RowLayout.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowClass";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonComponentClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClasses";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/core/RowLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/core/RowLayout";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "unnamedComponentsOf";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "representComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unnamedComponentsOf";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Kind {
        EXISTENCE,
        ONE_VALUE,
        ARRAY,
        TUPLE,
        STRUCT,
        CLASS_BY_POSITIONS;

    }
}

