/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.sql.SqlStatement;
import com.intellij.database.remote.jdba.sql.TextFragment;
import com.intellij.database.remote.jdba.util.StringOperator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQuery<S>
extends SqlStatement {
    @NotNull
    private final ResultLayout<S> myLayout;
    private transient String myDisplayName;
    private static final Pattern TABLE_SECTION_PATTERN = Pattern.compile("FROM\\s+(.*)(\\s+(WHERE|GROUP|ORDER)|$)", 34);
    private static final Pattern SHOW_CREATE_PATTERN = Pattern.compile("^\\s*(SHOW\\s+CREATE\\s+(\\w+))", 34);
    private static final Pattern MULTI_SPACE = Pattern.compile("\\s{2,}", 32);

    public SqlQuery(@NotNull TextFragment sourceFragment, @NotNull ResultLayout<S> layout) {
        if (sourceFragment == null) {
            SqlQuery.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            SqlQuery.$$$reportNull$$$0(1);
        }
        super(sourceFragment);
        this.myLayout = layout;
    }

    public SqlQuery(@NotNull String sourceText, @NotNull ResultLayout<S> layout) {
        if (sourceText == null) {
            SqlQuery.$$$reportNull$$$0(2);
        }
        if (layout == null) {
            SqlQuery.$$$reportNull$$$0(3);
        }
        super(sourceText);
        this.myLayout = layout;
    }

    public SqlQuery(int row, @NotNull String sourceText, @Nullable String name, @NotNull String description, @NotNull ResultLayout<S> layout, String displayName) {
        if (sourceText == null) {
            SqlQuery.$$$reportNull$$$0(4);
        }
        if (description == null) {
            SqlQuery.$$$reportNull$$$0(5);
        }
        if (layout == null) {
            SqlQuery.$$$reportNull$$$0(6);
        }
        super(row, sourceText, name, description);
        this.myLayout = layout;
        this.myDisplayName = displayName;
    }

    protected void setDisplayName(String displayName) {
        this.myDisplayName = displayName;
    }

    @NotNull
    public String getDisplayName() {
        String displayName = this.myDisplayName;
        if (displayName == null) {
            displayName = this.ensureDisplayName();
        }
        String string = displayName;
        if (string == null) {
            SqlQuery.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private synchronized String ensureDisplayName() {
        String displayName = this.myDisplayName;
        if (displayName == null) {
            displayName = SqlQuery.prepareDisplayName(this.mySourceText);
            this.myDisplayName = displayName = SqlQuery.adjustDisplayName(displayName);
        }
        String string = displayName;
        if (string == null) {
            SqlQuery.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String prepareDisplayName(String text) {
        String theComment;
        int nl = text.indexOf(10);
        String str1 = nl > 0 ? text.substring(0, nl) : text;
        if ((str1 = str1.trim()).startsWith("--") && !(theComment = str1.substring(2).trim()).isEmpty() && !theComment.startsWith("+")) {
            String string = theComment;
            if (string == null) {
                SqlQuery.$$$reportNull$$$0(9);
            }
            return string;
        }
        String tableStuff = SqlQuery.peekDisplayNameAsTables(text);
        if (tableStuff != null) {
            String string = tableStuff;
            if (string == null) {
                SqlQuery.$$$reportNull$$$0(10);
            }
            return string;
        }
        String showCreateStuff = SqlQuery.peekDisplayNameAsShowCreate(text);
        if (showCreateStuff != null) {
            String string = showCreateStuff;
            if (string == null) {
                SqlQuery.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (str1.length() > 60) {
            str1 = str1.substring(0, 60) + "...";
        }
        String string = str1;
        if (string == null) {
            SqlQuery.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static String peekDisplayNameAsTables(CharSequence text) {
        Matcher m = TABLE_SECTION_PATTERN.matcher(text);
        if (m.find()) {
            String stuff = m.group(1);
            if (stuff.length() > 60) {
                stuff = stuff.substring(0, 50) + "...";
            }
            return "select from " + stuff;
        }
        return null;
    }

    @Nullable
    private static String peekDisplayNameAsShowCreate(CharSequence text) {
        Matcher m = SHOW_CREATE_PATTERN.matcher(text);
        if (m.find()) {
            String stuff = m.group(1);
            if (stuff.length() > 60) {
                stuff = stuff.substring(0, 50) + "...";
            }
            return stuff.toLowerCase(Locale.ROOT);
        }
        return null;
    }

    @NotNull
    private static String adjustDisplayName(@NotNull String displayName) {
        if (displayName == null) {
            SqlQuery.$$$reportNull$$$0(13);
        }
        String s = displayName.trim();
        String string = s = MULTI_SPACE.matcher(s).replaceAll(" ");
        if (string == null) {
            SqlQuery.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlQuery<S> rewrite(@NotNull StringOperator operator) {
        if (operator == null) {
            SqlQuery.$$$reportNull$$$0(15);
        }
        String transformedSourceText = (String)operator.apply(this.mySourceText);
        return new SqlQuery<S>(this.myRow, transformedSourceText, this.myName, this.myDescription, this.myLayout, this.myDescription);
    }

    @NotNull
    public ResultLayout<S> getLayout() {
        ResultLayout<S> resultLayout = this.myLayout;
        if (resultLayout == null) {
            SqlQuery.$$$reportNull$$$0(16);
        }
        return resultLayout;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFragment";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/sql/SqlQuery";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/sql/SqlQuery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureDisplayName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDisplayName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjustDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rewrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

