/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.frontend.split.VcsFrontendSplitBundle;
import com.intellij.platform.vcs.frontend.split.diff.FrontendDiffRequest;
import com.intellij.platform.vcs.frontend.split.diff.FrontendOneSideDiffViewer;
import com.intellij.platform.vcs.frontend.split.diff.FrontendTwoSideDiffViewer;
import com.jetbrains.rd.ide.model.diffViewer.DiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.ErrorDiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.OneSideDiffViewerModel;
import com.jetbrains.rd.ide.model.diffViewer.TwoSideDiffViewerModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/FrontendDiffTool;", "Lcom/intellij/diff/FrameDiffTool;", "<init>", "()V", "getName", "", "canShow", "", "context", "Lcom/intellij/diff/DiffContext;", "request", "Lcom/intellij/diff/requests/DiffRequest;", "createComponent", "Lcom/intellij/diff/FrameDiffTool$DiffViewer;", "createErrorComponent", "message", "Lorg/jetbrains/annotations/Nls;", "Companion", "intellij.platform.vcs.frontend.split"})
@SourceDebugExtension(value={"SMAP\nFrontendDiffViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDiffViewer.kt\ncom/intellij/platform/vcs/frontend/split/diff/FrontendDiffTool\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,626:1\n13#2:627\n*S KotlinDebug\n*F\n+ 1 FrontendDiffViewer.kt\ncom/intellij/platform/vcs/frontend/split/diff/FrontendDiffTool\n*L\n232#1:627\n*E\n"})
final class FrontendDiffTool
implements FrameDiffTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public String getName() {
        return VcsFrontendSplitBundle.INSTANCE.message("frontend.diff.tool.name", new Object[0]);
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request instanceof FrontendDiffRequest;
    }

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FrontendDiffRequest cfr_ignored_0 = (FrontendDiffRequest)request;
        DiffViewerModel model = ((FrontendDiffRequest)request).getViewerModel();
        Project project = context.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        if (RLifetimeKt.isNotAlive((Lifetime)((FrontendDiffRequest)request).getLifetime())) {
            LOG.warn("Model lifetime terminated " + model);
            String string = DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.createErrorComponent(context, string);
        }
        DiffViewerModel diffViewerModel = model;
        if (diffViewerModel instanceof ErrorDiffViewerModel) {
            return this.createErrorComponent(context, ((ErrorDiffViewerModel)model).getMessage());
        }
        if (diffViewerModel instanceof OneSideDiffViewerModel) {
            return new FrontendOneSideDiffViewer(((FrontendDiffRequest)request).getLifetime(), context, (OneSideDiffViewerModel)model);
        }
        if (diffViewerModel instanceof TwoSideDiffViewerModel) {
            return new FrontendTwoSideDiffViewer(project2, ((FrontendDiffRequest)request).getLifetime(), context, (TwoSideDiffViewerModel)model);
        }
        LOG.error("Model is not supported by frontend " + model);
        String string = DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return this.createErrorComponent(context, string);
    }

    private final FrameDiffTool.DiffViewer createErrorComponent(DiffContext context, String message) {
        FrameDiffTool.DiffViewer diffViewer = ErrorDiffTool.INSTANCE.createComponent(context, (DiffRequest)new ErrorDiffRequest(message));
        Intrinsics.checkNotNullExpressionValue((Object)diffViewer, (String)"createComponent(...)");
        return diffViewer;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendDiffTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/FrontendDiffTool$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

