/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils.persistence.data.nodes;

import com.intellij.javaee.utils.persistence.data.nodes.PropertyNode;
import com.intellij.javaee.utils.persistence.data.nodes.PropertyParametersType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SelectPropertyNode
extends PropertyNode {
    private static final Pattern IGNORE_CASE = Pattern.compile("Ignor(ing|e)Case");
    private String myPropertyName;
    private PropertyParametersType myType;

    public SelectPropertyNode(@NotNull String expression) {
        if (expression == null) {
            SelectPropertyNode.$$$reportNull$$$0(0);
        }
        super(expression);
        this.myType = PropertyParametersType.SIMPLE_PROPERTY;
        String expressionCaseProcessed = SelectPropertyNode.detectAndSetIgnoreCase(expression);
        this.myPropertyName = StringUtil.decapitalize((String)expressionCaseProcessed);
        Processor processor = type -> {
            for (String keyword : type.getKeywords()) {
                if (!expressionCaseProcessed.endsWith(keyword)) continue;
                this.myType = type;
                this.myPropertyName = StringUtil.decapitalize((String)expressionCaseProcessed.substring(0, expressionCaseProcessed.indexOf(keyword)));
                return false;
            }
            return true;
        };
        for (PropertyParametersType type2 : PropertyParametersType.ALL) {
            if (!processor.process((Object)type2)) break;
        }
    }

    @Override
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @Override
    public boolean isDefaultKeyword() {
        return this.myType == PropertyParametersType.SIMPLE_PROPERTY;
    }

    public PropertyParametersType getType() {
        return this.myType;
    }

    @Override
    public Set<String> getPropertyKeywords() {
        HashSet<String> strings = new HashSet<String>();
        for (PropertyParametersType type : PropertyParametersType.ALL) {
            Collections.addAll(strings, type.getKeywords());
        }
        return strings;
    }

    @Override
    @NotNull
    public String getKeyword() {
        String string = this.getExpression().substring(this.myPropertyName.length());
        if (string == null) {
            SelectPropertyNode.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String detectAndSetIgnoreCase(@NotNull String expression) {
        if (expression == null) {
            SelectPropertyNode.$$$reportNull$$$0(2);
        }
        Matcher matcher = IGNORE_CASE.matcher(expression);
        Object result = expression;
        if (matcher.find()) {
            result = expression.substring(0, matcher.start()) + expression.substring(matcher.end());
        }
        String string = result;
        if (string == null) {
            SelectPropertyNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/persistence/data/nodes/SelectPropertyNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/persistence/data/nodes/SelectPropertyNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAndSetIgnoreCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectAndSetIgnoreCase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

