/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptModuleImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptParameterListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSCoreLibraryElementsCollector;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.BasicTypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class TypeScriptPsiUtil {
    public static final Pattern TYPESCRIPT_REFERENCE_PATH = Pattern.compile("^///\\s*<\\s*reference\\s*(path|lib|types)\\s*=\\s*(['\"])([^'\"]+)\\2[^/]*\\s*/>.*$");
    private static final String THIS_NAME = "this";

    private TypeScriptPsiUtil() {
    }

    @Nullable
    public static JSType getTypeFromDeclaration(StubBasedPsiElementBase element) {
        TypeScriptType resultType = TypeScriptPsiUtil.getStubOrPsiTypeElement(element);
        return resultType == null ? null : resultType.getJSType();
    }

    @Nullable
    public static JSTypeDeclaration unparenthesizeType(@Nullable JSTypeDeclaration type) {
        while (type instanceof TypeScriptParenthesizedType) {
            type = ((TypeScriptParenthesizedType)type).getInnerType();
        }
        return type;
    }

    @Nullable
    public static PsiElement getParentSkipTypeParentheses(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(0);
        }
        return PsiTreeUtil.skipParentsOfType((PsiElement)type, (Class[])new Class[]{TypeScriptParenthesizedType.class});
    }

    @Nullable
    public static JSClass getParentClass(@Nullable PsiElement element) {
        PsiElement secondParent;
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSClass) {
            return (JSClass)parent;
        }
        if (parent instanceof TypeScriptObjectType && (secondParent = parent.getParent()) instanceof JSClass) {
            return (JSClass)secondParent;
        }
        return null;
    }

    public static boolean hasImplicitExportForDeclarations(@Nullable PsiElement moduleOrFile) {
        if (moduleOrFile instanceof TypeScriptModule) {
            return ((TypeScriptModule)moduleOrFile).hasImplicitExportForDeclarations();
        }
        if (moduleOrFile instanceof JSFile) {
            if (!((JSFile)moduleOrFile).isCommonJSModule()) {
                return false;
            }
            if (TypeScriptUtil.isDefinitionFile((JSFile)moduleOrFile)) {
                return !TypeScriptPsiUtil.hasExportStatements(moduleOrFile);
            }
        }
        return false;
    }

    public static boolean hasExportStatements(@NotNull PsiElement moduleOrFile) {
        ES6ImportHandler.ES6ExportCache cache;
        if (moduleOrFile == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(1);
        }
        return (cache = ES6ImportHandler.getExportedCacheForModule(moduleOrFile)) != null && cache.hasExportStatements();
    }

    public static boolean isAmbientContext(@Nullable PsiElement element) {
        JSAttributeListOwner owner = (JSAttributeListOwner)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSAttributeListOwner.class});
        return TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)owner);
    }

    public static boolean isAmbientDeclaration(@Nullable PsiElement element) {
        if (element instanceof JSAttributeListOwner) {
            if (TypeScriptUtil.isDefinitionFile(element.getContainingFile())) {
                return true;
            }
            while (element != null && !(element instanceof JSFile)) {
                if (TypeScriptPsiUtil.hasAmbientAttribute((JSAttributeListOwner)element)) {
                    return true;
                }
                element = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{JSClass.class, TypeScriptModule.class, JSFile.class});
            }
        }
        return false;
    }

    public static boolean hasAmbientAttribute(@NotNull JSAttributeListOwner element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(2);
        }
        if (element instanceof JSProperty || element instanceof JSRecordType.CallSignature || element instanceof JSRecordType.IndexSignature) {
            return false;
        }
        if (element instanceof TypeScriptModule && ((TypeScriptModule)element).isGlobalScopeAugmentation()) {
            return true;
        }
        JSAttributeList list = element.getAttributeList();
        return list != null && list.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean isNamedTypeDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding || element instanceof ES6ImportExportSpecifierAlias || element instanceof TypeScriptImportStatement || element instanceof TypeScriptEnumField;
    }

    public static boolean isNamedTypeContainerDefinition(PsiElement element) {
        return element instanceof JSClass || element instanceof TypeScriptGenericOrMappedTypeParameter || TypeScriptPsiUtil.isNamespaceDefinition(element);
    }

    public static boolean isNamespaceDefinition(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule || element instanceof TypeScriptImportStatement || element instanceof ES6ImportExportSpecifierAlias || element instanceof ES6ExportDefaultAssignment || element instanceof JSFile || element instanceof ES6ImportExportDeclarationPart || element instanceof TypeScriptGlobalModuleExportDeclaration;
    }

    @Nullable
    public static TypeScriptExportAssignment findExportAssignment(@NotNull PsiElement module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.isTypeScript(module)) {
            return null;
        }
        TypeScriptExportAssignment exportAssignment = null;
        if (module instanceof PsiFileImpl) {
            exportAssignment = (TypeScriptExportAssignment)((PsiFileImpl)module).withGreenStubOrAst(stub -> {
                StubElement exportAssignmentStub = stub.findChildStubByElementType(TypeScriptElementTypes.EXPORT_ASSIGNMENT);
                return exportAssignmentStub != null ? (TypeScriptExportAssignment)exportAssignmentStub.getPsi() : null;
            }, ast -> (TypeScriptExportAssignment)((PsiFileImpl)module).findChildByClass(TypeScriptExportAssignment.class));
        } else if (module instanceof TypeScriptModuleImpl) {
            exportAssignment = ((TypeScriptModuleImpl)module).getStubOrPsiChild(TypeScriptElementTypes.EXPORT_ASSIGNMENT);
        }
        return exportAssignment;
    }

    public static boolean isClassMember(JSParameter parameter) {
        return TypeScriptPsiUtil.isFieldParameter(parameter);
    }

    @Nullable
    public static String getNameFromIdentifierOwner(@NotNull JSNamedElement identifierOwner) {
        String nameFromComputed;
        if (identifierOwner == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(4);
        }
        if (identifierOwner instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)((Object)identifierOwner)).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        return TypeScriptPsiUtil.getNameFromIdentifier(identifierOwner.findNameIdentifier());
    }

    @Nullable
    public static String getNameFromIdentifier(@Nullable ASTNode identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            identifier = identifier.getFirstChildNode();
        }
        if (identifier == null) {
            return null;
        }
        if (JSTokenTypes.STRING_LITERALS.contains(identifier.getElementType())) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(identifier.getText());
        }
        return JSStringUtil.replaceUnicodeEscapeSequences(identifier.getText());
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(5);
        }
        return (TypeScriptType)JSStubBasedPsiTreeUtil.getStubOrPsiChild(element, TypeScriptElementTypes.TYPESCRIPT_TYPES);
    }

    public static TypeScriptType @NotNull [] getStubOrPsiTypeElements(@NotNull StubBasedPsiElementBase<?> element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(6);
        }
        TypeScriptType[] typeScriptTypeArray = (TypeScriptType[])element.getStubOrPsiChildren(TypeScriptElementTypes.TYPESCRIPT_TYPES, TypeScriptType.ARRAY_FACTORY);
        if (typeScriptTypeArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(7);
        }
        return typeScriptTypeArray;
    }

    @Nullable
    public static TypeScriptType getStubOrPsiTypeElement(@NotNull StubBasedPsiElementBase element, int index) {
        TypeScriptType[] elements;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(8);
        }
        return (elements = TypeScriptPsiUtil.getStubOrPsiTypeElements(element)).length > index ? elements[index] : null;
    }

    @Nullable
    public static TypeScriptType getPsiTypeElement(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(9);
        }
        return element instanceof StubBasedPsiElementBase ? TypeScriptPsiUtil.getStubOrPsiTypeElement((StubBasedPsiElementBase)element) : (TypeScriptType)PsiTreeUtil.getChildOfType((PsiElement)element, TypeScriptType.class);
    }

    public static boolean isTopLevelContainer(@Nullable PsiElement element) {
        return element instanceof JSFile || element instanceof TypeScriptModule || element instanceof JSEmbeddedContent && !(element.getContainingFile() instanceof JSFile);
    }

    public static boolean isTopLevelContainerMember(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(10);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentOverDefaultAssignable(element);
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof ES6ExportDefaultAssignment) {
            parent = parent.getParent();
        }
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    public static boolean isTopLevelContainerMember(@NotNull StubBase<?> stubElement) {
        StubElement parentStub;
        if (stubElement == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(11);
        }
        if ((parentStub = stubElement.getParentStub()) != null && parentStub.getElementType() == JSElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            parentStub = parentStub.getParentStub();
        }
        if (parentStub != null && BasicTypeScriptElementTypes.VAR_STATEMENTS.contains(parentStub.getElementType())) {
            parentStub = parentStub.getParentStub();
        }
        IElementType type = parentStub != null ? parentStub.getElementType() : null;
        return type == JSElementTypes.TYPESCRIPT_MODULE || type == null || type instanceof IFileElementType;
    }

    public static boolean isExportedFromGlobalModule(@NotNull ES6ImportExportSpecifier element) {
        JSElement scope;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(12);
        }
        if (!((scope = ES6PsiUtil.getExportScope((PsiElement)element)) instanceof TypeScriptModule)) {
            return false;
        }
        TypeScriptModule module = (TypeScriptModule)scope;
        if (!module.isGlobalScopeAugmentation()) {
            return false;
        }
        return ES6PsiUtil.getModuleStatus(module) == JSModuleStatusOwner.ModuleStatus.ES6;
    }

    public static PsiElement getParentOverDefaultAssignable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(13);
        }
        if ((parent = element.getContext()) instanceof ES6ExportDefaultAssignment) {
            parent = parent.getContext();
        }
        return parent;
    }

    public static boolean isAmbientModule(@NotNull TypeScriptModule module) {
        if (module == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(14);
        }
        return module.isGlobalScopeAugmentation() || !module.isInternal();
    }

    public static boolean isAugmentationModule(@Nullable PsiElement element) {
        return element instanceof TypeScriptModule && ((TypeScriptModule)element).isAugmentation();
    }

    public static boolean isFromAugmentationModule(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(15);
        }
        return TypeScriptPsiUtil.isAugmentationModule(ES6PsiUtil.findExternalModule(element));
    }

    public static boolean isAbstractElement(@NotNull JSAttributeListOwner element) {
        JSAttributeList list;
        if (element == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(16);
        }
        if ((list = element.getAttributeList()) == null) {
            return false;
        }
        return list.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public static boolean referencesNamedTypeContainer(@NotNull ES6ImportExportSpecifier specifier) {
        ResolveResult[] results;
        if (specifier == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(17);
        }
        if ((results = specifier.resolveOverAliases()).length == 0) {
            return true;
        }
        for (ResolveResult result : results) {
            PsiElement element = result.getElement();
            if (!TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFieldParameter(@NotNull JSParameter parameter) {
        JSAttributeList list;
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(18);
        }
        return (list = parameter.getAttributeList()) != null && (list.getExplicitAccessType() != null || list.hasModifier(JSAttributeList.ModifierType.READONLY) || list.hasModifier(JSAttributeList.ModifierType.OVERRIDE));
    }

    public static boolean isThisParameter(@NotNull JSParameterItem parameter) {
        if (parameter == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(19);
        }
        return !(parameter instanceof JSDestructuringParameter) && THIS_NAME.equals(parameter.getName());
    }

    @Nullable
    public static JSParameter getThisParameter(@NotNull JSFunction function) {
        JSParameterList list;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(20);
        }
        if (!((list = function.getParameterList()) instanceof TypeScriptParameterListImpl)) {
            return null;
        }
        JSParameter[] parameters = ((TypeScriptParameterListImpl)list).getRawParameters();
        if (parameters.length == 0) {
            return null;
        }
        JSParameter parameter = parameters[0];
        return TypeScriptPsiUtil.isThisParameter(parameter) ? parameter : null;
    }

    @Nullable
    public static JSType getThisParameterType(@NotNull JSFunction function) {
        JSParameter thisParameter;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(21);
        }
        return (thisParameter = TypeScriptPsiUtil.getThisParameter(function)) == null ? null : thisParameter.getJSType(function);
    }

    @NotNull
    public static TypeScriptFunction getLastOverload(@NotNull TypeScriptFunction function) {
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(22);
        }
        TypeScriptFunction prev = null;
        if (!function.isOverloadDeclaration()) {
            TypeScriptFunction typeScriptFunction = function;
            if (typeScriptFunction == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(23);
            }
            return typeScriptFunction;
        }
        for (TypeScriptFunction currentFunction = function; currentFunction != null; currentFunction = currentFunction.getNextOverloadOrImplementation()) {
            prev = currentFunction;
        }
        TypeScriptFunction typeScriptFunction = prev;
        if (typeScriptFunction == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(24);
        }
        return typeScriptFunction;
    }

    @NotNull
    public static Collection<? extends JSFunctionItem> getAllOverloadSignatures(@NotNull JSFunctionItem functionItem) {
        TypeScriptFunction implementation;
        if (functionItem == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(25);
        }
        if (!(functionItem instanceof TypeScriptFunction)) {
            List list = Collections.emptyList();
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(26);
            }
            return list;
        }
        TypeScriptFunction tsFunction = (TypeScriptFunction)functionItem;
        LinkedHashSet<JSFunctionItem> result = new LinkedHashSet<JSFunctionItem>();
        boolean isOverloadImpl = tsFunction.isOverloadImplementation();
        if (!isOverloadImpl) {
            result.add(functionItem);
        }
        result.addAll(TypeScriptPsiUtil.getAllOverloadsWithImplementation(tsFunction));
        TypeScriptFunction typeScriptFunction = implementation = isOverloadImpl ? tsFunction : TypeScriptPsiUtil.getOverloadImplementation(tsFunction);
        if (implementation != null) {
            result.remove(implementation);
        }
        LinkedHashSet<JSFunctionItem> linkedHashSet = result;
        if (linkedHashSet == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(27);
        }
        return linkedHashSet;
    }

    @Nullable
    public static TypeScriptFunction getOverloadImplementation(@NotNull TypeScriptFunction function) {
        TypeScriptFunction overload;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(28);
        }
        return (overload = TypeScriptPsiUtil.getLastOverload(function)) != function && overload.isOverloadImplementation() ? overload : null;
    }

    @NotNull
    public static Collection<TypeScriptFunction> getAllOverloadsWithImplementation(@NotNull TypeScriptFunction function) {
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(29);
        }
        return TypeScriptPsiUtil.getAllOverloadsWithImplementation(function, true);
    }

    @NotNull
    public static Collection<TypeScriptFunction> getAllOverloadsWithImplementation(@NotNull TypeScriptFunction function, boolean removeCurrent) {
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(30);
        }
        JSClass containingClass = JSUtils.getMemberContainingClass(function);
        String name = function.getName();
        if (name != null && containingClass instanceof TypeScriptInterfaceClass) {
            JSFunction.FunctionKind kind = "constructor".equals(name) ? JSFunction.FunctionKind.CONSTRUCTOR : JSFunction.FunctionKind.SIMPLE;
            TypeScriptFunction[] functions = ((TypeScriptInterfaceClass)containingClass).findFunctionsByNameAndKind(name, kind);
            boolean isStatic = JSPsiImplUtils.hasModifier(function, JSAttributeList.ModifierType.STATIC);
            Set<TypeScriptFunction> result = Arrays.stream(functions).filter(f -> JSPsiImplUtils.hasModifier(f, JSAttributeList.ModifierType.STATIC) == isStatic).collect(Collectors.toSet());
            if (removeCurrent) {
                result.remove(function);
            }
            Set<TypeScriptFunction> set = result;
            if (set == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(31);
            }
            return set;
        }
        TypeScriptFunction overload = TypeScriptPsiUtil.getLastOverload(function);
        LinkedHashSet result = overload == function ? new LinkedHashSet() : ContainerUtil.newLinkedHashSet((Object[])new TypeScriptFunction[]{overload});
        result.addAll(overload.getOverloadDeclarations());
        if (removeCurrent) {
            result.remove(function);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(32);
        }
        return linkedHashSet;
    }

    @NotNull
    public static <T, Q extends Collection<T>> Q removeDuplicates(@NotNull Q results, @NotNull Function<? super T, ? extends PsiElement> getResolveResult, @Nullable PsiElement place) {
        if (results == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(33);
        }
        if (getResolveResult == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(34);
        }
        if (results.size() > 20) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(35);
            }
            return q;
        }
        if (place == null || results.size() <= 1) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(36);
            }
            return q;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(place);
        if (holder == null || holder.isECMA4) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(37);
            }
            return q;
        }
        if (results.stream().map(getResolveResult).anyMatch(current -> !JSCoreLibraryElementsCollector.canBeMerged(current))) {
            Q q = results;
            if (q == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(38);
            }
            return q;
        }
        JSCoreLibraryElementsCollector<T> collector = new JSCoreLibraryElementsCollector<T>(place);
        ArrayList<T> newResult = new ArrayList<T>();
        for (T result : results) {
            PsiElement element = getResolveResult.apply(result);
            if (collector.isLibraryElement(element)) {
                collector.addElement(element, result);
                continue;
            }
            newResult.add(result);
        }
        Collection values = collector.getValues();
        for (T currentResult : results) {
            if (!values.contains(currentResult)) continue;
            newResult.add(currentResult);
        }
        ArrayList<T> arrayList = newResult;
        if (arrayList == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(39);
        }
        return (Q)arrayList;
    }

    public static boolean elementsPossiblyContainDuplicates(@NotNull List<? extends ResolveResult> resolveResults) {
        if (resolveResults == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(40);
        }
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) {
                return false;
            }
            PsiElement element = resolveResult.getElement();
            if (JSCoreLibraryElementsCollector.canBeMerged(element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isImplementationAndOverloadFunction(PsiElement _element, PsiElement resolvedElement) {
        if (_element instanceof TypeScriptFunction) {
            TypeScriptFunction resolvedFunction;
            TypeScriptFunction function = (TypeScriptFunction)_element;
            if (resolvedElement instanceof TypeScriptFunction && (resolvedFunction = (TypeScriptFunction)resolvedElement).isOverloadDeclaration() && function.isOverloadImplementation() && function.getOverloadDeclarations().contains(resolvedFunction)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getMemberName(@NotNull JSComputedPropertyNameOwner function) {
        String name;
        if (function == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(41);
        }
        if ((name = function.getName()) == null) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets(function);
        }
        String string = name == null ? "" : JSStringUtil.unquoteAndUnescapeString(name);
        if (string == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    public static boolean isTopLevelThreeSlashComment(@NotNull PsiComment comment) {
        if (comment == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(43);
        }
        if (comment.getParent() instanceof JSFile && DialectDetector.isTypeScript((PsiElement)comment)) {
            ASTNode node = comment.getNode();
            return node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && StringUtil.startsWith((CharSequence)node.getChars(), (CharSequence)"///");
        }
        return false;
    }

    public static boolean isLiteralModuleAugmentationName(@Nullable PsiElement element) {
        PsiElement parent;
        return element instanceof JSLiteralExpression && (parent = element.getParent()) instanceof TypeScriptModule && element.isEquivalentTo(((TypeScriptModule)parent).getNameIdentifier());
    }

    public static TypeScriptTypeParameter @NotNull [] getTypeParametersForOwner(@Nullable PsiElement sourceElement) {
        if (!(sourceElement instanceof TypeScriptTypeParameterListOwner)) {
            if (TypeScriptTypeParameter.EMPTY_ARRAY == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(44);
            }
            return TypeScriptTypeParameter.EMPTY_ARRAY;
        }
        TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameterList();
        TypeScriptTypeParameter[] typeScriptTypeParameterArray = list == null ? TypeScriptTypeParameter.EMPTY_ARRAY : list.getTypeParameters();
        if (typeScriptTypeParameterArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(45);
        }
        return typeScriptTypeParameterArray;
    }

    public static JSTypeDeclaration @NotNull [] getNestedTypeArguments(@Nullable Object element) {
        JSTypeDeclaration[] jSTypeDeclarationArray = element instanceof JSTypeArgumentsOwner ? ((JSTypeArgumentsOwner)element).getTypeArguments() : JSTypeDeclaration.EMPTY_ARRAY;
        if (jSTypeDeclarationArray == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(46);
        }
        return jSTypeDeclarationArray;
    }

    public static boolean isTsIndexerType(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parameterType = element.getParent();
        if (!(parameterType instanceof TypeScriptType)) {
            return false;
        }
        PsiElement parent = parameterType.getParent();
        if (parent instanceof TypeScriptUnionOrIntersectionType) {
            parameterType = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSParameter) {
            parent = parent.getParent();
        }
        return parent instanceof TypeScriptIndexSignature && ((TypeScriptIndexSignature)parent).getParameterType() == parameterType;
    }

    public static boolean isObjectBuiltInTypeProperty(JSRecordType.TypeMember member) {
        JSRecordType.MemberSource source = member.getMemberSource();
        if (source.isEmpty()) {
            if (member instanceof JSCompositeFunctionPropertySignatureImpl) {
                for (JSRecordType.TypeMember typeMember : ((JSCompositeFunctionPropertySignatureImpl)member).getMembers()) {
                    if (TypeScriptPsiUtil.isObjectBuiltInTypeProperty(typeMember)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        JSClass parent = JSUtils.getMemberContainingClass(source.getSingleElement());
        return parent instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)parent).getQualifiedName());
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static TypeScriptType getParentTypeViaUnionsAndIntersections(@Nullable TypeScriptType type, boolean includeIntersections) {
        if (type == null) {
            return null;
        }
        PsiElement parent = TypeScriptPsiUtil.getParentSkipTypeParentheses(type);
        if (parent instanceof TypeScriptUnionOrIntersectionType && (includeIntersections || ((TypeScriptUnionOrIntersectionType)parent).isUnionType())) {
            return TypeScriptPsiUtil.getParentTypeViaUnionsAndIntersections((TypeScriptType)parent, includeIntersections);
        }
        return type;
    }

    public static boolean returnTypeAnnotationForbidden(@NotNull JSElement node) {
        if (node == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(47);
        }
        JSFunction function = node instanceof JSFunction ? (JSFunction)node : null;
        return function != null && (function.getKind() == JSFunction.FunctionKind.SETTER || function.isConstructor());
    }

    @Nullable
    public static PsiElement getPsiElementByRange(@NotNull PsiFile psiFile, TextRange range) {
        int rangeStartOffset;
        PsiElement startElement;
        if (psiFile == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(48);
        }
        if ((startElement = psiFile.findElementAt(rangeStartOffset = range.getStartOffset())) == null) {
            return null;
        }
        PsiElement lastCandidate = startElement;
        int rangeEndOffset = range.getEndOffset();
        for (PsiElement currentElement = startElement; currentElement != null && !(currentElement instanceof PsiFile) && currentElement.getTextRange().getStartOffset() == rangeStartOffset && currentElement.getTextRange().getEndOffset() <= rangeEndOffset; currentElement = currentElement.getParent()) {
            if (currentElement.getTextRange().getEndOffset() == rangeEndOffset) {
                return currentElement;
            }
            lastCandidate = currentElement;
        }
        return lastCandidate;
    }

    public static @Unmodifiable @NotNull List<ResolveResultSink.JSResolveResultForSymbolProcessor> removeCompileTimeTypes(@NotNull List<ResolveResultSink.JSResolveResultForSymbolProcessor> results) {
        if (results == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(49);
        }
        if (results.isEmpty()) {
            List<ResolveResultSink.JSResolveResultForSymbolProcessor> list = results;
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(50);
            }
            return list;
        }
        LinkedHashSet<ResolveResult> compileTypeElements = null;
        for (ResolveResultSink.JSResolveResultForSymbolProcessor resultForSymbolProcessor : results) {
            ResolveResult result = resultForSymbolProcessor.getResolveResult();
            if (!result.isValidResult() || !(result instanceof JSResolveResult)) continue;
            PsiElement element = result.getElement();
            if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
            }
            if (!(element instanceof TypeScriptCompileTimeType)) continue;
            if (compileTypeElements == null) {
                compileTypeElements = new LinkedHashSet<ResolveResult>();
            }
            compileTypeElements.add(result);
        }
        if (compileTypeElements == null || compileTypeElements.isEmpty()) {
            List<ResolveResultSink.JSResolveResultForSymbolProcessor> list = results;
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(51);
            }
            return list;
        }
        if (compileTypeElements.size() != results.size()) {
            LinkedHashSet<ResolveResult> finalCompileTypeElements = compileTypeElements;
            List list = ContainerUtil.filter(results, el -> !finalCompileTypeElements.contains(el.getResolveResult()));
            if (list == null) {
                TypeScriptPsiUtil.$$$reportNull$$$0(52);
            }
            return list;
        }
        List list = ContainerUtil.map((Collection)compileTypeElements, el -> new ResolveResultSink.JSResolveResultForSymbolProcessor(new JSResolveResult(el.getElement(), ((JSResolveResult)el).getES6Import(), JSResolveResult.ProblemKind.ELEMENT_IS_NOT_ACCESSIBLE)));
        if (list == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(53);
        }
        return list;
    }

    public static boolean isPlaceRuntimeOnly(@Nullable PsiElement place, boolean checkTypeContext) {
        return place instanceof JSReferenceExpression && (!checkTypeContext || !JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)place)) && !(place instanceof TypeScriptEntityName) && !(place.getParent() instanceof JSExportAssignment);
    }

    public static boolean isTypeSignature(@Nullable JSFunction function) {
        return function instanceof JSTypeDeclaration || function instanceof TypeScriptTypeMember;
    }

    @Nullable
    public static String getPathText(@NotNull Matcher matcher) {
        if (matcher == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(54);
        }
        return matcher.group(3);
    }

    public static boolean isTypeofImport(@NotNull TypeScriptSingleType type) {
        String qualifiedTypeName;
        if (type == null) {
            TypeScriptPsiUtil.$$$reportNull$$$0(55);
        }
        return (qualifiedTypeName = type.getQualifiedTypeName()) != null && qualifiedTypeName.startsWith("typeof import(");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 23, 24, 26, 27, 31, 32, 35, 36, 37, 38, 39, 42, 44, 45, 46, 50, 51, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFile";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierOwner";
                break;
            }
            case 7: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 33: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getResolveResult";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptPsiUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiTypeElements";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastOverload";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverloadSignatures";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverloadsWithImplementation";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParametersForOwner";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypeArguments";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCompileTimeTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkipTypeParentheses";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasExportStatements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasAmbientAttribute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExportAssignment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIdentifierOwner";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiTypeElements";
                break;
            }
            case 7: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelContainerMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExportedFromGlobalModule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentOverDefaultAssignable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAmbientModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isFromAugmentationModule";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAbstractElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "referencesNamedTypeContainer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isFieldParameter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isThisParameter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getThisParameter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getThisParameterType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLastOverload";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadSignatures";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadImplementation";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverloadsWithImplementation";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "elementsPossiblyContainDuplicates";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getMemberName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelThreeSlashComment";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "returnTypeAnnotationForbidden";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementByRange";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeCompileTimeTypes";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPathText";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isTypeofImport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 23, 24, 26, 27, 31, 32, 35, 36, 37, 38, 39, 42, 44, 45, 46, 50, 51, 52, 53 -> new IllegalStateException(string);
        };
    }
}

