/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.directives.FtlAssignDirective;
import com.intellij.openapi.util.Key;
import com.intellij.psi.ResolveState;
import java.util.Arrays;
import java.util.EnumSet;

public enum FtlAssignmentType {
    LOCAL,
    ASSIGN,
    GLOBAL;

    public static final Key<EnumSet<FtlAssignmentType>> TYPE_KEY;

    public static boolean isAssignmentAllowed(ResolveState state, FtlAssignDirective directive) {
        return FtlAssignmentType.isAssignmentAllowed(state, directive.getType());
    }

    public static boolean isAssignmentAllowed(ResolveState state, FtlAssignmentType type) {
        EnumSet set = (EnumSet)state.get(TYPE_KEY);
        if (set == null) {
            return true;
        }
        return set.contains((Object)type);
    }

    public static ResolveState allowAssignments(ResolveState state, FtlAssignmentType ... types) {
        return state.put(TYPE_KEY, EnumSet.copyOf(Arrays.asList(types)));
    }

    static {
        TYPE_KEY = Key.create((String)"FtlAssignmentType");
    }
}

