/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml.core;

import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiType;
import com.intellij.spring.integration.converters.ChannelDatatypeConverter;
import com.intellij.spring.integration.model.xml.core.Dispatcher;
import com.intellij.spring.integration.model.xml.core.InterceptorsOwner;
import com.intellij.spring.integration.model.xml.core.PriorityQueue;
import com.intellij.spring.integration.model.xml.core.Queue;
import com.intellij.spring.integration.model.xml.core.SpringIntegrationDomElement;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.RequiredBeanType;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Presentation(typeName="Spring Integration Channel", icon="com.intellij.spring.integration.SpringIntegrationCoreIcons.Diagram.Channel")
@BeanType(provider=ChannelBeanTypeProvider.class)
public interface Channel
extends DomSpringBean,
SpringIntegrationDomElement,
InterceptorsOwner {
    @NotNull
    public Queue getQueue();

    @NotNull
    public PriorityQueue getPriorityQueue();

    @NotNull
    public GenericDomValue<String> getRendezvousQueue();

    @NotNull
    public Dispatcher getDispatcher();

    @NotNull
    public GenericAttributeValue<String> getScope();

    @Convert(value=ChannelDatatypeConverter.class)
    @NotNull
    public GenericAttributeValue<List<PsiType>> getDatatype();

    @Attribute(value="dispatcher")
    @NotNull
    public GenericAttributeValue<String> getDispatcherAttr();

    @NotNull
    public GenericAttributeValue<Boolean> getFixedSubscriber();

    @RequiredBeanType(value={"org.springframework.messaging.converter.MessageConverter"})
    @Convert(value=SpringBeanResolveConverter.class)
    @NotNull
    public GenericAttributeValue<SpringBeanPointer<?>> getMessageConverter();

    public static class ChannelBeanTypeProvider
    implements BeanTypeProvider<Channel> {
        public String @NotNull [] getBeanTypeCandidates() {
            String[] stringArray = new String[]{"org.springframework.integration.MessageChannel", "org.springframework.messaging.MessageChannel"};
            if (stringArray == null) {
                ChannelBeanTypeProvider.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        public String getBeanType(Channel channel) {
            if (DomUtil.hasXml((DomElement)channel.getQueue())) {
                return "org.springframework.integration.channel.QueueChannel";
            }
            if (DomUtil.hasXml((DomElement)channel.getPriorityQueue())) {
                return "org.springframework.integration.channel.PriorityChannel";
            }
            if (DomUtil.hasXml(channel.getRendezvousQueue())) {
                return "org.springframework.integration.channel.RendezvousChannel";
            }
            if (DomUtil.hasXml(channel.getDispatcher().getTaskExecutor())) {
                return "org.springframework.integration.channel.ExecutorChannel";
            }
            return "org.springframework.integration.channel.DirectChannel";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/xml/core/Channel$ChannelBeanTypeProvider", "getBeanTypeCandidates"));
        }
    }
}

