/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.blocking;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringLibraryUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/data/blocking/SpringTransactionalBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "intellij.spring.data"})
public final class SpringTransactionalBlockingMethodChecker
implements BlockingMethodChecker {
    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!SpringLibraryUtil.hasSpringLibrary((Project)file.getProject())) {
            return false;
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)file.getProject());
        return javaPsi.findClass("org.springframework.transaction.annotation.Transactional", file.getResolveScope()) != null;
    }

    public boolean isMethodBlocking(@NotNull MethodContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiMethod method = context.getElement();
        if (method.hasModifier(JvmModifier.STATIC) || method.hasModifier(JvmModifier.PRIVATE) || method.hasModifier(JvmModifier.PROTECTED) || method.hasModifier(JvmModifier.PACKAGE_LOCAL)) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (String)"org.springframework.transaction.annotation.Transactional", (int)0)) {
            return !context.isMethodNonBlocking();
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)"org.springframework.transaction.annotation.Transactional", (int)0)) {
            return !context.isMethodNonBlocking();
        }
        return false;
    }
}

