/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.jam.cache.model;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QsCacheElement
implements JamElement {
    public static final SemKey<QsCacheElement> CACHE_ROOT_JAM_KEY = JamService.JAM_ELEMENT_KEY.subKey("QsCacheElement", new SemKey[0]);
    public static final SemKey<JamAnnotationMeta> CACHE_ROOT_META_KEY = SemKey.createKey((String)"QsCacheElement", (SemKey[])new SemKey[0]);
    private static final Map<String, JamAnnotationMeta> annotationMetaMap = new HashMap<String, JamAnnotationMeta>();
    private final PsiElementRef<PsiAnnotation> myPsiAnnotationRef;
    protected PsiAnchor myPsiAnchor;

    protected QsCacheElement(@NotNull PsiElementRef<?> psiRef, @NotNull String annoName) {
        if (psiRef == null) {
            QsCacheElement.$$$reportNull$$$0(0);
        }
        if (annoName == null) {
            QsCacheElement.$$$reportNull$$$0(1);
        }
        this((PsiModifierListOwner)Objects.requireNonNull(psiRef.getPsiElement()), annoName);
    }

    protected QsCacheElement(@NotNull PsiModifierListOwner psiMember, @NotNull String annoName) {
        if (psiMember == null) {
            QsCacheElement.$$$reportNull$$$0(2);
        }
        if (annoName == null) {
            QsCacheElement.$$$reportNull$$$0(3);
        }
        this.myPsiAnnotationRef = QsCacheElement.getMeta(annoName).getAnnotationRef(psiMember);
        this.myPsiAnchor = PsiAnchor.create((PsiElement)psiMember);
    }

    public QsCacheElement(PsiAnnotation psiAnnotation) {
        this.myPsiAnnotationRef = PsiElementRef.real((PsiElement)psiAnnotation);
    }

    @Nullable
    public final PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.getPsiAnnotationRef().getPsiElement();
    }

    protected PsiElementRef<PsiAnnotation> getPsiAnnotationRef() {
        return this.myPsiAnnotationRef;
    }

    @NotNull
    private static synchronized JamAnnotationMeta getMeta(@NotNull String anno) {
        JamAnnotationMeta meta;
        if (anno == null) {
            QsCacheElement.$$$reportNull$$$0(4);
        }
        if ((meta = annotationMetaMap.get(anno)) == null) {
            meta = new JamAnnotationMeta(anno);
            annotationMetaMap.put(anno, meta);
        }
        JamAnnotationMeta jamAnnotationMeta = meta;
        if (jamAnnotationMeta == null) {
            QsCacheElement.$$$reportNull$$$0(5);
        }
        return jamAnnotationMeta;
    }

    public boolean isValid() {
        return this.myPsiAnnotationRef.isValid();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QsCacheElement element = (QsCacheElement)o;
        return Objects.equals(this.myPsiAnnotationRef, element.myPsiAnnotationRef);
    }

    public int hashCode() {
        return Objects.hash(this.myPsiAnnotationRef);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRef";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/quarkus/jam/cache/model/QsCacheElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/quarkus/jam/cache/model/QsCacheElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMeta";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

