/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.analyser;

import com.intellij.charts.analyser.checkers.BarSeriesChecker;
import com.intellij.charts.analyser.checkers.LineSeriesChecker;
import com.intellij.charts.analyser.checkers.PieSeriesChecker;
import com.intellij.charts.analyser.checkers.ScatterSeriesChecker;
import com.intellij.charts.analyser.checkers.SeriesChecker;
import com.intellij.charts.analyser.checkers.StockSeriesChecker;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.settings.data.SeriesSettings;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/charts/analyser/SeriesSuggester;", "", "<init>", "()V", "checkers", "", "Lcom/intellij/charts/analyser/checkers/SeriesChecker;", "[Lcom/intellij/charts/analyser/checkers/SeriesChecker;", "getSuggestions", "", "Lcom/intellij/charts/settings/data/SeriesSettings;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getSingleSuggestion", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nSeriesSuggester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesSuggester.kt\ncom/intellij/charts/analyser/SeriesSuggester\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,31:1\n13805#2,2:32\n*S KotlinDebug\n*F\n+ 1 SeriesSuggester.kt\ncom/intellij/charts/analyser/SeriesSuggester\n*L\n22#1:32,2\n*E\n"})
public final class SeriesSuggester {
    @NotNull
    public static final SeriesSuggester INSTANCE = new SeriesSuggester();
    @NotNull
    private static SeriesChecker[] checkers;

    private SeriesSuggester() {
    }

    @NotNull
    public final List<SeriesSettings> getSuggestions(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (dataFrame.getRowsCount() < 2) {
            return CollectionsKt.emptyList();
        }
        ArrayList suggestions = new ArrayList();
        SeriesChecker[] $this$forEach$iv = checkers;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SeriesChecker element$iv;
            SeriesChecker it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            suggestions.addAll(it.check(dataFrame));
        }
        return suggestions;
    }

    @NotNull
    public final List<SeriesSettings> getSingleSuggestion(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        List<SeriesSettings> suggestions = this.getSuggestions(dataFrame);
        return suggestions.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)CollectionsKt.first(suggestions));
    }

    static {
        SeriesChecker[] seriesCheckerArray = new SeriesChecker[]{new StockSeriesChecker(), new BarSeriesChecker(), new LineSeriesChecker(), new ScatterSeriesChecker(), new PieSeriesChecker()};
        checkers = seriesCheckerArray;
    }
}

