/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.series;

import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.settings.data.ColumnModifierType;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.LineSeriesSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.LineSeriesType;
import com.intellij.charts.settings.data.type.SeriesType;
import com.intellij.charts.settings.series.SeriesBlock;
import com.intellij.charts.settings.ui.TokenFieldColumn;
import com.intellij.charts.utils.ChartMessagesBundle;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lcom/intellij/charts/settings/series/LineSeriesPanel;", "Lcom/intellij/charts/settings/series/SeriesBlock;", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "settings", "Lcom/intellij/charts/settings/data/LineSeriesSettings;", "<init>", "(Lcom/intellij/charts/dataframe/DataFrame;Lcom/intellij/charts/settings/data/LineSeriesSettings;)V", "type", "Lcom/intellij/charts/settings/data/type/SeriesType;", "getType", "()Lcom/intellij/charts/settings/data/type/SeriesType;", "xColumn", "Lcom/intellij/charts/settings/ui/TokenFieldColumn;", "groupsColumn", "yColumn", "groupingField", "getGroupingField", "()Lcom/intellij/charts/settings/ui/TokenFieldColumn;", "aggregationFields", "", "getAggregationFields", "()Ljava/util/List;", "steppedCheckBox", "Ljavax/swing/JCheckBox;", "showPointsCheckBox", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "getSeriesSettings", "Lcom/intellij/charts/settings/data/SeriesSettings;", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nLineSeriesPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineSeriesPanel.kt\ncom/intellij/charts/settings/series/LineSeriesPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1869#2,2:94\n1869#2,2:96\n1869#2,2:98\n*S KotlinDebug\n*F\n+ 1 LineSeriesPanel.kt\ncom/intellij/charts/settings/series/LineSeriesPanel\n*L\n60#1:94,2\n61#1:96,2\n62#1:98,2\n*E\n"})
public final class LineSeriesPanel
extends SeriesBlock {
    @NotNull
    private final SeriesType type;
    @NotNull
    private final TokenFieldColumn xColumn;
    @NotNull
    private final TokenFieldColumn groupsColumn;
    @NotNull
    private final TokenFieldColumn yColumn;
    @NotNull
    private final TokenFieldColumn groupingField;
    @NotNull
    private final List<TokenFieldColumn> aggregationFields;
    @NotNull
    private final JCheckBox steppedCheckBox;
    @NotNull
    private final JCheckBox showPointsCheckBox;
    @NotNull
    private final JComponent component;

    /*
     * WARNING - void declaration
     */
    public LineSeriesPanel(@NotNull DataFrame dataFrame, @NotNull LineSeriesSettings settings) {
        ColumnSettings it;
        void $this$yColumn_u24lambda_u240;
        TokenFieldColumn $this$groupsColumn_u24lambda_u240;
        TokenFieldColumn $this$xColumn_u24lambda_u240;
        TokenFieldColumn tokenFieldColumn;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.type = LineSeriesType.Companion.getInstance();
        TokenFieldColumn tokenFieldColumn2 = tokenFieldColumn = new TokenFieldColumn(dataFrame.getColumns());
        LineSeriesPanel lineSeriesPanel = this;
        boolean bl = false;
        $this$xColumn_u24lambda_u240.setType(ColumnModifierType.Grouping);
        $this$xColumn_u24lambda_u240.setAcceptDrops(true);
        $this$xColumn_u24lambda_u240.addListener(this);
        lineSeriesPanel.xColumn = tokenFieldColumn;
        $this$xColumn_u24lambda_u240 = tokenFieldColumn = new TokenFieldColumn(dataFrame.getColumns());
        lineSeriesPanel = this;
        boolean bl2 = false;
        $this$groupsColumn_u24lambda_u240.setType(ColumnModifierType.None);
        $this$groupsColumn_u24lambda_u240.setAcceptDrops(true);
        $this$groupsColumn_u24lambda_u240.addListener(this);
        lineSeriesPanel.groupsColumn = tokenFieldColumn;
        $this$groupsColumn_u24lambda_u240 = tokenFieldColumn = new TokenFieldColumn(dataFrame.getColumns());
        lineSeriesPanel = this;
        boolean bl3 = false;
        $this$yColumn_u24lambda_u240.setType(ColumnModifierType.Aggregation);
        $this$yColumn_u24lambda_u240.setAcceptDrops(true);
        $this$yColumn_u24lambda_u240.addListener(this);
        lineSeriesPanel.yColumn = tokenFieldColumn;
        this.groupingField = this.xColumn;
        this.aggregationFields = CollectionsKt.listOf((Object)this.yColumn);
        this.steppedCheckBox = new JCheckBox();
        this.showPointsCheckBox = new JCheckBox();
        this.steppedCheckBox.setSelected(settings.getStepped());
        this.steppedCheckBox.addActionListener(arg_0 -> LineSeriesPanel._init_$lambda$0(this, arg_0));
        this.showPointsCheckBox.setSelected(settings.getShowPoints());
        this.showPointsCheckBox.addActionListener(arg_0 -> LineSeriesPanel._init_$lambda$1(this, arg_0));
        this.getShowLegendCheckBox().setSelected(settings.getShowLegend());
        this.getShowLegendCheckBox().addActionListener(arg_0 -> LineSeriesPanel._init_$lambda$2(this, arg_0));
        Iterable $this$forEach$iv = settings.getKeys();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ColumnSettings)element$iv;
            boolean bl4 = false;
            TokenFieldColumn.addColumn$default(this.xColumn, it, false, null, 6, null);
        }
        $this$forEach$iv = settings.getGroups();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ColumnSettings)element$iv;
            boolean bl5 = false;
            TokenFieldColumn.addColumn$default(this.groupsColumn, it, false, null, 6, null);
        }
        $this$forEach$iv = settings.getValues();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ColumnSettings)element$iv;
            boolean bl6 = false;
            TokenFieldColumn.addColumn$default(this.yColumn, it, false, null, 6, null);
        }
        SeriesBlock.Companion.addOnlyNumericValidator(this.yColumn, dataFrame, this);
        this.component = (JComponent)BuilderKt.panel(arg_0 -> LineSeriesPanel._init_$lambda$6(this, arg_0));
    }

    @Override
    @NotNull
    public SeriesType getType() {
        return this.type;
    }

    @Override
    @NotNull
    protected TokenFieldColumn getGroupingField() {
        return this.groupingField;
    }

    @Override
    @NotNull
    protected List<TokenFieldColumn> getAggregationFields() {
        return this.aggregationFields;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public SeriesSettings getSeriesSettings() {
        return new LineSeriesSettings(this.xColumn.getColumnSettings(), this.groupsColumn.getColumnSettings(), this.yColumn.getColumnSettings(), this.steppedCheckBox.isSelected(), this.showPointsCheckBox.isSelected(), this.getShowLegendCheckBox().isSelected());
    }

    private static final void _init_$lambda$0(LineSeriesPanel this$0, ActionEvent it) {
        this$0.settingsChanged();
    }

    private static final void _init_$lambda$1(LineSeriesPanel this$0, ActionEvent it) {
        this$0.settingsChanged();
    }

    private static final void _init_$lambda$2(LineSeriesPanel this$0, ActionEvent it) {
        this$0.settingsChanged();
    }

    private static final Unit _init_$lambda$6(LineSeriesPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LineSeriesPanel.lambda$6$0(this$0, arg_0), (int)1, null).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LineSeriesPanel.lambda$6$1(this$0, arg_0), (int)1, null).bottomGap(BottomGap.SMALL);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LineSeriesPanel.lambda$6$2(this$0, arg_0), (int)1, null);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        $this$panel.row(ChartMessagesBundle.message("line.stepped", new Object[0]), arg_0 -> LineSeriesPanel.lambda$6$3(this$0, arg_0));
        $this$panel.row(ChartMessagesBundle.message("line.showPoints", new Object[0]), arg_0 -> LineSeriesPanel.lambda$6$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0(LineSeriesPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(ChartMessagesBundle.message("line.axisX", new Object[0])).widthGroup("A").align((Align)AlignY.TOP.INSTANCE);
        $this$row.cell((JComponent)this$0.xColumn).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$1(LineSeriesPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(ChartMessagesBundle.message("line.groups", new Object[0])).widthGroup("A").align((Align)AlignY.TOP.INSTANCE);
        $this$row.cell((JComponent)this$0.groupsColumn).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$2(LineSeriesPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(ChartMessagesBundle.message("line.axisY", new Object[0])).widthGroup("A").align((Align)AlignY.TOP.INSTANCE);
        $this$row.cell((JComponent)this$0.yColumn).resizableColumn().align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$3(LineSeriesPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.steppedCheckBox);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$4(LineSeriesPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.showPointsCheckBox);
        return Unit.INSTANCE;
    }
}

