/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.jetbrains.relocated.apache.batik.svggen.DOMTreeManager;
import org.jetbrains.relocated.apache.batik.svggen.ErrorConstants;
import org.jetbrains.relocated.apache.batik.svggen.SVGGeneratorContext;
import org.jetbrains.relocated.apache.batik.svggen.SVGGraphics2DIOException;
import org.jetbrains.relocated.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ImageCacher
implements SVGSyntax,
ErrorConstants {
    DOMTreeManager domTreeManager = null;
    Map imageCache = new HashMap();
    Checksum checkSum = new Adler32();

    public ImageCacher() {
    }

    public ImageCacher(DOMTreeManager domTreeManager) {
        this();
        this.setDOMTreeManager(domTreeManager);
    }

    public void setDOMTreeManager(DOMTreeManager domTreeManager) {
        if (domTreeManager == null) {
            throw new IllegalArgumentException();
        }
        this.domTreeManager = domTreeManager;
    }

    public DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    public String lookup(ByteArrayOutputStream os, int width2, int height, SVGGeneratorContext ctx2) throws SVGGraphics2DIOException {
        int checksum = this.getChecksum(os.toByteArray());
        Integer key = checksum;
        String href2 = null;
        Object data = this.getCacheableData(os);
        LinkedList<ImageCacheEntry> list2 = (LinkedList<ImageCacheEntry>)this.imageCache.get(key);
        if (list2 == null) {
            list2 = new LinkedList<ImageCacheEntry>();
            this.imageCache.put(key, list2);
        } else {
            ListIterator i = list2.listIterator(0);
            while (i.hasNext()) {
                ImageCacheEntry entry = (ImageCacheEntry)i.next();
                if (entry.checksum != checksum || !this.imagesMatch(entry.src, data)) continue;
                href2 = entry.href;
                break;
            }
        }
        if (href2 == null) {
            ImageCacheEntry newEntry = this.createEntry(checksum, data, width2, height, ctx2);
            list2.add(newEntry);
            href2 = newEntry.href;
        }
        return href2;
    }

    abstract Object getCacheableData(ByteArrayOutputStream var1);

    abstract boolean imagesMatch(Object var1, Object var2) throws SVGGraphics2DIOException;

    abstract ImageCacheEntry createEntry(int var1, Object var2, int var3, int var4, SVGGeneratorContext var5) throws SVGGraphics2DIOException;

    int getChecksum(byte[] data) {
        this.checkSum.reset();
        this.checkSum.update(data, 0, data.length);
        return (int)this.checkSum.getValue();
    }

    public static class External
    extends ImageCacher {
        private String imageDir;
        private String prefix;
        private String suffix;

        public External(String imageDir, String prefix, String suffix) {
            this.imageDir = imageDir;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        Object getCacheableData(ByteArrayOutputStream os) {
            return os;
        }

        @Override
        boolean imagesMatch(Object o1, Object o2) throws SVGGraphics2DIOException {
            boolean match = false;
            FileInputStream imageStream = null;
            try {
                imageStream = new FileInputStream((File)o1);
                int imageLen = imageStream.available();
                byte[] imageBytes = new byte[imageLen];
                byte[] candidateBytes = ((ByteArrayOutputStream)o2).toByteArray();
                for (int bytesRead = 0; bytesRead != imageLen; bytesRead += imageStream.read(imageBytes, bytesRead, imageLen - bytesRead)) {
                }
                match = Arrays.equals(imageBytes, candidateBytes);
            }
            catch (IOException e) {
                throw new SVGGraphics2DIOException("could not read image File " + ((File)o1).getName());
            }
            finally {
                try {
                    if (imageStream != null) {
                        imageStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return match;
        }

        @Override
        ImageCacheEntry createEntry(int checksum, Object data, int width2, int height, SVGGeneratorContext ctx2) throws SVGGraphics2DIOException {
            File imageFile = null;
            try {
                while (imageFile == null) {
                    String fileId = ctx2.idGenerator.generateID(this.prefix);
                    imageFile = new File(this.imageDir, fileId + this.suffix);
                    if (!imageFile.exists()) continue;
                    imageFile = null;
                }
                FileOutputStream outputStream = new FileOutputStream(imageFile);
                ((ByteArrayOutputStream)data).writeTo(outputStream);
                ((ByteArrayOutputStream)data).close();
            }
            catch (IOException e) {
                throw new SVGGraphics2DIOException("could not write image File " + imageFile.getName());
            }
            return new ImageCacheEntry(checksum, imageFile, imageFile.getName());
        }
    }

    public static class Embedded
    extends ImageCacher {
        @Override
        public void setDOMTreeManager(DOMTreeManager domTreeManager) {
            if (this.domTreeManager != domTreeManager) {
                this.domTreeManager = domTreeManager;
                this.imageCache = new HashMap();
            }
        }

        @Override
        Object getCacheableData(ByteArrayOutputStream os) {
            return "data:image/png;base64," + os.toString();
        }

        @Override
        boolean imagesMatch(Object o1, Object o2) {
            return o1.equals(o2);
        }

        @Override
        ImageCacheEntry createEntry(int checksum, Object data, int width2, int height, SVGGeneratorContext ctx2) {
            String id = ctx2.idGenerator.generateID("image");
            this.addToTree(id, (String)data, width2, height, ctx2);
            return new ImageCacheEntry(checksum, data, "#" + id);
        }

        private void addToTree(String id, String href2, int width2, int height, SVGGeneratorContext ctx2) {
            Document domFactory = this.domTreeManager.getDOMFactory();
            Element imageElement = domFactory.createElementNS("http://www.w3.org/2000/svg", "image");
            imageElement.setAttributeNS(null, "id", id);
            imageElement.setAttributeNS(null, "width", Integer.toString(width2));
            imageElement.setAttributeNS(null, "height", Integer.toString(height));
            imageElement.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", href2);
            this.domTreeManager.addOtherDef(imageElement);
        }
    }

    private static class ImageCacheEntry {
        public int checksum;
        public Object src;
        public String href;

        ImageCacheEntry(int checksum, Object src, String href2) {
            this.checksum = checksum;
            this.src = src;
            this.href = href2;
        }
    }
}

