/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ApplicationKt;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.ConnectionRequestor;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.api.GatewayConnectionProvider;
import com.jetbrains.gateway.internal.LinkedProxyConnectionProvider;
import com.jetbrains.gateway.thinClientLink.LinkedClientManager;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J,\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/gateway/internal/LinkedProxyConnectionProvider;", "Lcom/jetbrains/gateway/api/GatewayConnectionProvider;", "<init>", "()V", "isApplicable", "", "parameters", "", "", "connect", "Lcom/jetbrains/gateway/api/GatewayConnectionHandle;", "requestor", "Lcom/jetbrains/gateway/api/ConnectionRequestor;", "(Ljava/util/Map;Lcom/jetbrains/gateway/api/ConnectionRequestor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.gateway.core"})
public final class LinkedProxyConnectionProvider
implements GatewayConnectionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LINKED_PROXY_INTERNAL_CONNECTOR_TYPE = "internal_lpc";

    @Override
    public boolean isApplicable(@NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        return Intrinsics.areEqual((Object)parameters.get("type"), (Object)LINKED_PROXY_INTERNAL_CONNECTOR_TYPE) && parameters.containsKey("url") && ApplicationKt.getApplication().isInternal();
    }

    @Override
    @Nullable
    public Object connect(@NotNull Map<String, String> parameters, @NotNull ConnectionRequestor requestor, @NotNull Continuation<? super GatewayConnectionHandle> $completion) {
        String string = parameters.get("url");
        if (string == null) {
            return null;
        }
        String url = string;
        URI initialLink = URI.create(url);
        LinkedClientManager linkedClientManager = LinkedClientManager.Companion.getInstance();
        Lifetime lifetime = (Lifetime)LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)ApplicationKt.getApplication()));
        Intrinsics.checkNotNull((Object)initialLink);
        ThinClientHandle clientHandle = linkedClientManager.startNewClient(lifetime, initialLink, initialLink.getHost(), LINKED_PROXY_INTERNAL_CONNECTOR_TYPE, (Function0<Unit>)((Function0)LinkedProxyConnectionProvider::connect$lambda$0));
        return new GatewayConnectionHandle(clientHandle, url){
            final /* synthetic */ ThinClientHandle $clientHandle;
            final /* synthetic */ String $url;
            {
                this.$clientHandle = $clientHandle;
                this.$url = $url;
                super($clientHandle);
            }

            public String getTitle() {
                return GatewayBundle.INSTANCE.message("internal.dialog.title.linked.client.proxy", new Object[0]);
            }

            public boolean hideToTrayOnStart() {
                return false;
            }

            public JComponent createComponent() {
                return (JComponent)BuilderKt.panel(arg_0 -> connect.2.createComponent$lambda$0(this.$url, this.$clientHandle, arg_0));
            }

            private static final Unit createComponent$lambda$0(String $url, ThinClientHandle $clientHandle, Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, arg_0 -> connect.2.createComponent$lambda$0$0($url, $clientHandle, arg_0), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, arg_0 -> connect.2.createComponent$lambda$0$1($clientHandle, arg_0), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, arg_0 -> connect.2.createComponent$lambda$0$2($clientHandle, arg_0), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, arg_0 -> connect.2.createComponent$lambda$0$3($clientHandle, arg_0), (int)1, null);
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$0(String $url, ThinClientHandle $clientHandle, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                Cell tf = $this$row.textField();
                Ref.ObjectRef check = new Ref.ObjectRef();
                ((JBTextField)tf.getComponent()).setText($url);
                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.update.link", new Object[0]), arg_0 -> connect.2.createComponent$lambda$0$0$0($clientHandle, tf, check, arg_0));
                check.element = $this$row.checkBox(GatewayBundle.INSTANCE.message("internal.linked.proxy.checkbox.force", new Object[0])).getComponent();
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$0$0(ThinClientHandle $clientHandle, Cell $tf, Ref.ObjectRef $check, ActionEvent it) {
                JCheckBox jCheckBox;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = ((JBTextField)$tf.getComponent()).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                URI uRI = URI.create(((Object)StringsKt.trim((CharSequence)string)).toString());
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                if ($check.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"check");
                    jCheckBox = null;
                } else {
                    jCheckBox = (JCheckBox)$check.element;
                }
                $clientHandle.updateJoinLink(uRI, jCheckBox.isSelected());
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$1(ThinClientHandle $clientHandle, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.put.client.in.reconnect.mode", new Object[0]), arg_0 -> connect.2.createComponent$lambda$0$1$0($clientHandle, arg_0));
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$1$0(ThinClientHandle $clientHandle, ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $clientHandle.notifyReconnect();
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$2(ThinClientHandle $clientHandle, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.request.focus.on.client", new Object[0]), arg_0 -> connect.2.createComponent$lambda$0$2$0($clientHandle, arg_0));
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$2$0(ThinClientHandle $clientHandle, ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $clientHandle.focusClientWindow();
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$3(ThinClientHandle $clientHandle, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.button(GatewayBundle.INSTANCE.message("internal.linked.proxy.button.close.client", new Object[0]), arg_0 -> connect.2.createComponent$lambda$0$3$0($clientHandle, arg_0));
                return Unit.INSTANCE;
            }

            private static final Unit createComponent$lambda$0$3$0(ThinClientHandle $clientHandle, ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $clientHandle.close();
                return Unit.INSTANCE;
            }
        };
    }

    private static final Unit connect$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/internal/LinkedProxyConnectionProvider$Companion;", "", "<init>", "()V", "LINKED_PROXY_INTERNAL_CONNECTOR_TYPE", "", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

