/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/console/AnsiFragment;", "", "pos", "", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "<init>", "(ILjava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;)V", "getPos", "()I", "getText", "()Ljava/lang/String;", "getContentType", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "untilPos", "getUntilPos", "split", "Lkotlin/Pair;", "tailFragmentFromPos", "subFragment", "fromPos", "intellij.javascript.debugger.backend"})
final class AnsiFragment {
    private final int pos;
    @NotNull
    private final String text;
    @NotNull
    private final ConsoleViewContentType contentType;

    public AnsiFragment(int pos, @NotNull String text, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.pos = pos;
        this.text = text;
        this.contentType = contentType;
    }

    public final int getPos() {
        return this.pos;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final ConsoleViewContentType getContentType() {
        return this.contentType;
    }

    public final int getUntilPos() {
        return this.pos + this.text.length();
    }

    @NotNull
    public final Pair<AnsiFragment, AnsiFragment> split(int tailFragmentFromPos) {
        return new Pair((Object)this.subFragment(this.pos, tailFragmentFromPos), (Object)this.subFragment(tailFragmentFromPos, this.getUntilPos()));
    }

    @NotNull
    public final AnsiFragment subFragment(int fromPos, int untilPos) {
        String string = this.text.substring(fromPos - this.pos, this.text.length() - (this.getUntilPos() - untilPos));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new AnsiFragment(fromPos, string, this.contentType);
    }
}

