/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsp.JspManager;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.jsp.impl.TldTagDescriptor;
import com.intellij.jsp.javaee.web.tld.TaglibIndex;
import com.intellij.jsp.javaee.web.tld.TaglibUriCacheProvider;
import com.intellij.jsp.javaee.web.tld.TaglibsModificationTracker;
import com.intellij.jsp.javaee.web.tld.TldProcessorFactory;
import com.intellij.jsp.javaee.web.tld.TldProvider;
import com.intellij.jsp.lang.jsp.BaseJspManager;
import com.intellij.jsp.psi.BaseJspUtil;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JspManagerImpl
extends JspManager
implements Disposable {
    @NonNls
    private static final String RELATIVE_PATH_NS_PREFIX = "urn:jsptld:";
    @NonNls
    public static final String[] myTagLibProviderNames = new String[]{"function-class", "tag-class", "tei-class", "variable-class", "type", "path", "function-signature", "name", "name-given", "handler-class", "library-class", "tag-name", "function-name", "source"};
    private final Project myProject;
    private final Object[] myDependencies;

    public XmlNSDescriptor getActionsLibrary(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            JspManagerImpl.$$$reportNull$$$0(0);
        }
        return BaseJspManager.getInstance(this.myProject).getActionsLibrary(this.getJspVersion((PsiFileSystemItem)containingFile));
    }

    public XmlElementDescriptor getDirectiveDescriptorByName(String name, @NotNull PsiFile context) {
        if (context == null) {
            JspManagerImpl.$$$reportNull$$$0(1);
        }
        return BaseJspManager.getInstance(this.myProject).getDirectiveDescriptorByName(name, this.getJspVersion((PsiFileSystemItem)context));
    }

    public static JspManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            JspManagerImpl.$$$reportNull$$$0(2);
        }
        return (JspManagerImpl)JspManager.getInstance((Project)project);
    }

    private void visitTaglibFiles(@NotNull JspFile context, TaglibFileVisitor visitor) {
        Module module;
        if (context == null) {
            JspManagerImpl.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null) {
            Collection<XmlFile> files = this.getPossibleTldFiles(module);
            for (XmlFile file : files) {
                TldDescriptor xmlNSDescriptor;
                String uri = TaglibUriCacheProvider.getUri(file);
                XmlDocument document = file.getDocument();
                if (uri == null || document == null || (xmlNSDescriptor = (TldDescriptor)document.getMetaData()) == null) continue;
                visitor.visit(uri, xmlNSDescriptor, document);
            }
        }
    }

    @NotNull
    public Set<String> getNamespacesByTagName(final @NotNull String tagName, @NotNull JspFile context, boolean showProgress) {
        if (tagName == null) {
            JspManagerImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JspManagerImpl.$$$reportNull$$$0(5);
        }
        final LinkedHashSet<String> strings = new LinkedHashSet<String>();
        this.visitTaglibFiles(context, new TaglibFileVisitor(){

            @Override
            public void visit(@NotNull String uri, @NotNull TldDescriptor descriptor, @NotNull XmlDocument document) {
                XmlElementDescriptor[] descriptors;
                if (uri == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (XmlElementDescriptor elementDescriptor : descriptors = descriptor.getRootElementsDescriptors(document)) {
                    if (!(elementDescriptor instanceof TldTagDescriptor) || !tagName.equals(elementDescriptor.getDefaultName())) continue;
                    strings.add(uri);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "uri";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jsp/javaee/web/JspManagerImpl$1";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LinkedHashSet<String> linkedHashSet = strings;
        if (linkedHashSet == null) {
            JspManagerImpl.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<String> getNamespacesByFunctionName(final @NotNull String functionName, @NotNull JspFile context, boolean showProgress) {
        if (functionName == null) {
            JspManagerImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JspManagerImpl.$$$reportNull$$$0(8);
        }
        final LinkedHashSet<String> strings = new LinkedHashSet<String>();
        this.visitTaglibFiles(context, new TaglibFileVisitor(){

            @Override
            public void visit(@NotNull String uri, @NotNull TldDescriptor descriptor, @NotNull XmlDocument document) {
                String[] names;
                if (uri == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (String name : names = descriptor.getFunctionNames()) {
                    if (name == null || !name.equals(functionName)) continue;
                    strings.add(uri);
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "uri";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jsp/javaee/web/JspManagerImpl$2";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LinkedHashSet<String> linkedHashSet = strings;
        if (linkedHashSet == null) {
            JspManagerImpl.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    public ModificationTracker getRootsModificationTracker() {
        return ProjectRootManager.getInstance((Project)this.myProject);
    }

    public JspManagerImpl(Project project) {
        this.myProject = project;
        TaglibsModificationTracker taglibsModificationTracker = new TaglibsModificationTracker(project, this);
        this.myDependencies = new Object[]{this.getRootsModificationTracker(), taglibsModificationTracker, ExternalResourceManager.getInstance()};
    }

    public void dispose() {
    }

    private MultiMap<String, String> computeTagNames(Module module) {
        Collection<XmlFile> files = this.getPossibleTldFiles(module);
        MultiMap map = MultiMap.createConcurrent();
        for (XmlFile file : files) {
            XmlElementDescriptor[] descriptors;
            String uri = TaglibUriCacheProvider.getUri(file);
            if (StringUtil.isEmpty((String)uri)) continue;
            XmlDocument document = file.getDocument();
            assert (document != null);
            XmlNSDescriptor xmlNSDescriptor = (XmlNSDescriptor)document.getMetaData();
            if (xmlNSDescriptor == null) continue;
            for (XmlElementDescriptor elementDescriptor : descriptors = xmlNSDescriptor.getRootElementsDescriptors(document)) {
                if (!(elementDescriptor instanceof TldTagDescriptor)) continue;
                map.putValue((Object)elementDescriptor.getDefaultName(), (Object)uri);
            }
        }
        return map;
    }

    public Project getProject() {
        return this.myProject;
    }

    private UriFactoryMap getTaglibUrisMap(@NotNull Module module, @Nullable JspFile context) {
        if (module == null) {
            JspManagerImpl.$$$reportNull$$$0(10);
        }
        Key<CachedValue<UriFactoryMap>> key = TldProcessorFactory.getUserDataKey(context);
        return (UriFactoryMap)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, key, () -> new CachedValueProvider.Result((Object)new UriFactoryMap(() -> module, null, TldProvider.ALL), this.myDependencies), false);
    }

    @NotNull
    public JspVersion getJspVersion(@NotNull PsiFileSystemItem file) {
        WebFacet webFacet;
        if (file == null) {
            JspManagerImpl.$$$reportNull$$$0(11);
        }
        JspVersion jspVersion = (webFacet = WebUtil.getWebFacet((VirtualFile)file.getVirtualFile(), (Project)file.getProject())) == null ? JspVersion.MAX_VERSION : webFacet.getWebAppVersion().getJspVersion();
        if (jspVersion == null) {
            JspManagerImpl.$$$reportNull$$$0(12);
        }
        return jspVersion;
    }

    public boolean isElIgnored(@NotNull PsiFile file) {
        if (file == null) {
            JspManagerImpl.$$$reportNull$$$0(13);
        }
        return WebUtil.processMatchingJspGroups((PsiFile)file, group -> {
            Boolean value = (Boolean)group.getElIgnored().getValue();
            return value == null || value == false;
        });
    }

    public XmlFile getImplicitXmlTagLibraryFile() {
        return BaseJspUtil.getResource("jspxml.tld", this.myProject, ((Object)((Object)this)).getClass());
    }

    public String[] getPossibleTldUris(JspFile context) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        UriFactoryMap map = this.getTaglibUrisMap(module, context);
        if (!map.isCompleted()) {
            JspManagerImpl.processUris(module, map, context);
        }
        return map.getUris();
    }

    @NotNull
    public MultiMap<String, String> getAvailableTagNames(@NotNull JspFile context) {
        Module module;
        if (context == null) {
            JspManagerImpl.$$$reportNull$$$0(14);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            return new MultiMap();
        }
        MultiMap map = (MultiMap)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)module, Key.create((String)"jsp tag names"), () -> new CachedValueProvider.Result(this.computeTagNames(module), this.myDependencies), false);
        MultiMap multiMap = map == null ? new MultiMap() : map;
        if (multiMap == null) {
            JspManagerImpl.$$$reportNull$$$0(15);
        }
        return multiMap;
    }

    @NotNull
    public List<Pair<String, String>> getAvailableFunctions(@NotNull JspFile context) {
        if (context == null) {
            JspManagerImpl.$$$reportNull$$$0(16);
        }
        final ArrayList<Pair<String, String>> set = new ArrayList<Pair<String, String>>();
        this.visitTaglibFiles(context, new TaglibFileVisitor(){

            @Override
            public void visit(@NotNull String uri, @NotNull TldDescriptor descriptor, @NotNull XmlDocument document) {
                String[] names;
                if (uri == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (document == null) {
                    3.$$$reportNull$$$0(2);
                }
                for (String name : names = descriptor.getFunctionNames()) {
                    set.add(Pair.create((Object)name, (Object)uri));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "uri";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jsp/javaee/web/JspManagerImpl$3";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<Pair<String, String>> arrayList = set;
        if (arrayList == null) {
            JspManagerImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public String getPrefixForNamespace(@NotNull String namespaceUri, @NotNull JspFile context) {
        Module module;
        if (namespaceUri == null) {
            JspManagerImpl.$$$reportNull$$$0(18);
        }
        if (context == null) {
            JspManagerImpl.$$$reportNull$$$0(19);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            return null;
        }
        UriFactoryMap map = this.getTaglibUrisMap(module, context);
        XmlFile xmlFile = map.get(namespaceUri);
        return xmlFile == null ? null : this.getDefaultPrefix(xmlFile);
    }

    public String getDefaultPrefix(@NotNull XmlFile taglibFile) {
        TldDescriptor descriptor;
        XmlDocument document;
        if (taglibFile == null) {
            JspManagerImpl.$$$reportNull$$$0(20);
        }
        if ((document = taglibFile.getDocument()) != null && (descriptor = (TldDescriptor)document.getMetaData()) != null) {
            return descriptor.getDefaultPrefix();
        }
        return null;
    }

    public String[] getPossibleTldUris(@NotNull Module module) {
        UriFactoryMap map;
        if (module == null) {
            JspManagerImpl.$$$reportNull$$$0(21);
        }
        if (!(map = this.getTaglibUrisMap(module, null)).isCompleted()) {
            JspManagerImpl.processUris(module, map, null);
        }
        return map.getUris();
    }

    @NotNull
    public @Unmodifiable Collection<XmlFile> getPossibleTldFiles(@NotNull Module module) {
        UriFactoryMap map;
        if (module == null) {
            JspManagerImpl.$$$reportNull$$$0(22);
        }
        if (!(map = this.getTaglibUrisMap(module, null)).isCompleted()) {
            JspManagerImpl.processUris(module, map, null);
        }
        List list = ContainerUtil.filter(map.values(), Objects::nonNull);
        if (list == null) {
            JspManagerImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    public String getTaglibUri(@NotNull XmlFile taglibFile) {
        if (taglibFile == null) {
            JspManagerImpl.$$$reportNull$$$0(24);
        }
        return TaglibUriCacheProvider.getUri(taglibFile);
    }

    private static void processUris(@NotNull Module module, UriFactoryMap map, @Nullable JspFile context) {
        if (module == null) {
            JspManagerImpl.$$$reportNull$$$0(25);
        }
        for (TldProvider provider : TldProvider.ALL) {
            provider.collectUris(module, map, context);
        }
        map.setCompleted(true);
    }

    @Nullable
    public XmlFile getTldFileByUri(String uri, @NotNull JspFile jspFile) {
        if (jspFile == null) {
            JspManagerImpl.$$$reportNull$$$0(26);
        }
        return this.getTldFileByUri(uri, ModuleUtilCore.findModuleForPsiElement((PsiElement)jspFile), jspFile);
    }

    @Nullable
    public synchronized XmlFile getTldFileByUri(String uri, @Nullable Module module, @Nullable JspFile context) {
        XmlFile xmlFile;
        UriFactoryMap map;
        if (module == null || module.isDisposed()) {
            return null;
        }
        boolean local = StringUtil.startsWithChar((CharSequence)uri, (char)'.');
        if (!local && uri.startsWith(RELATIVE_PATH_NS_PREFIX)) {
            uri = uri.substring(RELATIVE_PATH_NS_PREFIX.length());
            local = true;
        }
        if (!local && (map = this.getTaglibUrisMap(module, context)) != null && (xmlFile = (XmlFile)map.get(uri)) != null) {
            return xmlFile;
        }
        if (context != null) {
            Key<CachedValue<UriFactoryMap>> key = TldProcessorFactory.getUserDataKey(context);
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)context);
            UriFactoryMap map2 = (UriFactoryMap)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)context, key, () -> {
                WebFacet webFacet = WebUtil.getWebFacet((PsiElement)context);
                if (webFacet == null) {
                    return new CachedValueProvider.Result(null, this.myDependencies);
                }
                return new CachedValueProvider.Result((Object)new UriFactoryMap(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)context), (SmartPsiElementPointer<? extends JspFile>)pointer, TldProvider.MAPPED, TldProvider.LOCAL, TldProvider.WEB), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.getRootsModificationTracker(), ExternalResourceManager.getInstance()});
            }, false);
            return map2 == null ? null : map2.get(uri);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 12, 15, 17, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/JspManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 10: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceUri";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taglibFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jspFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/JspManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesByTagName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacesByFunctionName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJspVersion";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTagNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFunctions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTldFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionsLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectiveDescriptorByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitTaglibFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesByTagName";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 23: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacesByFunctionName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTaglibUrisMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getJspVersion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isElIgnored";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTagNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableFunctions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixForNamespace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrefix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTldUris";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTldFiles";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTaglibUri";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processUris";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTldFileByUri";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 12, 15, 17, 23 -> new IllegalStateException(string);
        };
    }

    private static interface TaglibFileVisitor {
        public void visit(@NotNull String var1, @NotNull TldDescriptor var2, @NotNull XmlDocument var3);
    }

    public static class UriFactoryMap
    implements Map<String, XmlFile> {
        @Nullable
        private final SmartPsiElementPointer<? extends JspFile> myContext;
        private final TldProvider[] myProviders;
        private final Supplier<? extends Module> myModuleProducer;
        private boolean myCompleted;
        private final Map<String, XmlFile> map = FactoryMap.createMap(this::create, () -> Collections.synchronizedMap(new HashMap()));

        public UriFactoryMap(Supplier<? extends Module> moduleProducer, @Nullable SmartPsiElementPointer<? extends JspFile> context, TldProvider ... providers) {
            this.myModuleProducer = moduleProducer;
            this.myContext = context;
            this.myProviders = providers;
        }

        protected XmlFile create(String key) {
            Module module = this.myModuleProducer.get();
            if (module == null) {
                return null;
            }
            for (TldProvider provider : this.myProviders) {
                VirtualFile virtualFile;
                XmlFile file = provider.getTldFileByUri(key, module, this.myContext == null ? null : (JspFile)this.myContext.getElement());
                if (file == null || "http://java.sun.com/JSP/Page".equals(key) && ((virtualFile = file.getVirtualFile()) == null || TaglibIndex.isFaceletsTaglib(virtualFile))) continue;
                return file;
            }
            return null;
        }

        @Override
        @Nullable
        public XmlFile get(Object uri) {
            XmlFile xmlFile = this.map.get(uri);
            if (xmlFile != null && !TaglibUriCacheProvider.isUpToDate(xmlFile)) {
                this.map.remove(uri);
                return this.map.get(uri);
            }
            return xmlFile;
        }

        @Override
        @Nullable
        public XmlFile put(String key, XmlFile value) {
            VirtualFile file;
            if (value == null) {
                return null;
            }
            if ("http://java.sun.com/JSP/Page".equals(key) && ((file = value.getVirtualFile()) == null || TaglibIndex.isFaceletsTaglib(file))) {
                return value;
            }
            return this.map.put(key, value);
        }

        @Override
        public XmlFile remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public void putAll(@NotNull Map<? extends String, ? extends XmlFile> m) {
            if (m == null) {
                UriFactoryMap.$$$reportNull$$$0(0);
            }
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<XmlFile> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, XmlFile>> entrySet() {
            return this.map.entrySet();
        }

        String[] getUris() {
            ArrayList<String> set = new ArrayList<String>(this.map.keySet());
            ArrayList<String> list = new ArrayList<String>(set.size());
            for (String s : set) {
                if (this.get(s) == null) continue;
                list.add(s);
            }
            return ArrayUtilRt.toStringArray(list);
        }

        public boolean isCompleted() {
            return this.myCompleted;
        }

        public void setCompleted(boolean completed) {
            this.myCompleted = completed;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/jsp/javaee/web/JspManagerImpl$UriFactoryMap", "putAll"));
        }
    }
}

