/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class WebXmlVersionParameterFactory
extends ProjectTemplateParameterFactory {
    public static final String WEB_XML_VERSION = "WEB_XML_VERSION";
    static final String WEB_XML_VERSION_FILE = "WEB_XML_VERSION_FILE";

    public String getParameterId() {
        return WEB_XML_VERSION;
    }

    @Nullable
    public WizardInputField createField(String defaultValue) {
        return new WizardInputField(this, this.getParameterId(), defaultValue){
            final ComboBox myComboBox = new ComboBox();
            {
                for (ConfigFileVersion version : DeploymentDescriptorsConstants.WEB_XML_META_DATA.getVersions()) {
                    this.myComboBox.addItem((Object)version.getName());
                }
                this.myComboBox.addItem((Object)WebBundle.message("no.descriptor", new Object[0]));
                ConfigFileVersion defaultVersion = DeploymentDescriptorsConstants.WEB_XML_META_DATA.getDefaultVersion();
                if (defaultVersion != null) {
                    this.myComboBox.setSelectedItem((Object)defaultVersion);
                }
            }

            public String getLabel() {
                return WebBundle.message("label.descriptor.version", new Object[0]);
            }

            public JComponent getComponent() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)this.myComboBox, "West");
                return panel;
            }

            public String getValue() {
                return (String)this.myComboBox.getSelectedItem();
            }

            public Map<String, String> getValues() {
                HashMap<String, String> map = new HashMap<String, String>(super.getValues());
                map.put(WebXmlVersionParameterFactory.WEB_XML_VERSION_FILE, this.getValue().replace('.', '_'));
                return map;
            }

            public boolean acceptFile(File file) {
                return !"web.xml".equals(file.getName()) || !WebBundle.message("no.descriptor", new Object[0]).equals(this.getValue());
            }

            public void setValue(@Nls String value) {
                this.myComboBox.setSelectedItem((Object)value);
            }
        };
    }

    @Nullable
    public String detectParameterValue(Project project) {
        WebApp root;
        Module module = (Module)ArrayUtil.getFirstElement((Object[])ModuleManager.getInstance((Project)project).getModules());
        if (module == null) {
            return null;
        }
        Collection instances = WebFacet.getInstances((Module)module);
        if (!instances.isEmpty() && (root = ((WebFacet)instances.iterator().next()).getRoot()) != null) {
            return root.getVersion().getStringValue();
        }
        return null;
    }
}

