/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u001a\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020%H&R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000b\u0010\u0003\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/LineByLineParser;", "", "<init>", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "consumeLineTimeMs", "", "getConsumeLineTimeMs$annotations", "getConsumeLineTimeMs", "()J", "setConsumeLineTimeMs", "(J)V", "value", "", "goodLines", "getGoodLines", "()I", "setGoodLines", "(I)V", "badLines", "getBadLines", "setBadLines", "readLargeFile", "", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readFromStream", "inputStream", "Ljava/io/InputStream;", "consumeText", "text", "", "consumeLine", "line", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nLineByLineParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineByLineParser.kt\ncom/intellij/profiler/LineByLineParser\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,72:1\n29#2,3:73\n13#3:76\n*S KotlinDebug\n*F\n+ 1 LineByLineParser.kt\ncom/intellij/profiler/LineByLineParser\n*L\n51#1:73,3\n70#1:76\n*E\n"})
public abstract class LineByLineParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder buffer = new StringBuilder();
    @Nullable
    private LineSeparator lineSeparator;
    private long consumeLineTimeMs;
    private int goodLines;
    private int badLines;
    @NotNull
    private static final Logger LOG;

    public final long getConsumeLineTimeMs() {
        return this.consumeLineTimeMs;
    }

    public final void setConsumeLineTimeMs(long l) {
        this.consumeLineTimeMs = l;
    }

    public static /* synthetic */ void getConsumeLineTimeMs$annotations() {
    }

    public final int getGoodLines() {
        return this.goodLines;
    }

    protected final void setGoodLines(int n) {
        this.goodLines = n;
    }

    public final int getBadLines() {
        return this.badLines;
    }

    protected final void setBadLines(int n) {
        this.badLines = n;
    }

    public final void readLargeFile(@NotNull File file, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.readFromStream(new FileInputStream(file), indicator);
    }

    public final void readFromStream(@NotNull InputStream inputStream, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte[] buf = new byte[0x200000];
        int bytesRead;
        while ((bytesRead = inputStream.read(buf)) > 0) {
            this.consumeText(new String(buf, 0, bytesRead, Charsets.UTF_8), indicator);
        }
        return;
    }

    public final void consumeText(@NotNull String text, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.buffer.append(text);
        if (this.lineSeparator == null) {
            this.lineSeparator = StringUtil.detectSeparators((CharSequence)this.buffer);
            if (this.lineSeparator == null) {
                return;
            }
        }
        int index = 0;
        LineSeparator lineSeparator = this.lineSeparator;
        Intrinsics.checkNotNull((Object)lineSeparator);
        index = this.buffer.lastIndexOf(lineSeparator.getSeparatorString());
        if (index == -1) {
            return;
        }
        int start = 0;
        while (true) {
            LineSeparator lineSeparator2 = this.lineSeparator;
            Intrinsics.checkNotNull((Object)lineSeparator2);
            index = this.buffer.indexOf(lineSeparator2.getSeparatorString(), start);
            if (index == -1) break;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            long l = this.consumeLineTimeMs;
            LineByLineParser lineByLineParser = this;
            boolean bl = false;
            try {
                ProgressIndicator progressIndicator = indicator;
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                String string = this.buffer.substring(start, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.consumeLine(string);
            }
            catch (Exception e) {
                LOG.error("in LineByLineParser.consumeLine, line = '" + this.buffer.substring(start, index) + "'", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
            lineByLineParser.consumeLineTimeMs = l + (System.currentTimeMillis() - start$iv);
            LineSeparator lineSeparator3 = this.lineSeparator;
            Intrinsics.checkNotNull((Object)lineSeparator3);
            start = index + lineSeparator3.getSeparatorString().length();
        }
        this.buffer.delete(0, start);
    }

    public static /* synthetic */ void consumeText$default(LineByLineParser lineByLineParser, String string, ProgressIndicator progressIndicator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: consumeText");
        }
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        lineByLineParser.consumeText(string, progressIndicator);
    }

    public abstract void consumeLine(@NotNull String var1);

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LineByLineParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/LineByLineParser$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.common"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

