/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.util.containers.ContainerUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class DockerRunConfigurationConverter
extends ProjectConverter {
    private static final String TAG_DEPLOYMENT = "deployment";
    private static final String ATTR_FACTORYNAME = "factoryName";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_PATH = "path";

    DockerRunConfigurationConverter() {
    }

    @NotNull
    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new ConversionProcessor<RunManagerSettings>(this){

            public boolean isConversionNeeded(RunManagerSettings settings) {
                return ContainerUtil.exists((Iterable)settings.getRunConfigurations(), DockerRunConfigurationConverter::isDocker172RunConfigurationElement);
            }

            public void process(RunManagerSettings settings) throws CannotConvertException {
                settings.getRunConfigurations().stream().filter(DockerRunConfigurationConverter::isDocker172RunConfigurationElement).forEach(DockerRunConfigurationConverter::convertDocker172RunConfigurationElement);
            }
        };
    }

    private static boolean isDocker172RunConfigurationElement(Element element) {
        return "docker-deploy".equals(element.getAttributeValue(ATTR_TYPE)) && "Docker Deployment".equals(element.getAttributeValue(ATTR_FACTORYNAME)) && element.getChild(TAG_DEPLOYMENT) != null;
    }

    private static void convertDocker172RunConfigurationElement(Element runConfig) {
        String path2;
        Element deployment = runConfig.getChild(TAG_DEPLOYMENT);
        assert (deployment != null);
        String deploymentType = deployment.getAttributeValue(ATTR_TYPE);
        if (deploymentType != null) {
            runConfig.setAttribute(ATTR_FACTORYNAME, deploymentType);
        }
        if ((path2 = deployment.getAttributeValue(ATTR_PATH)) != null) {
            deployment.removeAttribute(ATTR_PATH);
            Element settings = DockerRunConfigurationConverter.findOrCreateChild(deployment, "settings");
            settings.addContent(new Element("option").setAttribute("name", "sourceFilePath").setAttribute("value", path2));
        }
    }

    @NotNull
    private static Element findOrCreateChild(@NotNull Element parent, @NotNull String tag) {
        Element result2;
        if (parent == null) {
            DockerRunConfigurationConverter.$$$reportNull$$$0(0);
        }
        if (tag == null) {
            DockerRunConfigurationConverter.$$$reportNull$$$0(1);
        }
        if ((result2 = parent.getChild(tag)) == null) {
            result2 = new Element(tag);
        }
        Element element = result2;
        if (element == null) {
            DockerRunConfigurationConverter.$$$reportNull$$$0(2);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/conversion/DockerRunConfigurationConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/conversion/DockerRunConfigurationConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateChild";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

