/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.execution;

import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.ml.inline.completion.impl.configuration.RedCodePolicy;
import com.intellij.ml.inline.completion.impl.postprocessing.MLCompletionPipelineProvider;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.SequentialProposalsAnalyzer;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.CloudControlModelFilter;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.NotValuableFilter;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import com.intellij.ml.llm.completion.cloud.CloudCompletionRequest;
import com.intellij.ml.llm.completion.cloud.settings.CloudCompletionSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/completion/cloud/execution/CloudCompletionPipelineProvider;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineProvider;", "request", "Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;", "<init>", "(Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;)V", "redCodePolicy", "Lcom/intellij/ml/inline/completion/impl/configuration/RedCodePolicy;", "getRedCodePolicy", "()Lcom/intellij/ml/inline/completion/impl/configuration/RedCodePolicy;", "maxSuggestionsForAnalysis", "", "getMaxSuggestionsForAnalysis", "()I", "minLengthForNotValuableFilter", "getMinLengthForNotValuableFilter", "isFromDirectCall", "", "(Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;)Z", "relaxedFilters", "getRelaxedFilters", "()Z", "getAnalyzer", "Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/SequentialProposalsAnalyzer;", "patchSoftFilters", "", "filters", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter;", "lastLine", "", "intellij.ml.llm.completion"})
public final class CloudCompletionPipelineProvider
extends MLCompletionPipelineProvider {
    @NotNull
    private final CloudCompletionRequest request;

    public CloudCompletionPipelineProvider(@NotNull CloudCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(request);
        this.request = request;
    }

    @Override
    @NotNull
    protected RedCodePolicy getRedCodePolicy() {
        return CloudCompletionSettings.Companion.getInstance().getState().getPolicy().getRedCodePolicy();
    }

    @Override
    protected int getMaxSuggestionsForAnalysis() {
        return 1;
    }

    public final int getMinLengthForNotValuableFilter() {
        return this.request.getLanguageKit().getLanguageSettings().getMinLengthForNotValuableFilter();
    }

    private final boolean isFromDirectCall(CloudCompletionRequest $this$isFromDirectCall) {
        return $this$isFromDirectCall.getParameters().getInlineRequest().getEvent() instanceof InlineCompletionEvent.DirectCall;
    }

    @Override
    protected boolean getRelaxedFilters() {
        CloudCompletionSettings.State settings = CloudCompletionSettings.Companion.getInstance().getState();
        if (settings.getBypassFiltersOnDirectCall() && this.isFromDirectCall(this.request)) {
            return true;
        }
        if (settings.getPolicy().getIgnoreSoftFilters()) {
            return true;
        }
        return super.getRelaxedFilters();
    }

    @Override
    @NotNull
    protected SequentialProposalsAnalyzer getAnalyzer() {
        return new SequentialProposalsAnalyzer(this.request.getLanguageKit(), this.request.getParameters(), this.request.getSessionLogger(), this.getRedCodePolicy());
    }

    @Override
    protected void patchSoftFilters(@NotNull List<ProposalFilter> filters2, @NotNull String lastLine) {
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)lastLine, (String)"lastLine");
        filters2.add(CloudControlModelFilter.INSTANCE);
        filters2.add(new NotValuableFilter(this.getMinLengthForNotValuableFilter(), this.request.getParameters()));
    }
}

