/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltSymbolIndex;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XsltChooseByNameContributor
implements ChooseByNameContributorEx {
    XsltChooseByNameContributor() {
    }

    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor == null) {
            XsltChooseByNameContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            XsltChooseByNameContributor.$$$reportNull$$$0(1);
        }
        FileBasedIndex.getInstance().processAllKeys(XsltSymbolIndex.NAME, processor, scope, filter);
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            XsltChooseByNameContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            XsltChooseByNameContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            XsltChooseByNameContributor.$$$reportNull$$$0(4);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)parameters.getProject());
        FileBasedIndex.getInstance().processValues(XsltSymbolIndex.NAME, (Object)name, null, (file, kind) -> {
            if (kind == null) {
                return true;
            }
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null || !XsltSupport.isXsltFile(psiFile)) {
                return true;
            }
            XmlTag root = ((XmlFile)psiFile).getRootTag();
            if (root == null) {
                return true;
            }
            JBIterable tags = kind == XsltSymbolIndex.Kind.ANYTHING ? JBIterable.empty().append((Object[])root.findSubTags("variable", "http://www.w3.org/1999/XSL/Transform")).append((Object[])root.findSubTags("param", "http://www.w3.org/1999/XSL/Transform")).append((Object[])root.findSubTags("template", "http://www.w3.org/1999/XSL/Transform")) : JBIterable.of((Object[])root.findSubTags(StringUtil.toLowerCase((String)kind.name()), "http://www.w3.org/1999/XSL/Transform"));
            return tags.processEach(tag -> {
                XsltElement el = kind.wrap((XmlTag)tag);
                if (el instanceof PsiNamedElement && el instanceof NavigationItem && name.equals(((PsiNamedElement)el).getName())) {
                    return processor.process((Object)((NavigationItem)el));
                }
                return true;
            });
        }, parameters.getSearchScope(), parameters.getIdFilter());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XsltChooseByNameContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

