/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.welcome;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.ultimate.welcome.WelcomeScreenPanel;
import com.intellij.profiler.ultimate.welcome.WelcomeScreenPanelKt;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\t\u001a\u0004\u0018\u00010\u0010H\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/ultimate/welcome/PercentageRender;", "Lcom/intellij/ui/CellRendererPanel;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "()V", "label", "Lcom/intellij/ui/components/JBLabel;", "fillColor", "Lcom/intellij/ui/JBColor;", "value", "", "Ljava/lang/Integer;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "", "selected", "", "hasFocus", "row", "column", "formatText", "", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.profiler.ultimate"})
final class PercentageRender
extends CellRendererPanel
implements TableCellRenderer {
    @NotNull
    private final JBLabel label = new JBLabel();
    @NotNull
    private final JBColor fillColor = new JBColor(12769014, 4543843);
    @Nullable
    private Integer value = 0;

    public PercentageRender() {
        super((LayoutManager)new BorderLayout());
        this.label.setBorder((Border)JBUI.Borders.emptyRight((int)WelcomeScreenPanel.Companion.getINDENT()));
        this.label.setHorizontalAlignment(4);
        this.add((Component)this.label);
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.value = value instanceof Integer ? (Integer)value : null;
        this.label.setText(this.formatText(value));
        this.setBackground(WelcomeScreenPanelKt.access$getBackgroundColor(WelcomeScreenPanelKt.access$getProcessForRow(table2, row), selected));
        this.setSelected(selected);
        return (Component)((Object)this);
    }

    @NlsSafe
    private final String formatText(Object value) {
        Object object = value;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        return object;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Integer v = this.value;
        Rectangle b = this.getBounds();
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        if (this.getBackground() != null) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, b.width, b.height);
        }
        if (v != null) {
            g2d.setColor((Color)this.fillColor);
            int clipWidth = b.width - this.label.getInsets().right * 3 / 4;
            int fillWidth = RangesKt.coerceAtLeast((int)((int)((double)v.intValue() / 100.0 * (double)clipWidth)), (int)(v > 0 ? 1 : 0));
            int pad = JBUIScale.scale((int)2);
            g2d.fillRect(clipWidth - fillWidth, pad, fillWidth, b.height - 2 * pad);
        }
        g2d.dispose();
    }
}

