/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.io.UnsupportedEncodingException;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IArrayElementParser;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

final class UTFStringParser
implements IArrayElementParser<String>,
IValueReader {
    private static final String CHARSET = "UTF-8";
    public static final UTFStringParser INSTANCE = new UTFStringParser();

    UTFStringParser() {
    }

    @Override
    public Object readValue(ByteBufferWrapper bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        return UTFStringParser.readString(bytes, offset);
    }

    @Override
    public String readElement(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        return UTFStringParser.readString(bytes, offset);
    }

    public static String readString(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        int len = DataInputToolkit.readUnsignedShort(bytes, offset.get());
        offset.increase(2);
        int index = offset.get();
        offset.increase(len);
        byte[] buf = new byte[len];
        bytes.position(index);
        bytes.get(buf);
        try {
            return new String(buf, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] createArray(int length) {
        return new String[length];
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.PLAIN_TEXT;
    }
}

