/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.docker.agent.DockerConnectionInfo;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.agent.util.InternalUtilsKt;
import com.intellij.docker.agent.util.ParametersListParser;
import com.intellij.docker.agent.util.Platform;
import com.intellij.docker.agent.util.UtilsKt;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\t\u001a\b\u0010\u000f\u001a\u0004\u0018\u00010\t\u001a\n\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002\u001a\f\u0010\u0011\u001a\u00020\b*\u00020\bH\u0002\u001a\f\u0010\u0012\u001a\u00020\b*\u00020\bH\u0002\u001a\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0002\u001a\n\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0002\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\t*\u00020\bH\u0007\u001a4\u0010\u0017\u001a\u00020\u0018*\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180\u001cH\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "createEnvVars", "", "", "Lcom/intellij/docker/agent/DockerConnectionInfo;", "DOCKER_OPTS_FILE_PATH", "DOCKER_OPTS_INIT_VAR_PREFIX", "TLS_CERT_OPTION", "HOST_OPTION_LONG", "HOST_OPTION", "loadDockerConnectionDefaults", "fromEnvVars", "replaceAnyHost", "replaceLinuxHome", "loadLines", "", "fromDockerOptsFile", "parseInitVar", "iterateOptionKeyValues", "", "keySet", "", "handler", "Lkotlin/Function2;", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerConnectionInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerConnectionInfo.kt\ncom/intellij/docker/agent/DockerConnectionInfoKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,128:1\n774#2:129\n865#2,2:130\n1869#2,2:133\n1#3:132\n8#4:135\n*S KotlinDebug\n*F\n+ 1 DockerConnectionInfo.kt\ncom/intellij/docker/agent/DockerConnectionInfoKt\n*L\n74#1:129\n74#1:130,2\n110#1:133,2\n12#1:135\n*E\n"})
public final class DockerConnectionInfoKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(DockerConnectionInfoKt::logger_delegate$lambda$0);
    @NotNull
    private static final String DOCKER_OPTS_FILE_PATH = "/etc/default/docker";
    @NotNull
    private static final String DOCKER_OPTS_INIT_VAR_PREFIX = "DOCKER_OPTS=";
    @NotNull
    private static final String TLS_CERT_OPTION = "--tlscert";
    @NotNull
    private static final String HOST_OPTION_LONG = "--host";
    @NotNull
    private static final String HOST_OPTION = "-H";

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public static final Map<String, String> createEnvVars(@NotNull DockerConnectionInfo $this$createEnvVars) {
        Map result2;
        block1: {
            String it;
            Intrinsics.checkNotNullParameter((Object)$this$createEnvVars, (String)"<this>");
            result2 = new LinkedHashMap();
            String string = InternalUtilsKt.nullize($this$createEnvVars.getApiUrl());
            if (string != null) {
                it = string;
                boolean bl = false;
                result2.put("DOCKER_HOST", DockerComposeUtilsKt.fixApiUrlSchema(it));
            }
            String string2 = InternalUtilsKt.nullize($this$createEnvVars.getCertificatesPath());
            if (string2 == null) break block1;
            it = string2;
            boolean bl = false;
            result2.put("DOCKER_TLS_VERIFY", "1");
            result2.put("DOCKER_CERT_PATH", it);
        }
        return MapsKt.toMap((Map)result2);
    }

    @Nullable
    public static final DockerConnectionInfo loadDockerConnectionDefaults() {
        DockerConnectionInfo dockerConnectionInfo = DockerConnectionInfoKt.fromEnvVars();
        if (dockerConnectionInfo == null) {
            dockerConnectionInfo = DockerConnectionInfoKt.fromDockerOptsFile();
        }
        return dockerConnectionInfo;
    }

    private static final DockerConnectionInfo fromEnvVars() {
        String string = System.getenv("DOCKER_HOST");
        if (string == null) {
            return null;
        }
        String dockerHost = string;
        String certificatesPath = System.getenv("DOCKER_TLS_VERIFY") != null ? System.getenv("DOCKER_CERT_PATH") : null;
        String string2 = InternalUtilsKt.nullize(certificatesPath);
        return new DockerConnectionInfo(DockerConnectionInfoKt.replaceAnyHost(dockerHost), string2 != null ? DockerConnectionInfoKt.replaceLinuxHome(string2) : null);
    }

    private static final String replaceAnyHost(String $this$replaceAnyHost) {
        return StringsKt.replace$default((String)$this$replaceAnyHost, (String)"0.0.0.0", (String)"127.0.0.1", (boolean)false, (int)4, null);
    }

    private static final String replaceLinuxHome(String $this$replaceLinuxHome) {
        return Platform.INSTANCE.isUnix() && StringsKt.startsWith$default((String)$this$replaceLinuxHome, (String)"~", (boolean)false, (int)2, null) ? System.getProperty("user.home") + StringsKt.substringAfter$default((String)$this$replaceLinuxHome, (String)"~", null, (int)2, null) : $this$replaceLinuxHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> loadLines() throws IOException {
        List list;
        InputStream stream = new FileInputStream(DOCKER_OPTS_FILE_PATH);
        Closeable closeable = new InputStreamReader(stream, Charset.defaultCharset());
        Throwable throwable = null;
        try {
            InputStreamReader reader = (InputStreamReader)closeable;
            boolean bl = false;
            list = TextStreamsKt.readLines((Reader)reader);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final DockerConnectionInfo fromDockerOptsFile() {
        Object object;
        if (!Platform.INSTANCE.isLinux()) {
            return null;
        }
        try {
            Object object2;
            block5: {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = DockerConnectionInfoKt.loadLines();
                boolean $i$f$filter = false;
                Object object3 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)DOCKER_OPTS_INIT_VAR_PREFIX, (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (String line : (Iterable)((List)destination$iv$iv)) {
                    boolean bl = false;
                    object3 = DockerConnectionInfoKt.parseInitVar(UtilsKt.unquote(StringsKt.substringAfter$default((String)line, (String)DOCKER_OPTS_INIT_VAR_PREFIX, null, (int)2, null)));
                    if (object3 == null) continue;
                    object2 = object3;
                    break block5;
                }
                object2 = null;
            }
            object = object2;
        }
        catch (IOException e) {
            DockerConnectionInfoKt.getLogger().debug(e.getMessage(), (Throwable)e);
            object = null;
        }
        return object;
    }

    @VisibleForTesting
    @Nullable
    public static final DockerConnectionInfo parseInitVar(@NotNull String $this$parseInitVar) {
        DockerConnectionInfo dockerConnectionInfo;
        Intrinsics.checkNotNullParameter((Object)$this$parseInitVar, (String)"<this>");
        Ref.ObjectRef host = new Ref.ObjectRef();
        Ref.ObjectRef certsFolder = new Ref.ObjectRef();
        Object[] objectArray = new String[]{HOST_OPTION, HOST_OPTION_LONG, TLS_CERT_OPTION};
        DockerConnectionInfoKt.iterateOptionKeyValues($this$parseInitVar, SetsKt.setOf((Object[])objectArray), (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> DockerConnectionInfoKt.parseInitVar$lambda$0(certsFolder, host, arg_0, arg_1)));
        String string = (String)host.element;
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = (String)certsFolder.element;
            dockerConnectionInfo = new DockerConnectionInfo(DockerConnectionInfoKt.replaceAnyHost(it), string2 != null ? DockerConnectionInfoKt.replaceLinuxHome(string2) : null);
        } else {
            dockerConnectionInfo = null;
        }
        return dockerConnectionInfo;
    }

    private static final void iterateOptionKeyValues(String $this$iterateOptionKeyValues, Set<String> keySet, Function2<? super String, ? super String, Unit> handler) {
        String prevKey = null;
        Iterable $this$forEach$iv = ParametersListParser.INSTANCE.parse($this$iterateOptionKeyValues);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String next = (String)element$iv;
            boolean bl = false;
            if (prevKey == null) {
                String key = InternalUtilsKt.nullize(StringsKt.substringBefore((String)next, (char)'=', (String)""));
                if (key != null) {
                    if (!keySet.contains(key)) continue;
                    handler.invoke((Object)key, (Object)StringsKt.substringAfter((String)next, (char)'=', (String)next));
                    continue;
                }
                if (!keySet.contains(next)) continue;
                prevKey = next;
                continue;
            }
            handler.invoke(prevKey, (Object)next);
            prevKey = null;
        }
    }

    private static final Logger logger_delegate$lambda$0() {
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DockerConnectionInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Unit parseInitVar$lambda$0(Ref.ObjectRef $certsFolder, Ref.ObjectRef $host, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (key) {
            case "--tlscert": {
                String mayBeFolder = StringsKt.substringBeforeLast((String)InternalUtilsKt.toSystemIndependentName(value), (char)'/', (String)"");
                if (!(((CharSequence)mayBeFolder).length() > 0)) return Unit.INSTANCE;
                $certsFolder.element = mayBeFolder;
                return Unit.INSTANCE;
            }
            case "-H": 
            case "--host": {
                $host.element = value;
                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }
}

