/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react.refactoring.extractComponent;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.jsx.tsx.TypeScriptJSXComponentUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.react.ReactBundle;
import com.intellij.react.refactoring.extractComponent.ReactExtractComponentHandlerBase;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactCreateComponentHandler
extends ReactExtractComponentHandlerBase {
    @NotNull
    private final JSXmlLiteralExpression myExpression;
    @NotNull
    private final String myComponentName;
    @NotNull
    private final ReactExtractComponentHandlerBase.ComponentType myComponentType;

    public ReactCreateComponentHandler(@NotNull JSXmlLiteralExpression expression, @NotNull String componentName, @NotNull ReactExtractComponentHandlerBase.ComponentType componentType) {
        if (expression == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(0);
        }
        if (componentName == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(1);
        }
        if (componentType == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(2);
        }
        this.myExpression = expression;
        this.myComponentName = componentName;
        this.myComponentType = componentType;
    }

    @Override
    protected void doRefactoring(@NotNull Editor editor, @NotNull Pair<? extends JSExpression, TextRange> sourceDescriptor, @NotNull PsiElement anchor, @NotNull String componentText, @NotNull ReactExtractComponentHandlerBase.ComponentToExtract component) {
        if (editor == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(3);
        }
        if (sourceDescriptor == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(4);
        }
        if (anchor == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(5);
        }
        if (componentText == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(6);
        }
        if (component == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(7);
        }
        PsiElement addedComponent = this.addDeclarations(component, editor, anchor, componentText);
        ReactCreateComponentHandler.addRequiredImports((PsiElement)sourceDescriptor.first, component);
        if (addedComponent != null) {
            this.reformatResult(editor, anchor, addedComponent);
        }
    }

    @Override
    @Nullable
    protected Pair<JSXmlLiteralExpression, TextRange> getSourceExpression(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(9);
        }
        return Pair.create((Object)this.myExpression, null);
    }

    @Override
    @NotNull
    protected Pair<Collection<ReactExtractComponentHandlerBase.Prop>, String> buildPropsAndComponentBody(@NotNull Pair<JSXmlLiteralExpression, TextRange> expressionDescriptor, @Nullable JSPsiElementBase sourceComponent, @NotNull PsiElement introductionScope, @NotNull ReactExtractComponentHandlerBase.ComponentType componentType) {
        if (expressionDescriptor == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(10);
        }
        if (introductionScope == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(11);
        }
        if (componentType == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(12);
        }
        ArrayList<ReactExtractComponentHandlerBase.Prop> props = new ArrayList<ReactExtractComponentHandlerBase.Prop>();
        JSXmlLiteralExpression sourceExpression = (JSXmlLiteralExpression)expressionDescriptor.first;
        JSRecordTypeImpl recordType = TypeScriptJSXComponentUtil.createRecordTypeFromTag((XmlTag)sourceExpression, (PsiElement)sourceExpression);
        for (JSRecordType.PropertySignature property : recordType.getProperties()) {
            String propName = property.getMemberName();
            if (propName.equals("key")) continue;
            props.add(new ReactExtractComponentHandlerBase.Prop(propName, property.getJSType(), null));
        }
        XmlTagChild[] children = sourceExpression.getValue().getChildren();
        if (children.length > 0) {
            XmlTagChild child;
            JSType type;
            ReactExtractComponentHandlerBase.Prop prop = null;
            if (children.length == 1 && (type = ReactCreateComponentHandler.getUsableExpressionType((JSExpression)PsiTreeUtil.findChildOfType((PsiElement)(child = children[0]), JSExpression.class), (PsiElement)sourceExpression)) instanceof JSFunctionType) {
                prop = new ReactExtractComponentHandlerBase.Prop("children", type, null);
            }
            if (prop == null) {
                JSType nodeType = JSNamedTypeFactory.createType((String)"ReactNode", (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)sourceExpression, (boolean)true), (JSTypeContext)JSTypeContext.STATIC);
                prop = new ReactExtractComponentHandlerBase.Prop("children", nodeType, null);
            }
            props.add(prop);
        }
        Pair pair = Pair.create(props, (Object)"null");
        if (pair == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(13);
        }
        return pair;
    }

    private static void addRequiredImports(@NotNull PsiElement context, @NotNull ReactExtractComponentHandlerBase.ComponentToExtract component) {
        boolean isReactNodeUsed;
        if (context == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(14);
        }
        if (component == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(15);
        }
        boolean bl = isReactNodeUsed = DialectDetector.isTypeScript((PsiElement)context) && component.props.stream().anyMatch(prop -> prop.name.equals("children") && JSNamedType.isNamedTypeWithName((JSType)prop.type, (String)"ReactNode"));
        if (isReactNodeUsed) {
            ReactCreateComponentHandler.importNamedElementIfNeeded("ReactNode", context, "react");
        }
    }

    @Override
    @Nullable
    protected Pair<String, ReactExtractComponentHandlerBase.ComponentType> getUserSettings(@NotNull JSElement introductionScope, @NotNull DataContext dataContext) {
        if (introductionScope == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(16);
        }
        if (dataContext == null) {
            ReactCreateComponentHandler.$$$reportNull$$$0(17);
        }
        return Pair.create((Object)this.myComponentName, (Object)((Object)this.myComponentType));
    }

    @Override
    protected String getRefactoringTitle() {
        return ReactBundle.message("refactoring.create.react.component.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentText";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/react/refactoring/extractComponent/ReactCreateComponentHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/react/refactoring/extractComponent/ReactCreateComponentHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPropsAndComponentBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildPropsAndComponentBody";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredImports";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUserSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

