/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common;

import com.intellij.jpa.jpb.model.core.util.FileUtils;
import com.intellij.liquibase.common.ChangeLogCreationResult;
import com.intellij.liquibase.common.ChangeLogWriterEP;
import com.intellij.liquibase.common.LiquibaseCommandManagerKt;
import com.intellij.liquibase.common.LiquibaseCreator;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.XmlChangeLogWriter;
import com.intellij.liquibase.common.gui.ChangeLogModel;
import com.intellij.liquibase.common.gui.ChangeModel;
import com.intellij.liquibase.common.gui.IncludeInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.SemVer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import liquibase.sdk.resource.MockResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J<\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0013H&J\b\u0010\u0016\u001a\u00020\u0017H&J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0014J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0014J<\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001a\u0010 \u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001a\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u001fH\u0014J\f\u0010&\u001a\u00020'*\u00020'H\u0004J\u001a\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u000bH\u0004J*\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u000201000/H\u0016J$\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020#2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u00104\u001a\u0004\u0018\u000105H\u0016J&\u00106\u001a\u0004\u0018\u00010\u00132\u0006\u00107\u001a\u0002082\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u001a\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u00132\b\u00104\u001a\u0004\u0018\u000105H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/liquibase/common/ChangeLogDeserializerWriter;", "Lcom/intellij/liquibase/common/ChangeLogWriterEP;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "xmlWriter", "Lcom/intellij/liquibase/common/XmlChangeLogWriter;", "writeToFile", "Lcom/intellij/liquibase/common/ChangeLogCreationResult;", "existingFile", "Lcom/intellij/psi/PsiFile;", "changeLogModel", "Lcom/intellij/liquibase/common/gui/ChangeLogModel;", "newFile", "propertyTags", "", "Lcom/intellij/psi/xml/XmlTag;", "changeSource", "", "createFileFromContent", "content", "getChangeLogSerializer", "Lliquibase/serializer/ChangeLogSerializer;", "unwrapChangesetFromChangelog", "changelogText", "unwrapChangeFromChangelog", "writeChangeLogIntoFile", "quotingStrategy", "Lcom/intellij/liquibase/common/LiquibaseCreator$ObjectQuotingStrategy;", "database", "Lliquibase/database/Database;", "convertXmlToCurrentType", "getSourceFromTree", "changeLogNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getDummyFileName", "db", "reformat", "Lcom/intellij/psi/PsiElement;", "storeFile", "formattedFile", "addIncludeChangeLog", "", "includeInfo", "Lcom/intellij/liquibase/common/gui/IncludeInfo;", "mainChangeLogToDirMap", "", "", "Lcom/intellij/psi/PsiDirectory;", "collectChangeSetSource", "changeSetNode", "liquibaseVersion", "Lcom/intellij/util/text/SemVer;", "collectChangeSource", "model", "Lcom/intellij/liquibase/common/gui/ChangeModel;", "wrapChangesetToChangelog", "changeSetText", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nChangeLogDeserializerWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeLogDeserializerWriter.kt\ncom/intellij/liquibase/common/ChangeLogDeserializerWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public abstract class ChangeLogDeserializerWriter
extends ChangeLogWriterEP {
    @NotNull
    private final XmlChangeLogWriter xmlWriter;

    public ChangeLogDeserializerWriter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.xmlWriter = new XmlChangeLogWriter(project);
    }

    @NotNull
    public abstract ChangeLogCreationResult<?> writeToFile(@Nullable PsiFile var1, @NotNull ChangeLogModel var2, @NotNull PsiFile var3, @NotNull List<? extends XmlTag> var4, @NotNull String var5);

    @NotNull
    public abstract PsiFile createFileFromContent(@NotNull ChangeLogModel var1, @NotNull String var2);

    @NotNull
    public abstract ChangeLogSerializer getChangeLogSerializer();

    @NotNull
    protected String unwrapChangesetFromChangelog(@NotNull String changelogText) {
        Intrinsics.checkNotNullParameter((Object)changelogText, (String)"changelogText");
        return changelogText;
    }

    @NotNull
    protected String unwrapChangeFromChangelog(@NotNull String changelogText) {
        Intrinsics.checkNotNullParameter((Object)changelogText, (String)"changelogText");
        return changelogText;
    }

    @Override
    @NotNull
    public ChangeLogCreationResult<?> writeChangeLogIntoFile(@NotNull ChangeLogModel changeLogModel, @NotNull String changeSource, @NotNull LiquibaseCreator.ObjectQuotingStrategy quotingStrategy, @NotNull List<? extends XmlTag> propertyTags, @Nullable Database database) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeLogModel), (String)"changeLogModel");
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        Intrinsics.checkNotNullParameter((Object)((Object)quotingStrategy), (String)"quotingStrategy");
        Intrinsics.checkNotNullParameter(propertyTags, (String)"propertyTags");
        String changeSourceUpd = quotingStrategy == LiquibaseCreator.ObjectQuotingStrategy.LEGACY ? changeSource : StringsKt.replaceFirst$default((String)changeSource, (String)".xsd\">", (String)(".xsd\" objectQuotingStrategy=\"" + quotingStrategy.name() + "\">"), (boolean)false, (int)4, null);
        String content = this.convertXmlToCurrentType(changeSourceUpd, database);
        PsiFile existingFile = this.getExistingFile(changeLogModel);
        PsiFile psiFile = this.createFileFromContent(changeLogModel, content);
        ChangeLogCreationResult<?> result = this.writeToFile(existingFile, changeLogModel, psiFile, propertyTags, changeSourceUpd);
        PsiFile includeChangeLogFile = changeLogModel.getIncludeChangeLogFile(this.getProject());
        if (includeChangeLogFile != null) {
            Object obj = result.getFile();
            Intrinsics.checkNotNull(obj);
            result.setIncludeInfo(new IncludeInfo(includeChangeLogFile, (PsiFile)obj, changeLogModel.getIncludeContext(), changeLogModel.getIncludeAsFolder()));
        }
        return result;
    }

    @Override
    @NotNull
    public String convertXmlToCurrentType(@NotNull String changeSource, @Nullable Database database) {
        Intrinsics.checkNotNullParameter((Object)changeSource, (String)"changeSource");
        return (String)LiquibaseCommandManagerKt.runWithPluginClassLoader(() -> ChangeLogDeserializerWriter.convertXmlToCurrentType$lambda$0(database, this, changeSource));
    }

    @Override
    @NotNull
    public String getSourceFromTree(@NotNull DefaultMutableTreeNode changeLogNode, @Nullable Database database) {
        Intrinsics.checkNotNullParameter((Object)changeLogNode, (String)"changeLogNode");
        return this.xmlWriter.getChangeLogText(this.xmlWriter.getSourceFromTree(changeLogNode, database), LiquibaseCreator.ObjectQuotingStrategy.QUOTE_ONLY_RESERVED_WORDS);
    }

    @NotNull
    protected String getDummyFileName(@NotNull Database db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        return "dummy.xml";
    }

    @NotNull
    protected final PsiElement reformat(@NotNull PsiElement $this$reformat) {
        Intrinsics.checkNotNullParameter((Object)$this$reformat, (String)"<this>");
        Document document = PsiDocumentManager.getInstance((Project)$this$reformat.getProject()).getDocument($this$reformat.getContainingFile());
        if (document != null) {
            Document it = document;
            boolean bl = false;
            PsiDocumentManager.getInstance((Project)$this$reformat.getProject()).doPostponedOperationsAndUnblockDocument(it);
            PsiElement psiElement = CodeStyleManager.getInstance((Project)$this$reformat.getProject()).reformat($this$reformat);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"reformat(...)");
            return psiElement;
        }
        Intrinsics.checkNotNull(null);
        return null;
    }

    @Nullable
    protected final PsiFile storeFile(@NotNull ChangeLogModel changeLogModel, @NotNull PsiFile formattedFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeLogModel), (String)"changeLogModel");
        Intrinsics.checkNotNullParameter((Object)formattedFile, (String)"formattedFile");
        PsiDirectory psiDirectory = FileUtils.Companion.getOrCreateDir(changeLogModel.getDirectoryAbsolutePath(this.getProject()), this.getProject());
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory changeLogDir = psiDirectory;
        PsiElement psiElement = changeLogDir.add((PsiElement)formattedFile);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"add(...)");
        PsiElement psiElement2 = this.reformat(psiElement);
        return psiElement2 instanceof PsiFile ? (PsiFile)psiElement2 : null;
    }

    @Override
    public void addIncludeChangeLog(@NotNull IncludeInfo includeInfo, @NotNull Map<String, Set<PsiDirectory>> mainChangeLogToDirMap) {
        Intrinsics.checkNotNullParameter((Object)includeInfo, (String)"includeInfo");
        Intrinsics.checkNotNullParameter(mainChangeLogToDirMap, (String)"mainChangeLogToDirMap");
    }

    @Override
    @NotNull
    public String collectChangeSetSource(@NotNull DefaultMutableTreeNode changeSetNode, @Nullable Database database, @Nullable SemVer liquibaseVersion) {
        Intrinsics.checkNotNullParameter((Object)changeSetNode, (String)"changeSetNode");
        String string = ChangeLogWriterEP.Companion.getInstance(this.getProject(), LiquibaseFileType.XML).collectChangeSetSource(changeSetNode, null, liquibaseVersion);
        if (string == null) {
            return "";
        }
        String xmlText = string;
        String changelogXmlText = this.wrapChangesetToChangelog(xmlText, liquibaseVersion);
        String changelogTypedText = this.convertXmlToCurrentType(changelogXmlText, database);
        String result = this.unwrapChangesetFromChangelog(changelogTypedText);
        return result;
    }

    @Override
    @Nullable
    public String collectChangeSource(@NotNull ChangeModel model2, @Nullable Database database, @Nullable SemVer liquibaseVersion) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Object object = model2.getXmlTag();
        if (object == null || (object = object.getText()) == null) {
            return null;
        }
        Object xmlText = object;
        String changelogXmlText = this.wrapChangesetToChangelog(((Object)StringsKt.trim((CharSequence)("\n    <changeSet id=\"1\" author=\"text\">\n        " + (String)xmlText + "\n    </changeSet>"))).toString(), liquibaseVersion);
        String changelogTypedText = this.convertXmlToCurrentType(changelogXmlText, database);
        String result = this.unwrapChangeFromChangelog(changelogTypedText);
        return result;
    }

    private final String wrapChangesetToChangelog(String changeSetText, SemVer liquibaseVersion) {
        Object object;
        block3: {
            block2: {
                object = liquibaseVersion;
                if (object == null) break block2;
                SemVer it = object;
                boolean bl = false;
                String string = it.getMajor() + "." + it.getMinor();
                object = string;
                if (string != null) break block3;
            }
            object = "latest";
        }
        Object schemaVersion = object;
        return ((Object)StringsKt.trim((CharSequence)("\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<databaseChangeLog\n        xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                        http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-" + (String)schemaVersion + ".xsd\"\n        objectQuotingStrategy=\"QUOTE_ONLY_RESERVED_WORDS\">\n    " + changeSetText + "\n</databaseChangeLog>\n            "))).toString();
    }

    private static final String convertXmlToCurrentType$lambda$0(Database $database, ChangeLogDeserializerWriter this$0, String $changeSource) {
        Database database = $database;
        if (database == null) {
            database = (Database)new MockDatabase();
        }
        Database db = database;
        String stubFileName = this$0.getDummyFileName(db);
        MockResourceAccessor resourceAccessor = new MockResourceAccessor(MapsKt.mapOf((Pair)TuplesKt.to((Object)stubFileName, (Object)$changeSource)));
        XMLChangeLogSAXParser parser = new XMLChangeLogSAXParser();
        ChangeLogParameters changeLogParameters = new ChangeLogParameters(db);
        changeLogParameters.setContexts(new Contexts());
        changeLogParameters.setLabels(new LabelExpression());
        DatabaseChangeLog databaseChangeLog = parser.parse(stubFileName, changeLogParameters, (ResourceAccessor)resourceAccessor);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this$0.getChangeLogSerializer().write(databaseChangeLog.getChangeSets(), (OutputStream)outputStream);
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }
}

